/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.annotations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.annotations.AnnotationLocation;

public class AnnotationResults {
    private final AnnotationInfo[] infos;
    private final AnnotationStrings[] strings;
    private final Map<FileLine, List<List<Integer>>> stringIndexesByFileLineMap;
    private final Map<OVMComplianceCheck, List<List<Integer>>> stringIndexesByCheckMap;
    private final Map<OVMComplianceCheckHit, List<List<Integer>>> stringIndexesByHitMap;
    private final List<List<Integer>> EMPTY;

    public AnnotationResults(int count) {
        this.infos = new AnnotationInfo[count];
        this.strings = new AnnotationStrings[count];
        this.EMPTY = new ArrayList<List<Integer>>(Collections.nCopies(count, Arrays.asList(-1)));
        int i = 0;
        while (i < this.strings.length) {
            this.strings[i] = new AnnotationStrings();
            ++i;
        }
        this.stringIndexesByFileLineMap = new HashMap<FileLine, List<List<Integer>>>();
        this.stringIndexesByCheckMap = new IdentityHashMap<OVMComplianceCheck, List<List<Integer>>>();
        this.stringIndexesByHitMap = new IdentityHashMap<OVMComplianceCheckHit, List<List<Integer>>>();
    }

    public void addInfo(int index, String title, Set<AnnotationLocation> locations, int type) {
        this.infos[index] = new AnnotationInfo(title, locations.stream().map(i -> i.ordinal()).collect(Collectors.toSet()), type);
    }

    public AnnotationInfo[] getInfos() {
        return this.infos;
    }

    public synchronized void addStrings(String file, int line, String[] strings) {
        ArrayList<Object> indexes = new ArrayList<Object>(Collections.nCopies(strings.length, null));
        int i = 0;
        while (i < strings.length) {
            if (strings[i] != null) {
                indexes.set(i, Arrays.asList(this.strings[i].addString(strings[i])));
            }
            ++i;
        }
        this.stringIndexesByFileLineMap.put(new FileLine(file, line), indexes);
    }

    public void addStrings(OVMComplianceCheckHit hit, List<List<String>> strings) {
        ArrayList<Object> indexes = new ArrayList<Object>(Collections.nCopies(strings.size(), null));
        int i = 0;
        while (i < strings.size()) {
            if (strings.get(i) != null) {
                int i2 = i;
                List indexList = strings.get(i).stream().map(string -> this.strings[i2].addString((String)string)).collect(Collectors.toList());
                indexes.set(i, indexList);
            }
            ++i;
        }
        this.stringIndexesByHitMap.put(hit, indexes);
    }

    public void addStrings(OVMComplianceCheck check, List<List<String>> strings) {
        ArrayList<Object> indexes = new ArrayList<Object>(Collections.nCopies(strings.size(), null));
        int i = 0;
        while (i < strings.size()) {
            if (strings.get(i) != null) {
                int i2 = i;
                List indexList = strings.get(i).stream().map(string -> this.strings[i2].addString((String)string)).collect(Collectors.toList());
                indexes.set(i, indexList);
            }
            ++i;
        }
        this.stringIndexesByCheckMap.put(check, indexes);
    }

    public List<List<Integer>> getStringIndexes(OVMComplianceCheck check) {
        List<List<Integer>> stringIndexesFromCheck = this.stringIndexesByCheckMap.get(check);
        if (stringIndexesFromCheck == null) {
            return this.EMPTY;
        }
        return stringIndexesFromCheck;
    }

    public List<List<Integer>> getStringIndexes(OVMComplianceCheckHit hit) {
        String file = hit.getParserPath().path;
        int line = hit.getLine();
        List<List<Integer>> stringIndexesFromFileLine = this.stringIndexesByFileLineMap.get(new FileLine(file, line));
        List<List<Integer>> stringIndexesFromHit = this.stringIndexesByHitMap.get(hit);
        if (stringIndexesFromFileLine == null && stringIndexesFromHit == null) {
            return this.EMPTY;
        }
        if (stringIndexesFromFileLine != null && stringIndexesFromHit == null) {
            return stringIndexesFromFileLine;
        }
        if (stringIndexesFromFileLine == null && stringIndexesFromHit != null) {
            return stringIndexesFromHit;
        }
        return this.merge(stringIndexesFromFileLine, stringIndexesFromHit);
    }

    private List<List<Integer>> merge(List<List<Integer>> stringIndexesFromFileLine, List<List<Integer>> stringIndexesFromHit) {
        if (stringIndexesFromFileLine.size() != stringIndexesFromHit.size()) {
            return this.EMPTY;
        }
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>(stringIndexesFromFileLine);
        int i = 0;
        while (i < result.size()) {
            if (result.get(i) == null) {
                result.set(i, stringIndexesFromHit.get(i));
            }
            ++i;
        }
        return result;
    }

    public AnnotationStrings[] getStrings() {
        return this.strings;
    }

    public static class AnnotationInfo {
        private final String title;
        private final Set<Integer> locations;
        private final int type;

        public AnnotationInfo(String title, Set<Integer> locations, int type) {
            this.title = title;
            this.locations = locations;
            this.type = type;
        }

        public String getTitle() {
            return this.title;
        }

        public Set<Integer> getLocations() {
            return this.locations;
        }

        public int getType() {
            return this.type;
        }

        public int hashCode() {
            return Objects.hash(this.title, this.type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnnotationInfo other = (AnnotationInfo)obj;
            return Objects.equals(this.title, other.title) && this.type == other.type;
        }
    }

    public static class AnnotationStrings {
        private Map<String, Integer> indexByStringMap = new HashMap<String, Integer>();
        private ArrayList<String> stringByIndexList = new ArrayList();

        public int addString(String string) {
            Integer index = this.indexByStringMap.get(string);
            if (index == null) {
                index = this.stringByIndexList.size();
                this.stringByIndexList.add(string);
                this.indexByStringMap.put(string, index);
            }
            return index;
        }

        public List<String> getStrings() {
            return this.stringByIndexList;
        }
    }

    private static class FileLine {
        private String file;
        private int line;

        public FileLine(String file, int line) {
            this.file = file;
            this.line = line;
        }

        public int hashCode() {
            return (31 + (this.file == null ? 0 : this.file.hashCode())) * 31 + this.line;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            if (this.line != ((FileLine)obj).line) {
                return false;
            }
            return !(this.file == null ? ((FileLine)obj).file != null : !this.file.equals(((FileLine)obj).file));
        }
    }
}

