/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.annotations;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.linter.annotations.Annotation;
import ro.amiq.vlogdt.linter.annotations.AnnotationLineProcessor;
import ro.amiq.vlogdt.linter.annotations.AnnotationResults;
import ro.amiq.vlogdt.linter.annotations.AnnotationSvnField;

public enum AnnotationSvnProcessor implements AnnotationLineProcessor
{
    INSTANCE;

    private static final int BUFFER_SIZE = 8;

    @Override
    public void process(List<Annotation> annotations, Map<String, List<Integer>> lineByFileMap, AnnotationResults results, IProgressMonitor monitor) {
        try {
            int iterations = lineByFileMap.size();
            monitor.beginTask("Gathering svn blame information...", iterations);
            if (!this.hasSVN()) {
                return;
            }
            if (monitor.isCanceled()) {
                return;
            }
            EnumMap indexesByFieldMap = new EnumMap(AnnotationSvnField.class);
            HashMap fieldsByNameMap = new HashMap();
            this.extractMapsFromAnnotationArgs(annotations, 0, indexesByFieldMap, fieldsByNameMap);
            AtomicInteger iteration = new AtomicInteger(0);
            lineByFileMap.entrySet().parallelStream().forEach(lineByFileEntry -> {
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.subTask("Running svn blame (" + iteration.incrementAndGet() + "/" + iterations + ") " + (String)lineByFileEntry.getKey());
                this.processFile((String)lineByFileEntry.getKey(), (List)lineByFileEntry.getValue(), indexesByFieldMap, fieldsByNameMap, results);
                monitor.worked(1);
            });
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Loose catch block
     */
    private void processFile(String file, List<Integer> lines, Map<AnnotationSvnField, Set<Integer>> indexByFieldMap, Map<String, AnnotationSvnField> fieldsByNameMap, AnnotationResults results) {
        block10: {
            ArrayList<String> command = new ArrayList<String>();
            command.add("svn");
            command.add("blame");
            command.add("--incremental");
            command.add("--xml");
            command.add(file);
            Process process = null;
            PushbackInputStream inputStream = null;
            try {
                process = DVTUtilsCommon.INSTANCE.startProcess(command, new File(file).getParentFile());
                inputStream = new PushbackInputStream(new BufferedInputStream(process.getInputStream()), 8);
                byte[] firstBytes = new byte[8];
                int readBytes = inputStream.read(firstBytes);
                if (readBytes != 8) {
                    firstBytes = Arrays.copyOfRange(firstBytes, 0, readBytes > 0 ? readBytes : 0);
                }
                String firstLetters = new String(firstBytes);
                inputStream.unread(firstBytes);
                if (firstLetters.startsWith("svn:")) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    throw new IllegalArgumentException(new StringBuilder(128).append("Annotation processor error!").append('\n').append("Command: ").append(String.join((CharSequence)" ", command)).append('\n').append("Output: ").append(reader.readLine()).toString());
                }
                SVNBlameXMLHandler handler = new SVNBlameXMLHandler(file, new HashSet<Integer>(lines), indexByFieldMap, fieldsByNameMap, results);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                parser.parse((InputStream)inputStream, (DefaultHandler)handler);
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                DVTUtilsCommon.INSTANCE.closeClosable(inputStream);
                DVTUtilsCommon.INSTANCE.killProcess(process);
                break block10;
            }
            catch (IllegalArgumentException | ParserConfigurationException | SAXException e) {
                DVTLogger.INSTANCE.logDebug(e.getMessage());
                DVTUtilsCommon.INSTANCE.closeClosable(inputStream);
                DVTUtilsCommon.INSTANCE.killProcess(process);
                break block10;
            }
            catch (Throwable t) {
                DVTLogger.INSTANCE.logDebug(t.getMessage());
                {
                    catch (Throwable throwable) {
                        DVTUtilsCommon.INSTANCE.closeClosable(inputStream);
                        DVTUtilsCommon.INSTANCE.killProcess(process);
                        throw throwable;
                    }
                }
                DVTUtilsCommon.INSTANCE.closeClosable(inputStream);
                DVTUtilsCommon.INSTANCE.killProcess(process);
                break block10;
            }
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)inputStream);
            DVTUtilsCommon.INSTANCE.killProcess(process);
        }
    }

    private boolean hasSVN() {
        block6: {
            BufferedReader reader;
            Process process;
            block5: {
                process = null;
                reader = null;
                try {
                    process = DVTUtilsCommon.INSTANCE.startProcess(Arrays.asList("svn", "--version"), null);
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String output = reader.lines().collect(Collectors.joining("\n"));
                    if (!output.startsWith("svn, version")) break block5;
                    DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
                }
                catch (IOException | IllegalArgumentException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    break block6;
                }
                finally {
                    DVTUtilsCommon.INSTANCE.closeClosable(reader);
                    DVTUtilsCommon.INSTANCE.killProcess(process);
                }
                DVTUtilsCommon.INSTANCE.killProcess(process);
                return true;
            }
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
            DVTUtilsCommon.INSTANCE.killProcess(process);
        }
        return false;
    }

    private static final class ParseStopException
    extends SAXException {
        private static final long serialVersionUID = 6858173762136812431L;

        private ParseStopException() {
        }
    }

    private static final class SVNBlameXMLHandler
    extends DefaultHandler {
        private final String file;
        private final Set<Integer> lines;
        private final String[] annotationStrings;
        private final Map<AnnotationSvnField, Set<Integer>> indexByFieldMap;
        private final Map<String, AnnotationSvnField> fieldsByNameMap;
        private final AnnotationResults results;
        private int currentLine;
        private AnnotationSvnField field;

        public SVNBlameXMLHandler(String file, Set<Integer> lines, Map<AnnotationSvnField, Set<Integer>> indexByFieldMap, Map<String, AnnotationSvnField> fieldsByNameMap, AnnotationResults results) {
            this.file = file;
            this.lines = lines;
            this.annotationStrings = new String[results.getInfos().length];
            this.indexByFieldMap = indexByFieldMap;
            this.fieldsByNameMap = fieldsByNameMap;
            this.results = results;
            this.currentLine = -1;
            this.field = null;
        }

        @Override
        public void startElement(String uri, String localName, String tag, Attributes attributes) throws SAXException {
            if (tag.equalsIgnoreCase("entry")) {
                try {
                    this.currentLine = Integer.parseInt(attributes.getValue("line-number"));
                }
                catch (NumberFormatException numberFormatException) {
                    this.currentLine = -1;
                }
                return;
            }
            if (!this.lines.contains(this.currentLine)) {
                return;
            }
            this.field = this.fieldsByNameMap.get(tag);
            if (this.field == AnnotationSvnField.COMMIT) {
                String revision = this.field.prettify(attributes.getValue("revision"));
                for (Integer index : this.indexByFieldMap.get(this.field)) {
                    this.annotationStrings[index.intValue()] = revision;
                }
                this.field = null;
            }
        }

        @Override
        public void endElement(String uri, String localName, String tag) throws SAXException {
            if (tag.equalsIgnoreCase("entry") && this.lines.contains(this.currentLine)) {
                this.results.addStrings(this.file, this.currentLine, this.annotationStrings);
                this.lines.remove(this.currentLine);
                if (this.lines.isEmpty()) {
                    throw new ParseStopException();
                }
            }
            this.field = null;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.field == null) {
                return;
            }
            String string = this.field.prettify(new String(ch, start, length));
            for (Integer index : this.indexByFieldMap.get(this.field)) {
                this.annotationStrings[index.intValue()] = string;
            }
        }
    }
}

