/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.annotations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.annotations.Annotation;
import ro.amiq.vlogdt.linter.annotations.AnnotationHitProcessor;
import ro.amiq.vlogdt.linter.annotations.AnnotationResults;

public enum AnnotationTagProcessor implements AnnotationHitProcessor
{
    INSTANCE;


    @Override
    public void process(List<Annotation> annotations, List<OVMComplianceCategory> categories, AnnotationResults results, IProgressMonitor monitor) {
        if (annotations == null || annotations.isEmpty()) {
            return;
        }
        HashMap<String, Set<Integer>> indexesByTagNameMap = new HashMap<String, Set<Integer>>();
        this.extractMapsFromAnnotationArgs(annotations, indexesByTagNameMap);
        for (OVMComplianceCategory category : categories) {
            for (OVMComplianceCheck check : category.getChecks()) {
                ArrayList<Object> annotationStrings = new ArrayList<Object>(Collections.nCopies(results.getInfos().length, null));
                Map<String, List<String>> annotationsByTagIdMap = check.getAnnotationsByTagIdMap();
                if (annotationsByTagIdMap == null || annotationsByTagIdMap.isEmpty()) continue;
                for (Map.Entry entry : indexesByTagNameMap.entrySet()) {
                    for (Integer index : (Set)indexesByTagNameMap.get(entry.getKey())) {
                        List<String> hitAnnotationList = annotationsByTagIdMap.get(entry.getKey());
                        if (hitAnnotationList == null || hitAnnotationList.isEmpty()) continue;
                        annotationStrings.set(index, hitAnnotationList);
                    }
                }
                results.addStrings(check, annotationStrings);
                for (OVMComplianceCheckHit hit : check.getAllHitsForRReport(false)) {
                    results.addStrings(hit, annotationStrings);
                }
            }
        }
    }

    public void extractMapsFromAnnotationArgs(List<Annotation> annotations, Map<String, Set<Integer>> indexesByTagNameMap) {
        for (Annotation annotation : annotations) {
            String tagId = annotation.getArgs().length == 0 ? annotation.getName() : (String)annotation.getArgs()[0];
            Set<Integer> indexes = indexesByTagNameMap.get(tagId);
            if (indexes == null) {
                indexes = new HashSet<Integer>();
                indexesByTagNameMap.put(tagId, indexes);
            }
            indexes.add(annotation.getIndex());
        }
    }
}

