/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.api.example.predefined;

import java.io.FileNotFoundException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.vlogdt.linter.api.ICustomRule;
import ro.amiq.vlogdt.linter.api.ILinter;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleDate;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleDescription;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleID;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleName;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleProperties;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleProperty;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleTitle;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleVersion;
import ro.amiq.vlogdt.linter.api.model.IElaboratedInstance;
import ro.amiq.vlogdt.linter.api.model.ISourceElement;
import ro.amiq.vlogdt.linter.api.model.IType;

@CustomRuleDate(value="2021-10-27")
@CustomRuleVersion(value="21.1.46")
@CustomRuleID(value="ExportDesignHierarchy")
@CustomRuleName(value="ExportDesignHierarchy")
@CustomRuleTitle(value="Export design hierarchy for specified top")
@CustomRuleDescription(value="This rule exports the design hierarchy for the top specified by the <designPath> parameter.")
@CustomRuleProperties(value={@CustomRuleProperty(key="designPath", value="", description="Exported design hierarchy's top. It can be a module name or an instance path. When a module name is specified, the first design hierarchy instance of that module will be used. When empty, all tops declared in build configuration will be used."), @CustomRuleProperty(key="dumpTo", value="file", description="Comma separated list of output options: console, file."), @CustomRuleProperty(key="filePath", value="", description="Output file's path, used when dumpTo is set to file. The path can contain environment variables."), @CustomRuleProperty(key="dumpAbsoluteDesignPaths", value="false", description="When true, the exported design hierarchy paths will be absolute."), @CustomRuleProperty(key="designInstanceNames", value="", description="Comma separated list of module or interface names. Only paths to instances of this design element will be printed.")})
public class ExportDesignHierarchyRule
implements ICustomRule {
    private static final String CONSOLE = "console";
    private static final String FILE = "file";
    private SimpleDateFormat DATE_FORMAT;
    private ILinter fLinter;

    @Override
    public void run(ILinter linter) {
        this.fLinter = linter;
        String os = System.getProperty("os.name");
        String hmsSeparator = os != null && os.toLowerCase().contains("win") ? "_" : ":";
        this.DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH" + hmsSeparator + "mm" + hmsSeparator + "ss");
        String designPath = linter.getProperties().get("designPath");
        Set<String> dumpTo = this.parse(linter.getProperties().get("dumpTo"));
        String filePath = linter.getProperties().get("filePath");
        boolean dumpAbsoluteDesignPaths = Boolean.parseBoolean(linter.getProperties().get("dumpAbsoluteDesignPaths"));
        Set<String> designInstanceNames = this.parse(linter.getProperties().get("designInstanceNames"));
        try {
            Set<IElaboratedInstance> elaboratedInstances = this.fLinter.getModel().getElaboratedInstances(designPath);
            StringBuilder message = new StringBuilder();
            for (IElaboratedInstance elaboratedInstance : elaboratedInstances) {
                String path = dumpAbsoluteDesignPaths ? elaboratedInstance.getHierarchyPath() : elaboratedInstance.getRelativeHierarchyPath();
                IType type = elaboratedInstance.getType();
                if (!designInstanceNames.isEmpty()) {
                    String name = null;
                    if (type instanceof ISourceElement) {
                        name = ((ISourceElement)((Object)type)).getName();
                    }
                    if (!designInstanceNames.contains(name)) continue;
                }
                message.append(path);
                message.append(type != null ? " : " + type : "");
                message.append(System.lineSeparator());
            }
            if (dumpTo.contains(CONSOLE)) {
                this.fLinter.print(message.toString());
                this.fLinter.infoHit(null, "Design Hierarchy exported to console!");
            }
            if (dumpTo.contains(FILE)) {
                String timeStamp = this.DATE_FORMAT.format(new Timestamp(System.currentTimeMillis()));
                if (filePath.isEmpty()) {
                    filePath = "dh_" + timeStamp + ".txt";
                }
                String outputFile = this.fLinter.printToFile(filePath, message.toString());
                this.fLinter.infoHit(null, "Design Hierarchy exported to " + outputFile + "!");
            }
        }
        catch (FileNotFoundException | IllegalArgumentException e) {
            this.fLinter.failHit(null, e.getMessage());
        }
    }

    public Set<String> parse(String value) {
        HashSet<String> result = new HashSet<String>();
        if (value == null || value.isEmpty()) {
            return result;
        }
        String[] stringArray = value.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            result.add(entry.trim());
            ++n2;
        }
        return result;
    }
}

