/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.api.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.api.ICustomRule;
import ro.amiq.vlogdt.linter.api.ILinter;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleProperty;
import ro.amiq.vlogdt.linter.api.impl.Linter;
import ro.amiq.vlogdt.parser.ReparseInfo;

public class CustomRuleWrapper
extends OVMComplianceCheck {
    private final String ID;
    private final String fDefaultName;
    private final String fDefaultTitle;
    private final String fDefaultDate;
    private final String fDefaultVersion;
    private final String fDefaultDescription;
    private final ICustomRule fCustomRule;
    private final ILinter fLinter;
    private final CustomRuleProperty[] fRulePropertyAnnotations;

    public CustomRuleWrapper(OVMProject oVMProject, OVMComplianceCategory category, ICustomRule customRule, String id, CheckStatus severity, String defaultName, String defaulTitle, String defaultDate, String defaultVersion, String defaultDescription, Map<String, String> defaultProperties, CustomRuleProperty[] rulePropertyAnnotations) {
        super(oVMProject, category, severity, defaultName, defaulTitle, defaultDate, defaultVersion, null, defaultDescription);
        this.fCustomRule = customRule;
        this.fProperties.putAll(defaultProperties);
        this.fRulePropertyAnnotations = rulePropertyAnnotations;
        this.ID = id;
        this.fDefaultName = defaultName;
        this.fDefaultTitle = defaulTitle;
        this.fDefaultDate = defaultDate;
        this.fDefaultVersion = defaultVersion;
        this.fDefaultDescription = defaultDescription;
        this.fLinter = new Linter(this);
    }

    @Override
    public String getID() {
        return this.ID;
    }

    @Override
    public String getDefaultName() {
        return this.fDefaultName;
    }

    @Override
    public String getDefaultDescription() {
        return this.fDefaultDescription;
    }

    @Override
    public String getDefaultTitle() {
        return this.fDefaultTitle;
    }

    @Override
    public String getDefaultDate(Map<String, String> versionsMap) {
        return this.fDefaultDate;
    }

    @Override
    public String getDefaultVersion() {
        return this.fDefaultVersion;
    }

    @Override
    public void performCheckImpl() {
        this.fCustomRule.run(this.fLinter);
    }

    OVMProject getLinterProject() {
        return this.fOVMProject;
    }

    void newHit(String path, int line, String message, ReparseInfo reparseInfo, CheckStatus severity) {
        if (path == null || path.trim().isEmpty() || path.trim().equals("none")) {
            path = "none";
            line = 0;
        }
        this.addHit(new ParserPath(path), line, message, reparseInfo, false, severity);
    }

    @Override
    public boolean isValidParameter(String key) {
        return true;
    }

    @Override
    public String getParametersDescription(OVMComplianceCheck.ParametersDescriptionParser parametersDescriptionParser) {
        StringBuilder result = new StringBuilder();
        CustomRuleProperty[] customRulePropertyArray = this.fRulePropertyAnnotations;
        int n = this.fRulePropertyAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            CustomRuleProperty parameter = customRulePropertyArray[n2];
            if (parametersDescriptionParser == OVMComplianceCheck.ParametersDescriptionParser.RULEPOOL_DOC) {
                result.append(this.parseParametersDescriptionForRulepoolDoc(parameter.key(), parameter.value(), parameter.description(), !parameter.required()));
            } else if (parametersDescriptionParser == OVMComplianceCheck.ParametersDescriptionParser.RULESET_DOC) {
                result.append(this.parseParametersDescriptionForRulesetDoc(parameter.key(), parameter.value(), parameter.description(), !parameter.required()));
            } else if (parametersDescriptionParser == OVMComplianceCheck.ParametersDescriptionParser.RULEPOOL_XML) {
                result.append(this.parseParametersDescriptionForRulepoolXML(parameter.key(), parameter.value(), parameter.description(), !parameter.required()));
            } else if (parametersDescriptionParser == OVMComplianceCheck.ParametersDescriptionParser.RULESET_XML) {
                result.append(this.parseParametersDescriptionForRulepoolXML(parameter.key(), parameter.value(), parameter.description(), !parameter.required()));
            }
            ++n2;
        }
        if (parametersDescriptionParser == OVMComplianceCheck.ParametersDescriptionParser.RULEPOOL_XML || parametersDescriptionParser == OVMComplianceCheck.ParametersDescriptionParser.RULESET_XML) {
            return result.toString().trim();
        }
        return result.toString();
    }

    @Override
    public List<Object> createParameters() {
        ArrayList<Object> allParametersList = new ArrayList<Object>();
        CustomRuleProperty[] customRulePropertyArray = this.fRulePropertyAnnotations;
        int n = this.fRulePropertyAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            CustomRuleProperty parameter = customRulePropertyArray[n2];
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            String defaultValue = parameter.value() != null ? parameter.value() : "";
            String description = parameter.description() != null ? parameter.description() : "";
            String required = !parameter.required() ? "optional" : "mandatory";
            description = String.valueOf(parameter.key()) + " : [" + required + "] " + description;
            parameterMap.put("name", parameter.key());
            parameterMap.put("defaultValue", defaultValue);
            parameterMap.put("description", description);
            parameterMap.put("rulesetOverriden", this.fProperties.containsKey(parameter.key()) ? "true" : "false");
            allParametersList.add(parameterMap);
            ++n2;
        }
        return allParametersList;
    }

    public Map<String, CustomRuleProperty> getAllCustomParameters() {
        HashMap<String, CustomRuleProperty> allParameters = new HashMap<String, CustomRuleProperty>();
        CustomRuleProperty[] customRulePropertyArray = this.fRulePropertyAnnotations;
        int n = this.fRulePropertyAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            CustomRuleProperty parameter = customRulePropertyArray[n2];
            allParameters.put(parameter.key(), parameter);
            ++n2;
        }
        return allParameters;
    }

    @Override
    public Map<String, Object> getRulesetInfo() {
        HashMap<String, Object> infoFromRuleset = new HashMap<String, Object>();
        String xvmPattern = "[oO][vV][mM]|[uU][vV][mM]|XVM";
        String xvmName = this.fDefaultName.replaceAll(xvmPattern, "xvm");
        String xvmTitle = this.fDefaultTitle.replaceAll(xvmPattern, "xvm");
        String xvmDescription = this.fDefaultDescription.replaceAll(xvmPattern, "xvm");
        String xvmDefaultName = this.getDefaultName().replaceAll(xvmPattern, "xvm");
        String xvmDefaultTitle = this.getDefaultTitle().replaceAll(xvmPattern, "xvm");
        String xvmDefaultDescription = this.getDefaultDescription().replaceAll(xvmPattern, "xvm");
        infoFromRuleset.put("hasName", xvmName.equals(xvmDefaultName) ? "false" : "true");
        infoFromRuleset.put("hasTitle", xvmTitle.equals(xvmDefaultTitle) ? "false" : "true");
        infoFromRuleset.put("hasDescription", xvmDescription.equals(xvmDefaultDescription) ? "false" : "true");
        infoFromRuleset.put("hasSeverity", this.getSeverity() == null || this.getSeverity().equals((Object)this.getDefaultSeverity()) ? "false" : "true");
        infoFromRuleset.put("isAutoCorrectEnabled", this.isAutoCorrectEnabled() ? "true" : "false");
        Map<String, String> checkProperties = this.getProperties();
        ArrayList propertyList = new ArrayList();
        Map<String, CustomRuleProperty> allParameters = this.getAllCustomParameters();
        for (Map.Entry<String, String> prop : checkProperties.entrySet()) {
            HashMap<String, String> tempMap = new HashMap<String, String>();
            tempMap.put("name", prop.getKey());
            tempMap.put("value", prop.getValue());
            CustomRuleProperty parameter = allParameters.get(prop.getKey());
            if (parameter == null) continue;
            String description = parameter.description() != null ? parameter.description() : "";
            String required = !parameter.required() ? "optional" : "mandatory";
            description = String.valueOf(parameter.key()) + " : [" + required + "] " + description;
            tempMap.put("description", description);
            propertyList.add(tempMap);
        }
        infoFromRuleset.put("properties", propertyList);
        return infoFromRuleset;
    }
}

