/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.api.impl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.api.ICustomRule;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleDate;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleDescription;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleID;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleName;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleProperties;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleProperty;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleSeverity;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleTitle;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleVersion;
import ro.amiq.vlogdt.linter.api.annotations.Severity;
import ro.amiq.vlogdt.linter.api.impl.APIUtils;
import ro.amiq.vlogdt.linter.api.impl.CustomRuleWrapper;

public class CustomRulesLoader {
    private final URLClassLoader fClassLoader;
    private final Set<String> fManifestRules;
    private final Map<String, Class<?>> fRulesMap;

    public CustomRulesLoader() {
        this.fClassLoader = null;
        this.fManifestRules = null;
        this.fRulesMap = null;
    }

    public CustomRulesLoader(Collection<String> existingIDs) {
        this.fClassLoader = this.createClassLoader();
        this.fManifestRules = this.collectManifestRules();
        this.fRulesMap = this.collectIDs(existingIDs);
    }

    protected URLClassLoader createClassLoader() {
        HashSet<URI> validURIs = new HashSet<URI>();
        ArrayList<URL> validURLs = new ArrayList<URL>();
        String customRulesArg = this.getCustomRulesArgs();
        if (customRulesArg != null) {
            String[] jarPaths;
            URL url = null;
            URI uri = null;
            File customRulesFile = null;
            String[] stringArray = jarPaths = customRulesArg.split(File.pathSeparator);
            int n = jarPaths.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    String customRulesPath = stringArray[n2];
                    if (!customRulesPath.trim().isEmpty()) {
                        customRulesFile = new File(customRulesPath);
                        if (!customRulesFile.canRead()) {
                            DVTLogger.INSTANCE.logError("Custom Rules Package '" + customRulesPath + "' is not readable!");
                        } else if (!(customRulesFile.getName().endsWith(".jar") && customRulesFile.isFile() || customRulesFile.isDirectory())) {
                            DVTLogger.INSTANCE.logError("Custom Rules Package '" + customRulesPath + "' is not a jar nor a directory!");
                        } else {
                            uri = customRulesFile.toURI();
                            if (validURIs.contains(uri)) {
                                DVTLogger.INSTANCE.logError("Custom Rules Package '" + customRulesPath + "' is already used!");
                            } else {
                                try {
                                    url = customRulesFile.toURI().toURL();
                                }
                                catch (MalformedURLException e) {
                                    DVTLogger.INSTANCE.logError("Custom Rules Package '" + customRulesPath + "' is not readable!", (Throwable)e);
                                    break block11;
                                }
                                validURIs.add(uri);
                                validURLs.add(url);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        return new URLClassLoader(validURLs.toArray(new URL[validURLs.size()]), this.getClass().getClassLoader());
    }

    private Set<String> collectManifestRules() {
        HashSet<String> manifestRules = new HashSet<String>();
        if (this.isDebugCustomRules()) {
            manifestRules.addAll(this.collectDebugRules());
            manifestRules.addAll(this.collectDebugRulesFromFile());
        } else {
            manifestRules.addAll(this.collectDeclaredRules());
        }
        return manifestRules;
    }

    private Set<String> collectDebugRules() {
        HashSet<String> manifestRules = new HashSet<String>();
        String debugCustomRulesArg = this.getDebugCustomRulesArgs();
        if (debugCustomRulesArg != null) {
            String[] debugRules;
            String[] stringArray = debugRules = debugCustomRulesArg.split(File.pathSeparator);
            int n = debugRules.length;
            int n2 = 0;
            while (n2 < n) {
                String debugRule = stringArray[n2];
                if (!debugRule.trim().isEmpty()) {
                    manifestRules.add(debugRule);
                }
                ++n2;
            }
        }
        return manifestRules;
    }

    private Set<String> collectDebugRulesFromFile() {
        HashSet<String> manifestRules = new HashSet<String>();
        String debugCustomRulesFromFileArg = this.getDebugCustomRulesFromFileArg();
        if (debugCustomRulesFromFileArg != null) {
            String[] debugCustomRulesFromFiles;
            File debugCustomRulesFile = null;
            BufferedReader reader = null;
            String[] stringArray = debugCustomRulesFromFiles = debugCustomRulesFromFileArg.split(File.pathSeparator);
            int n = debugCustomRulesFromFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String debugCustomRulesFromFile = stringArray[n2];
                if (!debugCustomRulesFromFile.trim().isEmpty()) {
                    debugCustomRulesFile = new File(debugCustomRulesFromFile);
                    if (!debugCustomRulesFile.canRead()) {
                        DVTLogger.INSTANCE.logError("Custom Rules Declaration File '" + debugCustomRulesFile + "' is not readable!");
                    } else {
                        try {
                            reader = new BufferedReader(new FileReader(debugCustomRulesFile));
                            manifestRules.addAll(this.collectDeclaredRulesFromReader(reader));
                        }
                        catch (IOException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
                        }
                    }
                }
                ++n2;
            }
        }
        return manifestRules;
    }

    private Set<String> collectDeclaredRules() {
        URL[] urls;
        HashSet<String> manifestRules = new HashSet<String>();
        File file = null;
        URL[] uRLArray = urls = this.getClassLoader().getURLs();
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            try {
                file = new File(url.toURI());
                if (file.getName().endsWith(".jar") && file.isFile()) {
                    manifestRules.addAll(this.collectDeclaredRulesFromJar(file));
                } else if (file.isDirectory()) {
                    manifestRules.addAll(this.collectDeclaredRulesFromDir(file));
                }
            }
            catch (URISyntaxException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            ++n2;
        }
        return manifestRules;
    }

    private Set<String> collectDeclaredRulesFromJar(File file) {
        ZipEntry entry;
        JarFile jarFile;
        BufferedReader reader;
        HashSet<String> manifestRules;
        block5: {
            manifestRules = new HashSet<String>();
            reader = null;
            jarFile = null;
            jarFile = new JarFile(file);
            entry = jarFile.getEntry("custom-rules");
            if (entry != null) break block5;
            DVTLogger.INSTANCE.logError("Custom Rules Package '" + file.toString() + "' does not contain 'custom-rules' file!");
            jarFile.close();
            HashSet<String> hashSet = manifestRules;
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
            DVTUtilsCommon.INSTANCE.closeZipFile((ZipFile)jarFile);
            return hashSet;
        }
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(entry)));
                manifestRules.addAll(this.collectDeclaredRulesFromReader(reader));
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                DVTUtilsCommon.INSTANCE.closeClosable(reader);
                DVTUtilsCommon.INSTANCE.closeZipFile((ZipFile)jarFile);
            }
        }
        catch (Throwable throwable) {
            DVTUtilsCommon.INSTANCE.closeClosable(reader);
            DVTUtilsCommon.INSTANCE.closeZipFile((ZipFile)jarFile);
            throw throwable;
        }
        DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
        DVTUtilsCommon.INSTANCE.closeZipFile((ZipFile)jarFile);
        return manifestRules;
    }

    private Set<String> collectDeclaredRulesFromDir(File dir) {
        File file;
        BufferedReader reader;
        HashSet<String> manifestRules;
        block5: {
            manifestRules = new HashSet<String>();
            reader = null;
            file = new File(dir, "custom-rules");
            if (file.canRead()) break block5;
            DVTLogger.INSTANCE.logError("Custom Rules Package '" + dir.toString() + "' does not contain a readable 'custom-rules' file!");
            HashSet<String> hashSet = manifestRules;
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
            return hashSet;
        }
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                manifestRules.addAll(this.collectDeclaredRulesFromReader(reader));
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                DVTUtilsCommon.INSTANCE.closeClosable(reader);
            }
        }
        catch (Throwable throwable) {
            DVTUtilsCommon.INSTANCE.closeClosable(reader);
            throw throwable;
        }
        DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
        return manifestRules;
    }

    private Set<String> collectDeclaredRulesFromReader(BufferedReader reader) throws IOException {
        HashSet<String> manifestRules = new HashSet<String>();
        String line = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("#")) continue;
            manifestRules.add(line);
        }
        return manifestRules;
    }

    private Map<String, Class<?>> collectIDs(Collection<String> existingIDs) {
        HashMap rulesMap = new HashMap();
        for (String className : this.getManifestRules()) {
            CustomRulesLoader.createClass(rulesMap, existingIDs, "Custom Rule", this.getClassLoader(), className);
        }
        return rulesMap;
    }

    static void createClass(Map<String, Class<?>> rulesMap, Collection<String> existingIDs, String ruleType, ClassLoader classLoader, String className) {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            Class<?>[] interfaces = clazz.getInterfaces();
            boolean found = false;
            Class<?>[] classArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interf = classArray[n2];
                if (interf == ICustomRule.class) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                DVTLogger.INSTANCE.logError(String.valueOf(ruleType) + " '" + className + "' must implement '" + ICustomRule.class.getCanonicalName() + "'!");
                return;
            }
            CustomRuleID ruleIDAnnot = clazz.getAnnotation(CustomRuleID.class);
            if (ruleIDAnnot == null) {
                DVTLogger.INSTANCE.logError(String.valueOf(ruleType) + " '" + className + "' must have the ID declared using '" + CustomRuleID.class.getCanonicalName() + "' annotation!");
                return;
            }
            String ruleID = ruleIDAnnot.value();
            Class<?> existing = rulesMap.get(ruleID);
            if (existing != null) {
                DVTLogger.INSTANCE.logError(String.valueOf(ruleType) + " '" + className + "' has the same ID with '" + existing + "' custom rule!");
                return;
            }
            if (existingIDs.contains(ruleID)) {
                DVTLogger.INSTANCE.logError(String.valueOf(ruleType) + " '" + className + "' has the same ID with an internal rule!");
                return;
            }
            rulesMap.put(ruleID, clazz);
        }
        catch (ClassNotFoundException e) {
            DVTLogger.INSTANCE.logError(String.valueOf(ruleType) + " '" + className + "' not found!", (Throwable)e);
            return;
        }
        catch (SecurityException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public OVMComplianceCheck createRule(String id, OVMProject ovmProject, OVMComplianceCategory category) {
        return CustomRulesLoader.createRuleFromClass(this.getRulesMap().get(id), id, ovmProject, category);
    }

    static OVMComplianceCheck createRuleFromClass(Class<?> clazz, String id, OVMProject ovmProject, OVMComplianceCategory category) {
        if (clazz == null) {
            return null;
        }
        CustomRuleSeverity ruleSeverityAnnot = clazz.getAnnotation(CustomRuleSeverity.class);
        Severity ruleSeverityEnum = ruleSeverityAnnot == null ? Severity.ERROR : ruleSeverityAnnot.value();
        CheckStatus ruleSeverity = CheckStatus.valueOf(ruleSeverityEnum.name());
        CustomRuleName ruleNameAnnot = clazz.getAnnotation(CustomRuleName.class);
        String ruleName = ruleNameAnnot == null ? "" : ruleNameAnnot.value();
        CustomRuleTitle ruleTitleAnnot = clazz.getAnnotation(CustomRuleTitle.class);
        String ruleTitle = ruleTitleAnnot == null ? "" : ruleTitleAnnot.value();
        CustomRuleDescription ruleDescriptionAnnot = clazz.getAnnotation(CustomRuleDescription.class);
        String ruleDescription = ruleDescriptionAnnot == null ? "" : ruleDescriptionAnnot.value();
        CustomRuleDate ruleDateAnnot = clazz.getAnnotation(CustomRuleDate.class);
        String ruleDate = ruleDateAnnot == null ? "" : ruleDateAnnot.value();
        CustomRuleVersion ruleVersionAnnot = clazz.getAnnotation(CustomRuleVersion.class);
        String ruleVersion = ruleVersionAnnot == null ? "" : ruleVersionAnnot.value();
        CustomRuleProperties rulePropertiesAnnot = clazz.getAnnotation(CustomRuleProperties.class);
        CustomRuleProperty[] rulePropertyAnnots = rulePropertiesAnnot == null ? new CustomRuleProperty[]{} : rulePropertiesAnnot.value();
        Map<String, String> ruleProperties = null;
        if (rulePropertyAnnots != null && rulePropertyAnnots.length > 0) {
            CustomRuleProperty[] customRulePropertyArray = rulePropertyAnnots;
            int n = rulePropertyAnnots.length;
            int n2 = 0;
            while (n2 < n) {
                String value;
                String key;
                CustomRuleProperty rulePropertyAnnot = customRulePropertyArray[n2];
                if (rulePropertyAnnot != null && (key = rulePropertyAnnot.key()) != null && !(key = key.trim()).isEmpty() && (value = rulePropertyAnnot.value()) != null) {
                    if (ruleProperties == null) {
                        ruleProperties = new LinkedHashMap<String, String>();
                    }
                    ruleProperties.put(key, value);
                }
                ++n2;
            }
        }
        if (ruleProperties == null) {
            ruleProperties = Collections.emptyMap();
        }
        Object customRuleObject = null;
        try {
            customRuleObject = clazz.newInstance();
        }
        catch (InstantiationException e) {
            DVTLogger.INSTANCE.logError("Could not instantiate rule with ID '" + id + "' implemented by class '" + clazz.getCanonicalName() + "'!", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            DVTLogger.INSTANCE.logError("Could not instantiate rule with ID '" + id + "' implemented by class '" + clazz.getCanonicalName() + "'!", (Throwable)e);
        }
        ICustomRule customRule = null;
        if (!(customRuleObject instanceof ICustomRule)) {
            DVTLogger.INSTANCE.logError("Could not instantiate rule with  ID '" + id + "' implemented by class '" + clazz.getCanonicalName() + "', it must implement '" + ICustomRule.class.getCanonicalName() + "'!");
        }
        customRule = customRuleObject;
        CustomRuleWrapper customRuleWrapper = new CustomRuleWrapper(ovmProject, category, customRule, id, ruleSeverity, ruleName, ruleTitle, ruleDate, ruleVersion, ruleDescription, ruleProperties, rulePropertyAnnots);
        return customRuleWrapper;
    }

    public ArrayList<OVMComplianceCategory> getCustomRulesCategory(OVMProject ovmProject) {
        ArrayList<OVMComplianceCategory> categories = new ArrayList<OVMComplianceCategory>();
        OVMComplianceCategory customRulesCategory = new OVMComplianceCategory("Custom Rules", "");
        for (String id : this.getRulesMap().keySet()) {
            this.createRule(id, ovmProject, customRulesCategory);
        }
        categories.add(customRulesCategory);
        return categories;
    }

    private String getCustomRulesArgs() {
        return APIUtils.getCustomRulesArg();
    }

    private boolean isDebugCustomRules() {
        return APIUtils.isDebugCustomRules();
    }

    private String getDebugCustomRulesArgs() {
        return APIUtils.getDebugCustomRulesArg();
    }

    private String getDebugCustomRulesFromFileArg() {
        return APIUtils.getDebugCustomRulesFromFileArg();
    }

    private URLClassLoader getClassLoader() {
        return this.fClassLoader;
    }

    private Set<String> getManifestRules() {
        return this.fManifestRules;
    }

    private Map<String, Class<?>> getRulesMap() {
        return this.fRulesMap;
    }
}

