/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.api.impl;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.api.ILinter;
import ro.amiq.vlogdt.linter.api.impl.CustomRuleWrapper;
import ro.amiq.vlogdt.linter.api.impl.factory.APIFactory;
import ro.amiq.vlogdt.linter.api.impl.model.MethodCallWrapper;
import ro.amiq.vlogdt.linter.api.impl.model.NamedElementWrapper;
import ro.amiq.vlogdt.linter.api.model.IElement;
import ro.amiq.vlogdt.linter.api.model.IModel;
import ro.amiq.vlogdt.linter.api.model.ISourceElement;
import ro.amiq.vlogdt.linter.api.model.ISourceFile;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.parser.ReparseInfo;

public class Linter
implements ILinter {
    private final CustomRuleWrapper fCustomRuleWrapper;
    private final APIFactory fAPIFactory;

    public Linter(CustomRuleWrapper customRuleWrapper) {
        this.fCustomRuleWrapper = customRuleWrapper;
        this.fAPIFactory = this.fCustomRuleWrapper.getLinterProject().getAPIFactory();
    }

    @Override
    @Deprecated
    public void passHit(String path, int line, String message) {
    }

    @Override
    public void failHit(String path, int line, String message) {
        this.fCustomRuleWrapper.newHit(path, line, message, null, null);
    }

    @Override
    @Deprecated
    public void passHit(IElement element, String message) {
    }

    @Override
    public void failHit(IElement element, String message) {
        this.addHitWithSeverity(element, message, CheckStatus.ERROR);
    }

    @Override
    public void infoHit(IElement element, String message) {
        this.addHitWithSeverity(element, message, CheckStatus.INFO);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.fCustomRuleWrapper.getProperties();
    }

    @Override
    public IModel getModel() {
        return this.fAPIFactory.getModel();
    }

    @Override
    public void print(String message) {
        OVMProject linterProject = this.fCustomRuleWrapper.getLinterProject();
        if (linterProject == null) {
            return;
        }
        linterProject.registerMessage(this.fCustomRuleWrapper.getName(), message);
    }

    @Override
    public String printToFile(String filePath, String message) throws IllegalArgumentException, FileNotFoundException {
        String result;
        block7: {
            BufferedWriter fileWriter = null;
            result = " ";
            try {
                try {
                    File outputFile = this.computeOutputFile(filePath);
                    File parentDirectory = outputFile.getParentFile();
                    if (parentDirectory != null && !parentDirectory.exists()) {
                        parentDirectory.mkdirs();
                    }
                    fileWriter = new BufferedWriter(new FileWriter(outputFile));
                    fileWriter.write(message);
                    ((Writer)fileWriter).close();
                    result = outputFile.getAbsolutePath();
                }
                catch (FileNotFoundException e) {
                    throw new FileNotFoundException("File '" + e.getMessage() + "' is read-only!");
                }
                catch (IOException e) {
                    DVTLogger.INSTANCE.logError(e.getMessage());
                    DVTUtilsCommon.INSTANCE.closeClosable(fileWriter);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DVTUtilsCommon.INSTANCE.closeClosable(fileWriter);
                throw throwable;
            }
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)fileWriter);
        }
        return result;
    }

    private File computeOutputFile(String filePath) throws IllegalArgumentException {
        String replacedPath = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)filePath, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, name -> System.getenv(name));
        File file = new File(replacedPath);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Specified path is a directory!");
        }
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.getCurrentSessionFilePath(replacedPath));
    }

    private String getCurrentSessionFilePath(String fileName) {
        File saveToLocationFile;
        String saveToLocation = ".";
        IProject currentProject = this.fCustomRuleWrapper.getLinterProject().getProject();
        if (currentProject != null) {
            saveToLocation = currentProject.getLocation().toOSString();
        }
        if (!(saveToLocationFile = new File(saveToLocation)).exists()) {
            saveToLocationFile.mkdirs();
        }
        return String.valueOf(saveToLocation) + File.separator + fileName;
    }

    private void addHitWithSeverity(Object element, String message, CheckStatus severity) {
        ISourceFile file;
        IHidObject methodHidObject;
        Object namedElement;
        ReparseInfo reparseInfo = null;
        if (element instanceof NamedElementWrapper && (namedElement = ((NamedElementWrapper)element).getNamedElement()) != null && ((RfNamedElement)namedElement).getDeclaration() != null) {
            reparseInfo = ((RfNamedElement)namedElement).getDeclaration().getReparseInfo();
        }
        if (element instanceof MethodCallWrapper && (methodHidObject = ((MethodCallWrapper)element).getMethodCall().methodHidObject) != null && methodHidObject instanceof RfHid) {
            reparseInfo = (ReparseInfo)((RfHid)methodHidObject).getReparseInfo();
        }
        String path = "none";
        int line = 0;
        if (element != null && element instanceof ISourceElement && (file = ((ISourceElement)element).getFile()) != null) {
            path = file.getPath();
            line = ((ISourceElement)element).getStartLine();
        }
        this.fCustomRuleWrapper.newHit(path, line, message, reparseInfo, severity);
    }
}

