/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.api.impl.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.vlogdt.linter.api.impl.factory.APIFactory;
import ro.amiq.vlogdt.linter.api.impl.factory.IElementValidator;

public abstract class AElementFactory<T, U> {
    private final APIFactory fAPIFactory;

    protected AElementFactory(APIFactory apiFactory) {
        this.fAPIFactory = apiFactory;
    }

    protected APIFactory getFactory() {
        return this.fAPIFactory;
    }

    public abstract U get(T var1);

    public U get(T obj, IElementValidator ... validators) {
        if (obj == null) {
            return null;
        }
        IElementValidator[] iElementValidatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            IElementValidator validator = iElementValidatorArray[n2];
            if (!validator.accept(obj)) {
                return null;
            }
            ++n2;
        }
        return this.get(obj);
    }

    public Set<U> getSet(Collection<T> objs) {
        if (objs == null || objs.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<U> result = new LinkedHashSet<U>(objs.size());
        for (T obj : objs) {
            U newObj = this.get(obj);
            if (newObj == null) continue;
            result.add(newObj);
        }
        return result;
    }

    public Set<U> getSet(T[] objs) {
        if (objs == null || objs.length == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet<U> result = new LinkedHashSet<U>(objs.length);
        T[] TArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            T obj = TArray[n2];
            U newObj = this.get(obj);
            if (newObj != null) {
                result.add(newObj);
            }
            ++n2;
        }
        return result;
    }

    public Set<U> getSet(Map<String, T> objs) {
        if (objs == null || objs.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<U> result = new LinkedHashSet<U>(objs.size());
        for (T obj : objs.values()) {
            U newObj = this.get(obj);
            if (newObj == null) continue;
            result.add(newObj);
        }
        return result;
    }

    public Set<U> getSet(Collection<T> objs, IElementValidator ... validators) {
        if (objs == null || objs.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet result = new LinkedHashSet(objs.size());
        this.createCollection(result, objs, validators);
        return result;
    }

    public Set<U> getSet(T[] objs, IElementValidator ... validators) {
        if (objs == null || objs.length == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet result = new LinkedHashSet(objs.length);
        this.createCollection(result, objs, validators);
        return result;
    }

    private void createCollection(Collection<U> result, Collection<T> objs, IElementValidator[] validators) {
        block0: for (T obj : objs) {
            IElementValidator[] iElementValidatorArray = validators;
            int n = validators.length;
            int n2 = 0;
            while (n2 < n) {
                IElementValidator validator = iElementValidatorArray[n2];
                if (!validator.accept(obj)) continue block0;
                ++n2;
            }
            U newObj = this.get(obj);
            if (newObj == null) continue;
            result.add(newObj);
        }
    }

    private void createCollection(Collection<U> result, T[] objs, IElementValidator[] validators) {
        T[] TArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                T obj = TArray[n2];
                IElementValidator[] iElementValidatorArray = validators;
                int n3 = validators.length;
                int n4 = 0;
                while (n4 < n3) {
                    IElementValidator validator = iElementValidatorArray[n4];
                    if (validator.accept(obj)) {
                        ++n4;
                        continue;
                    }
                    break block4;
                }
                U newObj = this.get(obj);
                if (newObj != null) {
                    result.add(newObj);
                }
            }
            ++n2;
        }
    }
}

