/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.api.impl.factory;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.api.impl.factory.AElementFactory;
import ro.amiq.vlogdt.linter.api.impl.factory.AElementFactoryCache;
import ro.amiq.vlogdt.linter.api.impl.factory.AMethodCallFactoryCache;
import ro.amiq.vlogdt.linter.api.impl.model.ActionBlock;
import ro.amiq.vlogdt.linter.api.impl.model.ArchitectureModel;
import ro.amiq.vlogdt.linter.api.impl.model.Assertion;
import ro.amiq.vlogdt.linter.api.impl.model.Assignment;
import ro.amiq.vlogdt.linter.api.impl.model.Clazz;
import ro.amiq.vlogdt.linter.api.impl.model.Constructor;
import ro.amiq.vlogdt.linter.api.impl.model.CoverCross;
import ro.amiq.vlogdt.linter.api.impl.model.CoverGroup;
import ro.amiq.vlogdt.linter.api.impl.model.CoverPoint;
import ro.amiq.vlogdt.linter.api.impl.model.ELInstanceElementWrapper;
import ro.amiq.vlogdt.linter.api.impl.model.ElaboratedInstance;
import ro.amiq.vlogdt.linter.api.impl.model.Field;
import ro.amiq.vlogdt.linter.api.impl.model.Function;
import ro.amiq.vlogdt.linter.api.impl.model.GenerateBlock;
import ro.amiq.vlogdt.linter.api.impl.model.Instance;
import ro.amiq.vlogdt.linter.api.impl.model.Interface;
import ro.amiq.vlogdt.linter.api.impl.model.Library;
import ro.amiq.vlogdt.linter.api.impl.model.MethodArgument;
import ro.amiq.vlogdt.linter.api.impl.model.MethodInvocation;
import ro.amiq.vlogdt.linter.api.impl.model.Model;
import ro.amiq.vlogdt.linter.api.impl.model.Module;
import ro.amiq.vlogdt.linter.api.impl.model.NotImplementedContainer;
import ro.amiq.vlogdt.linter.api.impl.model.NotImplementedPredefinedType;
import ro.amiq.vlogdt.linter.api.impl.model.NotImplementedType;
import ro.amiq.vlogdt.linter.api.impl.model.Package;
import ro.amiq.vlogdt.linter.api.impl.model.Parameter;
import ro.amiq.vlogdt.linter.api.impl.model.Port;
import ro.amiq.vlogdt.linter.api.impl.model.ScalarType;
import ro.amiq.vlogdt.linter.api.impl.model.SourceFile;
import ro.amiq.vlogdt.linter.api.impl.model.Task;
import ro.amiq.vlogdt.linter.api.impl.model.TypeDef;
import ro.amiq.vlogdt.linter.api.impl.model.Wait;
import ro.amiq.vlogdt.linter.api.impl.utils.SVTBIssueDecorator;
import ro.amiq.vlogdt.linter.api.model.IActionBlock;
import ro.amiq.vlogdt.linter.api.model.IAssertion;
import ro.amiq.vlogdt.linter.api.model.IAssignment;
import ro.amiq.vlogdt.linter.api.model.IClass;
import ro.amiq.vlogdt.linter.api.model.IContainer;
import ro.amiq.vlogdt.linter.api.model.ICoverCross;
import ro.amiq.vlogdt.linter.api.model.ICoverGroup;
import ro.amiq.vlogdt.linter.api.model.ICoverPoint;
import ro.amiq.vlogdt.linter.api.model.IElaboratedInstance;
import ro.amiq.vlogdt.linter.api.model.IField;
import ro.amiq.vlogdt.linter.api.model.IGenerateBlock;
import ro.amiq.vlogdt.linter.api.model.IInstance;
import ro.amiq.vlogdt.linter.api.model.IInterface;
import ro.amiq.vlogdt.linter.api.model.ILibrary;
import ro.amiq.vlogdt.linter.api.model.IMethod;
import ro.amiq.vlogdt.linter.api.model.IMethodArgument;
import ro.amiq.vlogdt.linter.api.model.IMethodCall;
import ro.amiq.vlogdt.linter.api.model.IModel;
import ro.amiq.vlogdt.linter.api.model.IModule;
import ro.amiq.vlogdt.linter.api.model.INotImplementedContainer;
import ro.amiq.vlogdt.linter.api.model.INotImplementedPredefinedType;
import ro.amiq.vlogdt.linter.api.model.INotImplementedType;
import ro.amiq.vlogdt.linter.api.model.IPackage;
import ro.amiq.vlogdt.linter.api.model.IParameter;
import ro.amiq.vlogdt.linter.api.model.IPort;
import ro.amiq.vlogdt.linter.api.model.IScalarType;
import ro.amiq.vlogdt.linter.api.model.ISourceFile;
import ro.amiq.vlogdt.linter.api.model.IType;
import ro.amiq.vlogdt.linter.api.model.ITypeDef;
import ro.amiq.vlogdt.linter.api.model.IWait;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfWait;

public class APIFactory {
    private final OVMProject fLinterProject;
    private Model fModel;
    private ArchitectureModel fArchitectureModel;
    private final AElementFactoryCache<ParserPath, ISourceFile> fSourceFilesCache = new AElementFactoryCache<ParserPath, ISourceFile>(this){

        @Override
        protected ISourceFile create(APIFactory apiFactory, ParserPath obj) {
            return new SourceFile(apiFactory, obj);
        }
    };
    private final AElementFactory<RfLibrary, ILibrary> fLibrariesCache = new AElementFactoryCache<RfLibrary, ILibrary>(this){

        @Override
        protected ILibrary create(APIFactory apiFactory, RfLibrary obj) {
            return new Library(apiFactory, obj);
        }
    };
    private final AElementFactory<RfPackage, IPackage> fPackagesCache = new AElementFactoryCache<RfPackage, IPackage>(this){

        @Override
        protected IPackage create(APIFactory apiFactory, RfPackage obj) {
            return new Package(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfClass, IClass> fClassesCache = new AElementFactoryCache<RfClass, IClass>(this){

        @Override
        public IClass create(APIFactory apiFactory, RfClass obj) {
            return new Clazz(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfModule, IModule> fModulesCache = new AElementFactoryCache<RfModule, IModule>(this){

        @Override
        public IModule create(APIFactory apiFactory, RfModule obj) {
            return new Module(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfInterface, IInterface> fInterfacesCache = new AElementFactoryCache<RfInterface, IInterface>(this){

        @Override
        protected IInterface create(APIFactory apiFactory, RfInterface obj) {
            return new Interface(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfFunction, ? extends IMethod> fMethodsCache = new AElementFactoryCache<RfFunction, IMethod>(this){

        @Override
        public IMethod create(APIFactory apiFactory, RfFunction obj) {
            if (obj.isFunction()) {
                return new Function(apiFactory, obj);
            }
            if (obj.isTask()) {
                return new Task(apiFactory, obj);
            }
            if (obj.isConstructor()) {
                return new Constructor(apiFactory, obj);
            }
            throw new IllegalArgumentException();
        }
    };
    private final AElementFactoryCache<RfTypeAlias, ITypeDef> fTypedefsCache = new AElementFactoryCache<RfTypeAlias, ITypeDef>(this){

        @Override
        public ITypeDef create(APIFactory apiFactory, RfTypeAlias obj) {
            return new TypeDef(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfScalarType, IScalarType> fScalarTypesCache = new AElementFactoryCache<RfScalarType, IScalarType>(this){

        @Override
        protected IScalarType create(APIFactory apiFactory, RfScalarType obj) {
            return new ScalarType(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfNamedElement, INotImplementedType> fNotImplementedTypesCache = new AElementFactoryCache<RfNamedElement, INotImplementedType>(this){

        @Override
        protected INotImplementedType create(APIFactory apiFactory, RfNamedElement obj) {
            return new NotImplementedType(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfNamedElement, INotImplementedPredefinedType> fNotImplementedPredefinedTypesCache = new AElementFactoryCache<RfNamedElement, INotImplementedPredefinedType>(this){

        @Override
        protected INotImplementedPredefinedType create(APIFactory apiFactory, RfNamedElement obj) {
            return new NotImplementedPredefinedType(apiFactory, obj);
        }
    };
    private final AElementFactory<RfNamedElement, IType> fTypesCache = new AElementFactory<RfNamedElement, IType>(this){

        @Override
        public IType get(RfNamedElement obj) {
            if (obj instanceof RfScalarType) {
                return this.getFactory().getScalarTypesCache().get((RfScalarType)obj);
            }
            if (obj.isPredefined()) {
                return this.getFactory().getNotImplementedPredefinedTypesCache().get(obj);
            }
            if (obj instanceof RfClass) {
                return this.getFactory().getClassesCache().get((RfClass)obj);
            }
            if (obj instanceof RfModule) {
                return this.getFactory().getModulesCache().get((RfModule)obj);
            }
            if (obj instanceof RfInterface) {
                return this.getFactory().getInterfacesCache().get((RfInterface)obj);
            }
            if (obj instanceof RfGenerateBlock) {
                return this.getFactory().getGenerateBlocksCache().get((RfGenerateBlock)obj);
            }
            if (obj instanceof RfTypeAlias) {
                return this.getFactory().getTypedefsCache().get((RfTypeAlias)obj);
            }
            return this.getFactory().getNotImplementedTypesCache().get(obj);
        }
    };
    private final AElementFactoryCache<RfField, IMethodArgument> fMethodArgumentsCache = new AElementFactoryCache<RfField, IMethodArgument>(this){

        @Override
        protected IMethodArgument create(APIFactory apiFactory, RfField obj) {
            return new MethodArgument(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfField, IField> fFieldsCache = new AElementFactoryCache<RfField, IField>(this){

        @Override
        protected IField create(APIFactory apiFactory, RfField obj) {
            return new Field(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfInstance, IInstance> fInstancesCache = new AElementFactoryCache<RfInstance, IInstance>(this){

        @Override
        protected IInstance create(APIFactory apiFactory, RfInstance obj) {
            return new Instance(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfGenerateBlock, IGenerateBlock> fGenerateBlocksCache = new AElementFactoryCache<RfGenerateBlock, IGenerateBlock>(this){

        @Override
        protected IGenerateBlock create(APIFactory apiFactory, RfGenerateBlock obj) {
            return new GenerateBlock(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<ELInstanceElementWrapper, IElaboratedInstance> fDesignHierarchyInstancesCache = new AElementFactoryCache<ELInstanceElementWrapper, IElaboratedInstance>(this){

        @Override
        protected ElaboratedInstance create(APIFactory apiFactory, ELInstanceElementWrapper obj) {
            return new ElaboratedInstance(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfPort, IPort> fPortsCache = new AElementFactoryCache<RfPort, IPort>(this){

        @Override
        protected IPort create(APIFactory apiFactory, RfPort obj) {
            return new Port(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfAssertExpect, IAssertion> fAssertionsCache = new AElementFactoryCache<RfAssertExpect, IAssertion>(this){

        @Override
        protected IAssertion create(APIFactory apiFactory, RfAssertExpect obj) {
            return new Assertion(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfWait, IWait> fWaitsCache = new AElementFactoryCache<RfWait, IWait>(this){

        @Override
        protected IWait create(APIFactory apiFactory, RfWait obj) {
            return new Wait(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfCovergroup, ICoverGroup> fCoverGroupsCache = new AElementFactoryCache<RfCovergroup, ICoverGroup>(this){

        @Override
        protected ICoverGroup create(APIFactory apiFactory, RfCovergroup obj) {
            return new CoverGroup(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfCoverpoint, ICoverPoint> fCoverPointsCache = new AElementFactoryCache<RfCoverpoint, ICoverPoint>(this){

        @Override
        protected ICoverPoint create(APIFactory apiFactory, RfCoverpoint obj) {
            return new CoverPoint(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfField, ICoverCross> fCoverCrossesCache = new AElementFactoryCache<RfField, ICoverCross>(this){

        @Override
        protected ICoverCross create(APIFactory apiFactory, RfField obj) {
            return new CoverCross(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfNamedElement, INotImplementedContainer> fNotImplementedContainersCache = new AElementFactoryCache<RfNamedElement, INotImplementedContainer>(this){

        @Override
        protected INotImplementedContainer create(APIFactory apiFactory, RfNamedElement obj) {
            return new NotImplementedContainer(apiFactory, obj);
        }
    };
    private final AElementFactory<RfNamedElement, IContainer> fContainersCache = new AElementFactory<RfNamedElement, IContainer>(this){

        @Override
        public IContainer get(RfNamedElement obj) {
            if (obj instanceof RfModule) {
                return this.getFactory().getModulesCache().get((RfModule)obj);
            }
            if (obj instanceof RfInterface) {
                return this.getFactory().getInterfacesCache().get((RfInterface)obj);
            }
            if (obj instanceof RfClass) {
                return this.getFactory().getClassesCache().get((RfClass)obj);
            }
            if (obj instanceof RfPackage) {
                return this.getFactory().getPackagesCache().get((RfPackage)obj);
            }
            if (obj instanceof RfActionBlock) {
                return this.getFactory().getActionBlocksCache().get((RfActionBlock)obj);
            }
            if (obj instanceof RfFunction) {
                return this.getFactory().getMethodsCache().get((RfFunction)obj);
            }
            return this.getFactory().getNotImplementedContainersCache().get(obj);
        }
    };
    private final AElementFactoryCache<RfActionBlock, IActionBlock> fActionBlocksCache = new AElementFactoryCache<RfActionBlock, IActionBlock>(this){

        @Override
        protected IActionBlock create(APIFactory apiFactory, RfActionBlock obj) {
            return new ActionBlock(apiFactory, obj);
        }
    };
    private final AMethodCallFactoryCache fMethodCallsCache = new AMethodCallFactoryCache(this){

        @Override
        protected IMethodCall create(APIFactory apiFactory, MethodCall obj, ParserPath parserPath, IRfNamedElement scope) {
            return new MethodInvocation(apiFactory, obj, parserPath, scope);
        }
    };
    private final AElementFactoryCache<SVTBIssueDecorator, IAssignment> fAssignmentsCache = new AElementFactoryCache<SVTBIssueDecorator, IAssignment>(this){

        @Override
        protected IAssignment create(APIFactory apiFactory, SVTBIssueDecorator obj) {
            return new Assignment(apiFactory, obj);
        }
    };
    private final AElementFactoryCache<RfField, IParameter> fParametersCache = new AElementFactoryCache<RfField, IParameter>(this){

        @Override
        protected IParameter create(APIFactory apiFactory, RfField obj) {
            return new Parameter(apiFactory, obj);
        }
    };

    public APIFactory(OVMProject linterProject) {
        this.fLinterProject = linterProject;
    }

    public OVMProject getLinterProject() {
        return this.fLinterProject;
    }

    public RfProject getRfProject() {
        return this.fLinterProject.getRfProject();
    }

    public IModel getModel() {
        if (this.fModel == null) {
            this.fModel = new Model(this, this.getRfProject());
        }
        return this.fModel;
    }

    public ArchitectureModel getArchitectureModel() {
        if (this.fArchitectureModel == null) {
            this.fArchitectureModel = new ArchitectureModel(this);
        }
        return this.fArchitectureModel;
    }

    public AElementFactoryCache<ParserPath, ISourceFile> getSourceFilesCache() {
        return this.fSourceFilesCache;
    }

    public AElementFactory<RfLibrary, ILibrary> getLibrariesCache() {
        return this.fLibrariesCache;
    }

    public AElementFactory<RfPackage, IPackage> getPackagesCache() {
        return this.fPackagesCache;
    }

    public AElementFactoryCache<RfClass, IClass> getClassesCache() {
        return this.fClassesCache;
    }

    public AElementFactoryCache<RfModule, IModule> getModulesCache() {
        return this.fModulesCache;
    }

    public AElementFactory<RfInterface, IInterface> getInterfacesCache() {
        return this.fInterfacesCache;
    }

    public AElementFactoryCache<RfFunction, ? extends IMethod> getMethodsCache() {
        return this.fMethodsCache;
    }

    public AElementFactoryCache<RfTypeAlias, ITypeDef> getTypedefsCache() {
        return this.fTypedefsCache;
    }

    public AElementFactoryCache<RfScalarType, IScalarType> getScalarTypesCache() {
        return this.fScalarTypesCache;
    }

    public AElementFactoryCache<RfNamedElement, INotImplementedType> getNotImplementedTypesCache() {
        return this.fNotImplementedTypesCache;
    }

    public AElementFactoryCache<RfNamedElement, INotImplementedPredefinedType> getNotImplementedPredefinedTypesCache() {
        return this.fNotImplementedPredefinedTypesCache;
    }

    public AElementFactory<RfNamedElement, IType> getTypesCache() {
        return this.fTypesCache;
    }

    public AElementFactoryCache<RfField, IMethodArgument> getMethodArgumentsCache() {
        return this.fMethodArgumentsCache;
    }

    public AElementFactoryCache<RfField, IField> getFieldsCache() {
        return this.fFieldsCache;
    }

    public AElementFactoryCache<RfInstance, IInstance> getInstancesCache() {
        return this.fInstancesCache;
    }

    public AElementFactoryCache<RfGenerateBlock, IGenerateBlock> getGenerateBlocksCache() {
        return this.fGenerateBlocksCache;
    }

    public AElementFactoryCache<ELInstanceElementWrapper, IElaboratedInstance> getDesignHierarchyInstancesCache() {
        return this.fDesignHierarchyInstancesCache;
    }

    public AElementFactory<RfPort, IPort> getPortsCache() {
        return this.fPortsCache;
    }

    public AElementFactory<RfAssertExpect, IAssertion> getAssertionsCache() {
        return this.fAssertionsCache;
    }

    public AElementFactory<RfWait, IWait> getWaitsCache() {
        return this.fWaitsCache;
    }

    public AElementFactory<RfCovergroup, ICoverGroup> getCoverGroupsCache() {
        return this.fCoverGroupsCache;
    }

    public AElementFactoryCache<RfCoverpoint, ICoverPoint> getCoverPointsCache() {
        return this.fCoverPointsCache;
    }

    public AElementFactoryCache<RfField, ICoverCross> getCoverCrossesCache() {
        return this.fCoverCrossesCache;
    }

    public AElementFactoryCache<RfNamedElement, INotImplementedContainer> getNotImplementedContainersCache() {
        return this.fNotImplementedContainersCache;
    }

    public AElementFactory<RfNamedElement, IContainer> getContainersCache() {
        return this.fContainersCache;
    }

    public AElementFactoryCache<RfActionBlock, IActionBlock> getActionBlocksCache() {
        return this.fActionBlocksCache;
    }

    public AMethodCallFactoryCache getMethodCallsCache() {
        return this.fMethodCallsCache;
    }

    public AElementFactoryCache<SVTBIssueDecorator, IAssignment> getAssignmentsCache() {
        return this.fAssignmentsCache;
    }

    public AElementFactory<RfField, IParameter> getParametersCache() {
        return this.fParametersCache;
    }
}

