/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.api.impl.model;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.amiq.vlogdt.linter.api.impl.factory.APIFactory;
import ro.amiq.vlogdt.linter.api.impl.model.AElement;
import ro.amiq.vlogdt.linter.api.impl.utils.SVTBIssueDecorator;
import ro.amiq.vlogdt.linter.api.model.IAssignment;
import ro.amiq.vlogdt.linter.api.model.IContainer;
import ro.amiq.vlogdt.linter.api.model.ISourceFile;

public class Assignment
extends AElement
implements IAssignment {
    private final SVTBIssueDecorator fSVTBIssue;

    public Assignment(APIFactory apiFactory, SVTBIssueDecorator svtbIssue) {
        super(apiFactory);
        this.fSVTBIssue = svtbIssue;
    }

    @Override
    public ISourceFile getFile() {
        return this.getFactory().getSourceFilesCache().get(this.fSVTBIssue.getParserPath());
    }

    @Override
    public int getStartLine() {
        return this.fSVTBIssue.getSVTBIssue().getLine();
    }

    @Override
    public int getEndLine() {
        return this.fSVTBIssue.getSVTBIssue().getLine();
    }

    @Override
    public String getSourceCode() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<String> lines = Files.lines(Paths.get(this.getFile().getPath(), new String[0]));){
            return lines.skip((long)this.getStartLine() - 1L).limit((long)(this.getEndLine() - this.getStartLine()) + 1L).collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getName() {
        return String.valueOf(this.fSVTBIssue.getSVTBIssue().getInfo()) + (this.fSVTBIssue.getSVTBIssue().getKind() == 33 ? " = " : " <= ") + this.fSVTBIssue.getSVTBIssue().getAdditionalInfo();
    }

    @Override
    public IContainer getContainer() {
        return this.getFactory().getContainersCache().get(this.fSVTBIssue.getContainer());
    }

    @Override
    public String getRightPart() {
        return this.fSVTBIssue.getSVTBIssue().getAdditionalInfo();
    }

    @Override
    public String getLeftPart() {
        return this.fSVTBIssue.getSVTBIssue().getInfo();
    }

    public String toString() {
        return "assignment: " + this.getName();
    }
}

