/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.api.impl.model;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.vlogdt.linter.api.impl.factory.APIFactory;
import ro.amiq.vlogdt.linter.api.impl.model.AElement;
import ro.amiq.vlogdt.linter.api.impl.model.ELInstanceElementWrapper;
import ro.amiq.vlogdt.linter.api.model.IContainer;
import ro.amiq.vlogdt.linter.api.model.ISourceFile;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public abstract class ElaboratedInstanceWrapper<T extends ELInstanceElementWrapper>
extends AElement {
    private final T fElaborationElement;

    protected ElaboratedInstanceWrapper(APIFactory apiFactory, T namedElement) {
        super(apiFactory);
        this.fElaborationElement = namedElement;
    }

    public T getElaborationElement() {
        return this.fElaborationElement;
    }

    private ELInstance getElInstance() {
        ELInstance elInstance = ((ELInstanceElementWrapper)this.getElaborationElement()).getElInstance();
        return elInstance;
    }

    public String getName() {
        ELInstance elInstance = this.getElInstance();
        if (elInstance == null) {
            return null;
        }
        ElementPath hierarchyPath = elInstance.getHierarchyPath();
        if (hierarchyPath == null) {
            return null;
        }
        return hierarchyPath.lastSegment();
    }

    public ISourceFile getFile() {
        RfFileDef file;
        ELInstance elInstance = this.getElInstance();
        if (elInstance == null) {
            return null;
        }
        IRfInstanceElement instance = elInstance.getDescription();
        if (!(instance instanceof RfInstance) && !(instance instanceof DummyInstance)) {
            return null;
        }
        if (instance instanceof DummyInstance) {
            IRfDefElement declaration = instance.getDeclaration();
            file = (RfFileDef)declaration.getDefFile();
        } else {
            file = ((RfInstance)instance).getFile();
        }
        if (file != null) {
            return this.getFactory().getSourceFilesCache().get(file.getParserPath());
        }
        return null;
    }

    public int getStartLine() {
        ELInstance elInstance = this.getElInstance();
        if (elInstance == null) {
            return 0;
        }
        IRfInstanceElement instance = elInstance.getDescription();
        if (instance == null) {
            return 0;
        }
        IRfDefElement defElem = instance.getDeclaration();
        if (defElem != null) {
            return defElem.getStartLine();
        }
        return 0;
    }

    public int getEndLine() {
        ELInstance elInstance = this.getElInstance();
        if (elInstance == null) {
            return 0;
        }
        IRfInstanceElement instance = elInstance.getDescription();
        if (instance == null) {
            return 0;
        }
        IRfDefElement defElem = instance.getDeclaration();
        if (defElem != null) {
            return defElem.getEndLine();
        }
        return 0;
    }

    public String getSourceCode() throws IOException {
        String filePath = this.getFile().getPath();
        Path path = Paths.get(filePath, new String[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<String> lines = Files.lines(path);){
            return lines.skip((long)this.getStartLine() - 1L).limit((long)(this.getEndLine() - this.getStartLine()) + 1L).collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public IContainer getContainer() {
        ELInstance elInstance = this.getElInstance();
        if (elInstance == null) {
            return null;
        }
        IRfInstanceElement description = elInstance.getDescription();
        if (description == null) {
            return null;
        }
        IRfScopeElement enclosingScope = description.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return this.getFactory().getContainersCache().get((RfNamedElement)enclosingScope);
    }

    public boolean isPredefined() {
        ELInstance elInstance = this.getElInstance();
        if (elInstance == null) {
            return false;
        }
        IRfNamedElement namedElement = this.getElInstance().getBinding(false);
        if (namedElement == null) {
            return false;
        }
        return namedElement.isPredefined();
    }
}

