/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.api.impl.model;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.api.impl.factory.APIFactory;
import ro.amiq.vlogdt.linter.api.impl.model.AElement;
import ro.amiq.vlogdt.linter.api.model.IContainer;
import ro.amiq.vlogdt.linter.api.model.ISourceFile;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public abstract class MethodCallWrapper
extends AElement {
    private final MethodCall methodCall;
    private final ParserPath parserPath;
    private final IRfNamedElement scope;
    private static final Pattern missingPattern = Pattern.compile("\\(-?\\d+\\)");

    protected MethodCallWrapper(APIFactory apiFactory, MethodCall methodCall, ParserPath parserPath, IRfNamedElement scope) {
        super(apiFactory);
        this.methodCall = methodCall;
        this.parserPath = parserPath;
        this.scope = scope;
    }

    public MethodCall getMethodCall() {
        return this.methodCall;
    }

    public IRfNamedElement getNamedElement() {
        return this.methodCall.method;
    }

    public boolean isPredefined() {
        return this.getNamedElement().isPredefined();
    }

    public ISourceFile getFile() {
        if (this.isPredefined() && !(this.getNamedElement() instanceof RfFunction)) {
            throw new UnsupportedOperationException("'" + this.getName() + "' is predefined SystemVerilog element, file is not available!");
        }
        if (this.parserPath != null) {
            return this.getFactory().getSourceFilesCache().get(this.parserPath);
        }
        return null;
    }

    public int getStartLine() {
        if (this.isPredefined() && !(this.getNamedElement() instanceof RfFunction)) {
            throw new UnsupportedOperationException("'" + this.getName() + "' is predefined SystemVerilog element, start line is not available!");
        }
        HidOccurrence occurrence = this.methodCall.getOccurrence();
        if (occurrence != null) {
            return occurrence.getLine();
        }
        return 0;
    }

    public int getEndLine() {
        if (this.isPredefined() && !(this.getNamedElement() instanceof RfFunction)) {
            throw new UnsupportedOperationException("'" + this.getName() + "' is predefined SystemVerilog element, end line is not available!");
        }
        HidOccurrence occurrence = this.methodCall.getOccurrence();
        if (occurrence != null) {
            return occurrence.getLine();
        }
        return 0;
    }

    public String getSourceCode() {
        IHidObject hid = this.methodCall.methodHidObject;
        ListContainer accesses = ((RfHid)hid).getAccesses();
        if (accesses == null || !(accesses.get(0) instanceof RfHidAccessArgs)) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        RfHidAccessArgs accessArgs = (RfHidAccessArgs)((Object)accesses.get(0));
        String methodName = accessArgs.getMethodCall().getMethodName();
        res.append(String.valueOf(methodName) + "(");
        List<? extends IHidObject> argumentValues = accessArgs.getArgumentValues();
        boolean multipleArgs = false;
        for (IHidObject iHidObject : argumentValues) {
            boolean isNamedArg;
            if (!(iHidObject instanceof RfHidOperator)) continue;
            RfHidOperator operator = (RfHidOperator)iHidObject;
            IHidObject left = operator.getLHValue();
            IHidObject right = operator.getFirstRHValue();
            String leftPart = HidUtils.toNiceString((IHidObject)left);
            String rightPart = HidUtils.toNiceString((IHidObject)right);
            Matcher missingLeftMatcher = missingPattern.matcher(left.toString());
            boolean bl = isNamedArg = !missingLeftMatcher.find();
            if (rightPart.equals("(-3)")) {
                rightPart = "";
            }
            if (multipleArgs) {
                res.append(", ");
            }
            if (isNamedArg) {
                res.append("." + leftPart + "(" + rightPart + ")");
            } else {
                res.append(rightPart);
            }
            multipleArgs = true;
        }
        res.append(")");
        return res.toString();
    }

    public String getName() {
        return this.getNamedElement().getName();
    }

    public IContainer getContainer() {
        if (this.scope instanceof RfNamedElement) {
            return this.getFactory().getContainersCache().get((RfNamedElement)this.scope);
        }
        return null;
    }
}

