/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.api.impl.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.api.impl.factory.APIFactory;
import ro.amiq.vlogdt.linter.api.impl.model.ELInstanceElementWrapper;
import ro.amiq.vlogdt.linter.api.impl.model.NamedElementWrapper;
import ro.amiq.vlogdt.linter.api.model.IArchitectureModel;
import ro.amiq.vlogdt.linter.api.model.IAssertion;
import ro.amiq.vlogdt.linter.api.model.IClass;
import ro.amiq.vlogdt.linter.api.model.ICoverGroup;
import ro.amiq.vlogdt.linter.api.model.IElaboratedInstance;
import ro.amiq.vlogdt.linter.api.model.IFunction;
import ro.amiq.vlogdt.linter.api.model.IInterface;
import ro.amiq.vlogdt.linter.api.model.ILibrary;
import ro.amiq.vlogdt.linter.api.model.IModel;
import ro.amiq.vlogdt.linter.api.model.IModule;
import ro.amiq.vlogdt.linter.api.model.IPackage;
import ro.amiq.vlogdt.linter.api.model.ISourceFile;
import ro.amiq.vlogdt.linter.api.model.ITask;
import ro.amiq.vlogdt.linter.api.model.IWait;
import ro.amiq.vlogdt.linter.utils.LintDHUtils;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfWait;

public class Model
extends NamedElementWrapper<RfProject>
implements IModel {
    public Model(APIFactory apiFactory, RfProject namedElement) {
        super(apiFactory, namedElement);
    }

    @Override
    public IArchitectureModel getArchitectureModel() {
        return this.getFactory().getArchitectureModel();
    }

    @Override
    public Set<ISourceFile> getSourceFiles() {
        return this.getFactory().getSourceFilesCache().getSet(this.getLinterProject().getAllImportedFiles());
    }

    @Override
    public Set<ILibrary> getLibraries() {
        return this.getFactory().getLibrariesCache().getSet(((RfProject)this.getNamedElement()).getAllLibraries());
    }

    @Override
    public Set<IPackage> getPackages() {
        return this.getFactory().getPackagesCache().getSet(this.getRfProject().getAllPackages(false));
    }

    @Override
    public Set<IModule> getModules() {
        return this.getFactory().getModulesCache().getSet((RfModule[])this.getRfProject().getAllModules());
    }

    @Override
    public Set<IInterface> getInterfaces() {
        return this.getFactory().getInterfacesCache().getSet((RfInterface[])this.getRfProject().getAllInterfaces());
    }

    @Override
    public Set<IClass> getClasses() {
        return this.getFactory().getClassesCache().getSet((RfClass[])this.getRfProject().getAllClasses());
    }

    @Override
    public Set<IAssertion> getAssertions() {
        return this.getFactory().getAssertionsCache().getSet((RfAssertExpect[])this.getRfProject().getAllAssertExpects());
    }

    @Override
    public Set<IWait> getWaits() {
        return this.getFactory().getWaitsCache().getSet((RfWait[])this.getRfProject().getAllWaits());
    }

    @Override
    public Set<ICoverGroup> getCoverGroups() {
        return this.getFactory().getCoverGroupsCache().getSet((RfCovergroup[])this.getRfProject().getAllCovergroups());
    }

    @Override
    public Set<IFunction> getFunctions() {
        return this.getFactory().getMethodsCache().getSet((RfFunction[])this.getRfProject().getAllFunctionsAndTasks(true), PREDEFINED_OVERRIDES, FUNCTIONS);
    }

    @Override
    public Set<ITask> getTasks() {
        return this.getFactory().getMethodsCache().getSet((RfFunction[])this.getRfProject().getAllFunctionsAndTasks(true), PREDEFINED_OVERRIDES, TASKS);
    }

    @Override
    public Set<IElaboratedInstance> getElaboratedInstances(String top) {
        ArrayList<ELInstanceElementWrapper> elaborationInstances = new ArrayList<ELInstanceElementWrapper>();
        ElementPath topPath = null;
        LintDHUtils.GetTopsResult selectedTopsForBuildConfig = null;
        if (top.isEmpty()) {
            selectedTopsForBuildConfig = LintDHUtils.getTops(this.getRfProject().getProject(), true);
        }
        if (selectedTopsForBuildConfig != null) {
            List<IRfNamedElement> tops = selectedTopsForBuildConfig.getTops();
            if (tops == null) {
                return this.getFactory().getDesignHierarchyInstancesCache().getSet((ELInstanceElementWrapper[])elaborationInstances.toArray(new ELInstanceElementWrapper[elaborationInstances.size()]));
            }
            for (IRfNamedElement buildConfigTop : tops) {
                String topModuleName = buildConfigTop.getName();
                topPath = LintDHUtils.computeElementPathFromModuleName(this.getRfProject(), topModuleName);
                if (topPath == null) continue;
                elaborationInstances.add(new ELInstanceElementWrapper(null, topPath, true));
                this.computeDHForTopPath(topPath, elaborationInstances);
            }
        } else {
            topPath = !top.contains(".") ? LintDHUtils.computeElementPathFromModuleName(this.getRfProject(), top) : LintDHUtils.getElementPathFromHierarchyPath(top);
            if (topPath == null) {
                return this.getFactory().getDesignHierarchyInstancesCache().getSet((ELInstanceElementWrapper[])elaborationInstances.toArray(new ELInstanceElementWrapper[elaborationInstances.size()]));
            }
            elaborationInstances.add(new ELInstanceElementWrapper(null, topPath, true));
            this.computeDHForTopPath(topPath, elaborationInstances);
        }
        return this.getFactory().getDesignHierarchyInstancesCache().getSet((ELInstanceElementWrapper[])elaborationInstances.toArray(new ELInstanceElementWrapper[elaborationInstances.size()]));
    }

    private void computeDHForTopPath(ElementPath topPath, List<ELInstanceElementWrapper> elaborationInstances) {
        Map<ElementPath, ELInstance> designHierarchyTree = LintDHUtils.computeDHWithElaborationForElementPath(this.getRfProject(), topPath);
        elaborationInstances.addAll(designHierarchyTree.values().stream().map(instance -> new ELInstanceElementWrapper((ELInstance)instance, topPath.removeLastSegment(), false)).collect(Collectors.toList()));
    }
}

