/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.api.impl.model;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.api.impl.factory.APIFactory;
import ro.amiq.vlogdt.linter.api.impl.factory.IElementValidator;
import ro.amiq.vlogdt.linter.api.impl.model.AElement;
import ro.amiq.vlogdt.linter.api.impl.utils.SVTBIssueDecorator;
import ro.amiq.vlogdt.linter.api.model.IActionBlock;
import ro.amiq.vlogdt.linter.api.model.IAssertion;
import ro.amiq.vlogdt.linter.api.model.IAssignment;
import ro.amiq.vlogdt.linter.api.model.IClass;
import ro.amiq.vlogdt.linter.api.model.IContainer;
import ro.amiq.vlogdt.linter.api.model.ICoverGroup;
import ro.amiq.vlogdt.linter.api.model.IField;
import ro.amiq.vlogdt.linter.api.model.IFunction;
import ro.amiq.vlogdt.linter.api.model.IInstance;
import ro.amiq.vlogdt.linter.api.model.IInterface;
import ro.amiq.vlogdt.linter.api.model.IMethodCall;
import ro.amiq.vlogdt.linter.api.model.IModule;
import ro.amiq.vlogdt.linter.api.model.IParameter;
import ro.amiq.vlogdt.linter.api.model.IPort;
import ro.amiq.vlogdt.linter.api.model.ISourceFile;
import ro.amiq.vlogdt.linter.api.model.ITask;
import ro.amiq.vlogdt.linter.api.model.IWait;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfWait;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.SVTBIssues;

public abstract class NamedElementWrapper<T extends RfNamedElement>
extends AElement {
    static final IElementValidator DEFINED = obj -> {
        if (obj instanceof RfNamedElement) {
            return !((RfNamedElement)obj).isPredefined();
        }
        return false;
    };
    static final IElementValidator PREDEFINED_OVERRIDES = obj -> {
        if (obj instanceof RfPredefinedFunction) {
            return ((RfPredefinedFunction)obj).isPredefinedOverridden();
        }
        return true;
    };
    static final IElementValidator FUNCTIONS = obj -> {
        if (obj instanceof RfFunction) {
            return ((RfFunction)obj).isFunction();
        }
        return false;
    };
    static final IElementValidator TASKS = obj -> {
        if (obj instanceof RfFunction) {
            return ((RfFunction)obj).isTask();
        }
        return false;
    };
    static final IElementValidator METHOD_CALLS = obj -> {
        if (obj instanceof MethodCall) {
            return ((MethodCall)obj).method != null;
        }
        return false;
    };
    private final T fNamedElement;

    protected NamedElementWrapper(APIFactory apiFactory, T namedElement) {
        super(apiFactory);
        this.fNamedElement = namedElement;
    }

    public T getNamedElement() {
        return this.fNamedElement;
    }

    public String getName() {
        return ((RfNamedElement)this.getNamedElement()).getName();
    }

    public ISourceFile getFile() {
        if (this.isPredefined() && !(this.getNamedElement() instanceof RfFunction)) {
            throw new UnsupportedOperationException("'" + this.getName() + "' is predefined SystemVerilog element, file is not available!");
        }
        RfFileDef file = ((RfNamedElement)this.getNamedElement()).getFile();
        if (file != null) {
            return this.getFactory().getSourceFilesCache().get(file.getParserPath());
        }
        return null;
    }

    public int getStartLine() {
        if (this.isPredefined() && !(this.getNamedElement() instanceof RfFunction)) {
            throw new UnsupportedOperationException("'" + this.getName() + "' is predefined SystemVerilog element, start line is not available!");
        }
        RfDefElement defElem = ((RfNamedElement)this.getNamedElement()).getDeclaration();
        if (defElem != null) {
            return defElem.getStartLine();
        }
        return 0;
    }

    public int getEndLine() {
        if (this.isPredefined() && !(this.getNamedElement() instanceof RfFunction)) {
            throw new UnsupportedOperationException("'" + this.getName() + "' is predefined SystemVerilog element, end line is not available!");
        }
        RfDefElement defElem = ((RfNamedElement)this.getNamedElement()).getDeclaration();
        if (defElem != null) {
            return defElem.getEndLine();
        }
        return 0;
    }

    public String getSourceCode() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<String> lines = Files.lines(Paths.get(this.getFile().getPath(), new String[0]));){
            return lines.skip((long)this.getStartLine() - 1L).limit((long)(this.getEndLine() - this.getStartLine()) + 1L).collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public IContainer getContainer() {
        return this.getFactory().getContainersCache().get(((RfNamedElement)this.getNamedElement()).getEnclosingScope());
    }

    public boolean isPredefined() {
        return ((RfNamedElement)this.getNamedElement()).isPredefined();
    }

    public boolean isVirtual() {
        return ((RfElement)this.getNamedElement()).hasVirtualQualifier();
    }

    public boolean isExternal() {
        return ((RfElement)this.getNamedElement()).isExtern();
    }

    public Set<IClass> getClasses() {
        return this.getFactory().getClassesCache().getSet(this.getNamedElement().getLocalMembers(RfClass.class), DEFINED);
    }

    public Set<IModule> getModules() {
        return this.getFactory().getModulesCache().getSet(this.getNamedElement().getLocalMembers(RfModule.class), DEFINED);
    }

    public Set<IInterface> getInterfaces() {
        return this.getFactory().getInterfacesCache().getSet(this.getNamedElement().getLocalMembers(RfInterface.class), DEFINED);
    }

    public Set<IFunction> getFunctions() {
        return this.getFactory().getMethodsCache().getSet(((RfNamedElement)this.getNamedElement()).getLocalFunctions(), PREDEFINED_OVERRIDES, FUNCTIONS);
    }

    public Set<IAssertion> getAssertions() {
        return this.getFactory().getAssertionsCache().getSet(this.getNamedElement().getLocalMembers(RfAssertExpect.class), DEFINED);
    }

    public Set<IWait> getWaits() {
        return this.getFactory().getWaitsCache().getSet(this.getNamedElement().getLocalMembers(RfWait.class), DEFINED);
    }

    public Set<ICoverGroup> getCoverGroups() {
        return this.getFactory().getCoverGroupsCache().getSet(((RfNamedElement)this.getNamedElement()).getLocalMembers(RfCovergroup.class), DEFINED);
    }

    public Set<ITask> getTasks() {
        return this.getFactory().getMethodsCache().getSet(((RfNamedElement)this.getNamedElement()).getLocalTasks(), PREDEFINED_OVERRIDES, TASKS);
    }

    public Set<IField> getFields() {
        return this.getFactory().getFieldsCache().getSet(((RfNamedElement)this.getNamedElement()).getFields(), DEFINED);
    }

    public Set<IInstance> getInstances() {
        return this.getFactory().getInstancesCache().getSet(((RfNamedElement)this.getNamedElement()).getInstancesWithPrefix("", 2, 1), DEFINED);
    }

    public Set<IPort> getPorts() {
        return this.getFactory().getPortsCache().getSet(((RfNamedElement)this.getNamedElement()).getPortsWithPrefix("", 2), DEFINED);
    }

    public Set<IParameter> getParameters() {
        return this.getFactory().getParametersCache().getSet(((RfNamedElement)this.getNamedElement()).getParametersWithPrefix("", 384, 2, 1));
    }

    public Set<IActionBlock> getActionBlocks() {
        return this.getFactory().getActionBlocksCache().getSet(this.getNamedElement().getLocalMembers(RfActionBlock.class));
    }

    public Set<IMethodCall> getMethodCall() {
        final LinkedHashMap<MethodCall, DVTPair<ParserPath, IRfNamedElement>> res = new LinkedHashMap<MethodCall, DVTPair<ParserPath, IRfNamedElement>>();
        ((RfNamedElement)this.getNamedElement()).visitHidObject(this.getRfProject(), new RfHidVisitor(){

            public boolean visit(RfHid hid) {
                if (!hid.isMethodCall(false)) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return true;
                }
                res.putAll(methodCalls.stream().filter(x -> x != null).collect(Collectors.toMap(x -> x, x -> new DVTPair((Object)this.parserPath, (Object)((HidHolder)this.holder).getScope()))));
                return true;
            }
        });
        return this.getFactory().getMethodCallsCache().getMap(res, METHOD_CALLS);
    }

    public Set<IAssignment> getAssignments() {
        int startOffset = -1;
        int endOffset = -1;
        ParserPath fileName = null;
        RfDefElement declaration = ((RfNamedElement)this.getNamedElement()).getDeclaration();
        if (declaration == null) {
            return Collections.emptySet();
        }
        startOffset = ((RfNamedElement)this.getNamedElement()).getDeclaration().getStartOffset();
        endOffset = ((RfNamedElement)this.getNamedElement()).getDeclaration().getEndOffset();
        RfFileDef defFile = declaration.getDefFile();
        fileName = defFile.getParserPath();
        if (declaration instanceof RfFunctionDef && ((RfFunctionDef)declaration).isPrototype()) {
            for (RfDefElement def : ((RfNamedElement)this.getNamedElement()).getDeclarations()) {
                if (def == null || !(def instanceof RfFunctionDef) || ((RfFunctionDef)def).isPrototype()) continue;
                startOffset = def.getStartOffset();
                endOffset = def.getEndOffset();
                defFile = def.getDefFile();
                fileName = defFile.getParserPath();
                declaration = def;
            }
        }
        if (startOffset < 0 || endOffset < 0 || fileName == null) {
            return Collections.emptySet();
        }
        Map<ParserPath, List<SVTBIssues>> svtbIssues = this.getRfProject().getPreprocessingTable().getSVTBIssuesMap();
        if (svtbIssues == null) {
            return Collections.emptySet();
        }
        List<SVTBIssues> fileIssues = svtbIssues.get(fileName);
        if (fileIssues == null || fileIssues.isEmpty()) {
            return Collections.emptySet();
        }
        int offset = -1;
        int kind = -1;
        IAssignment obj = null;
        LinkedHashSet<IAssignment> result = new LinkedHashSet<IAssignment>();
        for (SVTBIssues issue : fileIssues) {
            RfNamedElement scope;
            RfDefElement defScope;
            kind = issue.getKind();
            if (kind != 33 && kind != 77 || (offset = issue.getOffset()) < startOffset || offset > endOffset || (defScope = defFile.getScope(offset, true)) == null || (scope = defScope.getNamedElement()) == null || !scope.equals(this.getNamedElement()) || (obj = this.getFactory().getAssignmentsCache().get(new SVTBIssueDecorator(scope, issue, fileName))) == null) continue;
            result.add(obj);
        }
        return result;
    }

    public String toString() {
        return this.getName();
    }
}

