/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.api.tooling;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import ro.amiq.vlogdt.linter.api.ICustomRule;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleDescription;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleID;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleName;
import ro.amiq.vlogdt.linter.api.annotations.CustomRuleTitle;

@SupportedOptions(value={})
@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class CustomRuleAnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        Elements elementUtils = this.processingEnv.getElementUtils();
        Messager messager = this.processingEnv.getMessager();
        TypeMirror customRuleType = elementUtils.getTypeElement(ICustomRule.class.getCanonicalName()).asType();
        TypeMirror type = null;
        Set<? extends Element> elements = roundEnv.getRootElements();
        for (Element element : elements) {
            CustomRuleDescription ruleDescriptionAnnot;
            CustomRuleTitle ruleTitleAnnot;
            CustomRuleName ruleNameAnnot;
            type = element.asType();
            if (!typeUtils.isSubtype(type, customRuleType)) continue;
            CustomRuleID ruleIDAnnot = element.getAnnotation(CustomRuleID.class);
            if (ruleIDAnnot == null) {
                messager.printMessage(Diagnostic.Kind.ERROR, "Type must have '" + CustomRuleID.class.getCanonicalName() + "' annotation!", element);
            }
            if ((ruleNameAnnot = element.getAnnotation(CustomRuleName.class)) == null) {
                messager.printMessage(Diagnostic.Kind.WARNING, "Type should have '" + CustomRuleName.class.getCanonicalName() + "' annotation!", element);
            }
            if ((ruleTitleAnnot = element.getAnnotation(CustomRuleTitle.class)) == null) {
                messager.printMessage(Diagnostic.Kind.WARNING, "Type should have '" + CustomRuleTitle.class.getCanonicalName() + "' annotation!", element);
            }
            if ((ruleDescriptionAnnot = element.getAnnotation(CustomRuleDescription.class)) != null) continue;
            messager.printMessage(Diagnostic.Kind.WARNING, "Type should have '" + CustomRuleDescription.class.getCanonicalName() + "' annotation!", element);
        }
        return false;
    }
}

