/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;

public class DeleteEditParameters
extends EditParameters {
    private int length;

    public DeleteEditParameters(VerissimoAutofix autofix, int startOffset, int length) {
        super(autofix, startOffset);
        this.length = length;
        this.type = EditParameters.TYPE.DELETE;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public String getContent() {
        return "";
    }

    @Override
    public boolean isValid(OVMComplianceCheckHit hit) {
        if (this.length < 0) {
            this.autofix.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
            return false;
        }
        return super.isValid(hit);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.length;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeleteEditParameters other = (DeleteEditParameters)obj;
        return this.length == other.length;
    }
}

