/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;

public abstract class EditParameters {
    protected VerissimoAutofix autofix;
    protected int startOffset;
    protected int line;
    protected int lineOffset;
    protected PRIORITY priority;
    protected TYPE type;

    public EditParameters(VerissimoAutofix autofix, int startOffset) {
        this.autofix = autofix;
        this.startOffset = startOffset;
        this.priority = PRIORITY.NORMAL;
        this.type = TYPE.EDIT;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getLine() {
        return this.line;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public void setLineAndLineOffset(IFile file) {
        IDocument document = VerissimoAutofixUtils.getInstance().getDocument(file);
        this.line = DVTDocumentUtils.convertPositionToLine((IDocument)document, (int)this.startOffset);
        this.lineOffset = this.startOffset - DVTDocumentUtils.convertLineToOffset((IDocument)document, (int)this.line);
    }

    public VerissimoAutofix getAutofix() {
        return this.autofix;
    }

    public int getPriority() {
        return this.priority.getValue();
    }

    public void setEditPriority(PRIORITY priority) {
        this.priority = priority;
    }

    public boolean isValid(OVMComplianceCheckHit hit) {
        if (this.startOffset < 0) {
            this.autofix.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
            return false;
        }
        return true;
    }

    public String getType() {
        return this.type.getValue();
    }

    public abstract int getLength();

    public abstract String getContent();

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = 31 * result + this.startOffset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EditParameters other = (EditParameters)obj;
        if (this.priority != other.priority) {
            return false;
        }
        return this.startOffset == other.startOffset;
    }

    public static enum PRIORITY {
        END_ACTION_BLOCK(0),
        NORMAL(1),
        VARIABLE_DECLARATION(2),
        BEGIN_ACTION_BLOCK(3);

        private final int value;

        private PRIORITY(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum TYPE {
        EDIT("edit"),
        DELETE("delete"),
        INSERT("insert"),
        REPLACE("replace");

        private final String value;

        private TYPE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

