/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IMarkerResolution2;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAIAutofixManager;

public class ExplainVerissimoHitWithAIAssistantProposal
implements ICompletionProposal,
IMarkerResolution2 {
    private OVMComplianceCheckHit hit;

    public ExplainVerissimoHitWithAIAssistantProposal(IMarker marker) {
        OVMComplianceCheckHit hitFromMarker;
        if (marker == null) {
            return;
        }
        try {
            hitFromMarker = (OVMComplianceCheckHit)marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.HitAttribute");
            if (hitFromMarker == null) {
                return;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        this.hit = hitFromMarker;
    }

    public void apply(IDocument document) {
        this.runInternal();
    }

    public void run(IMarker marker) {
        this.runInternal();
    }

    private void runInternal() {
        VerissimoAIAutofixManager.getInstance().explainHitsUsingAIAssistant(this.hit, this.hit.getParserPath().getCanonicalPath());
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return "Explain " + this.hit.getCheck().getName() + " failure using AI Assistant";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.IMG_LINTER);
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getLabel() {
        return this.getDisplayString();
    }

    public String getDescription() {
        return this.getDisplayString();
    }
}

