/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.UserInputAutofixBeforeEdits;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.linter.base.annotations.AutofixParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameDelegate;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameRefactorInfo;

public abstract class RenameAutofix
extends UserInputAutofixBeforeEdits {
    @AutofixParameter(defaultValue="false", description="When true potential matches, for example matches in inactive code, will be renamed", name="potentialMatches", guiPrompt="Rename potential matches", type=CheckParameterType.BOOLEAN)
    public boolean potentialMatches;

    protected RenameAutofix(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    protected abstract IStatus checkIfValidName(String var1);

    protected abstract String getNewName(OVMComplianceCheckHit var1);

    @Override
    public String computeReplacementString(ReplaceEditParameters replaceEdit) {
        if (replaceEdit == null || replaceEdit.getRefactorInfo() == null || replaceEdit.getRefactorInfo().getNewName() == null) {
            return "";
        }
        return replaceEdit.getRefactorInfo().getNewName();
    }

    protected void rename(VerissimoAutofix autofix, OVMComplianceCheckHit hit, VlogRenameRefactorInfo refactorInfo) {
        HashMap<IResource, Match[]> matches;
        if (refactorInfo == null) {
            autofix.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
            return;
        }
        VlogRenameDelegate delegate = new VlogRenameDelegate(refactorInfo, false);
        delegate.checkInitialConditions(null);
        if (!this.checkNewName(autofix, delegate).isOK()) {
            autofix.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.NAME_COLLISION, delegate));
        }
        if ((matches = delegate.getRefactorInfo().getMatches()) == null) {
            autofix.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
            return;
        }
        if (!this.potentialMatches) {
            HashMap<IResource, Match[]> auxMatches = new HashMap<IResource, Match[]>();
            for (Map.Entry entry : matches.entrySet()) {
                auxMatches.put((IResource)entry.getKey(), Arrays.stream((Match[])entry.getValue()).filter(match -> {
                    if (!(match instanceof BaseFileMatch)) {
                        return false;
                    }
                    return !((BaseFileMatch)match).isPossibleMatch();
                }).collect(Collectors.toList()).toArray(new Match[0]));
            }
            matches = auxMatches;
        }
        CompositeChange rootChange = new CompositeChange("");
        for (Map.Entry entry : matches.entrySet()) {
            IResource resource = (IResource)entry.getKey();
            if (!(resource instanceof IFile)) continue;
            DVTTextFileChange textEdit = delegate.createTextEdit((IFile)resource, rootChange);
            delegate.createChangesFor((IFile)resource, (Match[])entry.getValue(), rootChange, textEdit, false);
        }
        Change[] children = rootChange.getChildren();
        if (children == null) {
            return;
        }
        Change[] changeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            MultiTextEdit edit;
            TextEdit[] allEditsInFile;
            VlogTextFileChange fileChange;
            Change child = changeArray[n2];
            if (child instanceof VlogTextFileChange && (fileChange = (VlogTextFileChange)child).getEdit() instanceof MultiTextEdit && (allEditsInFile = (edit = (MultiTextEdit)fileChange.getEdit()).getChildren()) != null) {
                ArrayList<EditParameters> convertedEdits = new ArrayList<EditParameters>();
                TextEdit[] textEditArray = allEditsInFile;
                int n3 = allEditsInFile.length;
                int n4 = 0;
                while (n4 < n3) {
                    TextEdit e = textEditArray[n4];
                    if (e instanceof ReplaceEdit) {
                        convertedEdits.add(new ReplaceEditParameters(autofix, e.getOffset(), e.getLength(), refactorInfo.getOldName(), ((ReplaceEdit)e).getText(), refactorInfo));
                    } else if (e instanceof InsertEdit) {
                        convertedEdits.add(new InsertEditParameters(autofix, e.getOffset(), ((InsertEdit)e).getText()));
                    } else if (e instanceof DeleteEdit) {
                        convertedEdits.add(new DeleteEditParameters(autofix, e.getOffset(), e.getLength()));
                    }
                    ++n4;
                }
                autofix.addEditsForHit(hit, fileChange.getFile(), convertedEdits);
            }
            ++n2;
        }
    }

    protected IStatus checkNewName(VerissimoAutofix autofix, VlogRenameDelegate delegate) {
        String newName = delegate.getRefactorInfo().getNewName();
        if (newName == null || newName.trim().isEmpty()) {
            return new Status(4, "ro.amiq.dvt", "You must provide a new name.");
        }
        if (!RfReferencesUtils.isValidIndentifierName((String)delegate.getRefactorInfo().getNewName().trim()) && delegate.getRefactorInfo().getElement().getLanguageKind() == LanguageKind.VLOG) {
            return new Status(2, "ro.amiq.dvt", "New name is not a valid identifier, prefix with '\\\\' to escape it.");
        }
        if (newName.trim().equals(delegate.getRefactorInfo().getOldName())) {
            return new Status(1, "ro.amiq.dvt", "New name is the same as old name.");
        }
        IStatus newNameStatus = delegate.checkNewName();
        if (!newNameStatus.isOK()) {
            return new Status(2, "ro.amiq.dvt", newNameStatus.getMessage());
        }
        if (!(autofix instanceof RenameAutofix)) {
            return new Status(4, "ro.amiq.dvt", "Autofix is not declared as an rename autofix");
        }
        newNameStatus = ((RenameAutofix)autofix).checkIfValidName(delegate.getRefactorInfo().getNewName());
        if (!newNameStatus.isOK()) {
            return new Status(2, "ro.amiq.dvt", newNameStatus.getMessage());
        }
        return new Status(0, "ro.amiq.dvt", "");
    }

    protected VlogRenameRefactorInfo computeRefactorInfoForHit(OVMComplianceCheckHit hit, IFile file) {
        VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
        if (additionalInfo == null) {
            return null;
        }
        Object element = additionalInfo.getElement();
        if (element == null) {
            return null;
        }
        RfWNamedElementAndScope elementAndScopeAtOffset = null;
        if (element instanceof RfNamedElement) {
            RfDefElement declaration = ((RfNamedElement)element).getDeclaration();
            if (declaration == null) {
                return null;
            }
            ReparseInfo reparseInfo = declaration.getReparseInfo();
            if (reparseInfo == null) {
                elementAndScopeAtOffset = new RfWNamedElementAndScope((RfNamedElement)element, ((RfNamedElement)element).getEnclosingScope());
            }
        } else if (element instanceof SVTBIssues) {
            RfProject rfProject = RfManager.getInstance().getRfProject(hit.getCheck().getIProject());
            IDocument document = VerissimoAutofixUtils.getInstance().getDocument(file);
            elementAndScopeAtOffset = RfUtils.getRfElement(rfProject, file, document, ((SVTBIssues)element).getOffset(), null);
        }
        if (elementAndScopeAtOffset == null || elementAndScopeAtOffset.getNamedElement() == null) {
            return null;
        }
        return new VlogRenameRefactorInfo(hit.getCheck().getIProject(), elementAndScopeAtOffset, null);
    }
}

