/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameRefactorInfo;

public class ReplaceEditParameters
extends EditParameters {
    private int length;
    private String replacement;
    private String replacementDefault;
    private String initialText;
    private VlogRenameRefactorInfo refactorInfo;

    public ReplaceEditParameters(VerissimoAutofix autofix, int startOffset, int length, String replacement) {
        super(autofix, startOffset);
        this.length = length;
        this.initialText = null;
        this.replacement = replacement;
        this.replacementDefault = replacement;
        this.type = EditParameters.TYPE.REPLACE;
    }

    public ReplaceEditParameters(VerissimoAutofix autofix, int startOffset, int length, String initialText, String replacement) {
        super(autofix, startOffset);
        this.length = length;
        this.initialText = initialText;
        this.replacement = replacement;
        this.replacementDefault = replacement;
        this.type = EditParameters.TYPE.REPLACE;
    }

    public ReplaceEditParameters(VerissimoAutofix autofix, int startOffset, int length, String initialText, String replacement, VlogRenameRefactorInfo refactorInfo) {
        super(autofix, startOffset);
        this.length = length;
        this.initialText = initialText;
        this.replacement = replacement;
        this.refactorInfo = refactorInfo;
        this.type = EditParameters.TYPE.REPLACE;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public String getContent() {
        return this.replacement;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public String getReplacementDefault() {
        return this.replacementDefault;
    }

    public VlogRenameRefactorInfo getRefactorInfo() {
        return this.refactorInfo;
    }

    public String getInitial() {
        return this.initialText;
    }

    @Override
    public boolean isValid(OVMComplianceCheckHit hit) {
        if (this.length < 0) {
            this.autofix.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
            return false;
        }
        return super.isValid(hit);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.initialText == null ? 0 : this.initialText.hashCode());
        result = 31 * result + this.length;
        result = 31 * result + (this.replacement == null ? 0 : this.replacement.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplaceEditParameters other = (ReplaceEditParameters)obj;
        if (this.initialText == null ? other.initialText != null : !this.initialText.equals(other.initialText)) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        return !(this.replacement == null ? other.replacement != null : !this.replacement.equals(other.replacement));
    }
}

