/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixWizardPage;
import ro.amiq.vlogdt.linter.base.annotations.AutofixParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;

public abstract class UserInputAutofix
extends VerissimoAutofix {
    private VerissimoAutofixWizardPage wizardPage;
    private final Map<AutofixParameterCurrent, String> parametersValues = new HashMap<AutofixParameterCurrent, String>();
    private Class<?> autofixClass = this.getClass();
    protected String errorMessage = null;

    protected UserInputAutofix(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    public UserInputWizardPage getWizardPage(final VerissimoAutofix autofix) {
        this.wizardPage = new VerissimoAutofixWizardPage(""){

            public void createControl(Composite parent) {
                try {
                    this.setControl((Control)UserInputAutofix.this.getParametersAndGetComposite(autofix, UserInputAutofix.this.autofixClass, parent));
                }
                catch (SecurityException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        };
        return this.wizardPage;
    }

    protected Composite getParametersAndGetComposite(VerissimoAutofix autofix, Class<?> currentClass, Composite parent) {
        Class<?> iterClass = currentClass;
        ArrayList<Field> allFields = new ArrayList<Field>();
        while (iterClass != UserInputAutofix.class) {
            allFields.addAll(Arrays.asList(iterClass.getDeclaredFields()));
            iterClass = iterClass.getSuperclass();
        }
        List autofixParamFields = allFields.stream().filter(field -> field.isAnnotationPresent(AutofixParameter.class)).collect(Collectors.toList());
        List<AutofixParameterCurrent> autofixParamCurrent = autofixParamFields.stream().map(field -> {
            try {
                field.setAccessible(true);
                return new AutofixParameterCurrent(field.getAnnotation(AutofixParameter.class), field.get(autofix).toString());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }).collect(Collectors.toList());
        return this.createControlComposite(autofixParamCurrent, parent);
    }

    public String computeReplacementString(ReplaceEditParameters replaceEdit) {
        return replaceEdit.getReplacement();
    }

    public String computeReplacementString(InsertEditParameters insertEdit) {
        return insertEdit.getInsertedString();
    }

    protected void configure(OVMComplianceCheck check) {
        Field[] fields;
        Class<?> currentClass = this.getClass();
        Field[] fieldArray = fields = currentClass.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                Field field = fieldArray[n2];
                AutofixParameter annot = field.getAnnotation(AutofixParameter.class);
                if (annot != null) {
                    String propertyName = annot.name();
                    CheckParameterType propertyType = annot.type();
                    String propertyValue = check.getAutoCorrectInput().get(propertyName);
                    if (!propertyType.isCompatibleWith(field.getGenericType().getTypeName())) {
                        DVTLogger.INSTANCE.logError("Verissimo auto-correct for check '" + check.getID() + "' contains an incompatible filed - parameter combination '" + field.getDeclaringClass().getCanonicalName() + "," + field.getName() + "' of type '" + field.getGenericType().toString() + "' - '" + propertyType.name() + "'!");
                    }
                    if (propertyValue == null) {
                        propertyValue = annot.defaultValue();
                    }
                    Object parsedValue = null;
                    try {
                        parsedValue = propertyType.parse(propertyValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (propertyType == CheckParameterType.BOOLEAN) {
                            check.addConfigurationError("Autofix parameter '" + propertyName + "' is an invalid boolean!");
                            check.setConfigurationErrors(true);
                        } else {
                            check.addConfigurationError("Autofix parameter '" + propertyName + "' is an invalid integer!");
                            check.setConfigurationErrors(true);
                        }
                        break block11;
                    }
                    if (parsedValue != null) {
                        try {
                            field.setAccessible(true);
                            field.set(this, parsedValue);
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            check.addConfigurationError("Internal error while reading the value of '" + propertyName + "' parameter!");
                            check.setConfigurationErrors(true);
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                }
            }
            ++n2;
        }
        this.errorMessage = this.checkUserInput();
    }

    protected String checkUserInput() {
        return null;
    }

    protected void startUICheckJob() {
        this.wizardPage.setErrorMessage(this.errorMessage);
        this.wizardPage.updateAndValidate();
    }

    protected void checkUserInputGeneral() {
        this.errorMessage = this.checkUserInputAndUpdate();
        if (this.errorMessage == null) {
            this.errorMessage = this.checkUserInput();
        }
        this.startUICheckJob();
    }

    protected String checkUserInputAndUpdate() {
        block11: for (Map.Entry<AutofixParameterCurrent, String> paramEntry : this.parametersValues.entrySet()) {
            AutofixParameterCurrent param = paramEntry.getKey();
            String value = paramEntry.getValue();
            if (value == null || value.isEmpty()) {
                return "You must provide a value for `" + param.getAutofixParameter().name() + "` parameter.";
            }
            Field field = null;
            Class<?> iterClass = this.autofixClass;
            while (iterClass != UserInputAutofix.class) {
                try {
                    field = iterClass.getDeclaredField(param.getAutofixParameter().name());
                    break;
                }
                catch (NoSuchFieldException | SecurityException exception) {
                    iterClass = iterClass.getSuperclass();
                }
            }
            if (field == null) {
                String errMessage = "Parameter `" + param.getAutofixParameter().name() + "` was not found!";
                DVTLogger.INSTANCE.logError(errMessage);
                return errMessage;
            }
            try {
                switch (param.getAutofixParameter().type()) {
                    case INTEGER: {
                        try {
                            int intValue = Integer.parseInt(value);
                            field.setInt(this, intValue);
                            continue block11;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return "Autofix parameter '" + param.getAutofixParameter().name() + "' is an invalid integer!";
                        }
                    }
                    case BOOLEAN: {
                        boolean boolValue = Boolean.parseBoolean(value);
                        field.setBoolean(this, boolValue);
                        continue block11;
                    }
                    case STRING: {
                        String stringValue = value;
                        field.set(this, stringValue);
                        continue block11;
                    }
                    default: {
                        return null;
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return e.getMessage();
            }
        }
        return null;
    }

    protected Composite createControlComposite(List<AutofixParameterCurrent> autofixParameters, Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        for (AutofixParameterCurrent autofixParameter : autofixParameters) {
            switch (autofixParameter.getAutofixParameter().type()) {
                case BOOLEAN: {
                    this.createBooleanElements(composite, autofixParameter);
                    break;
                }
                case INTEGER: {
                    this.createIntegerElements(composite, autofixParameter);
                    break;
                }
                case STRING: {
                    this.createStringElements(composite, autofixParameter);
                    break;
                }
                case CSL_REGEX: {
                    break;
                }
                case CSL_STRING: {
                    break;
                }
                case REGEX: {
                    break;
                }
            }
        }
        this.checkUserInputGeneral();
        return composite;
    }

    protected void createIntegerElements(Composite parent, AutofixParameterCurrent parameter) {
        Label integerLabel = new Label(parent, 0);
        integerLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        integerLabel.setText(parameter.getAutofixParameter().guiPrompt());
        Text integerText = new Text(parent, 2048);
        integerText.setText(parameter.getValue());
        integerText.setLayoutData((Object)new GridData(4, 4, true, false));
        integerText.addModifyListener(e -> {
            this.parametersValues.put(parameter, integerText.getText());
            this.checkUserInputGeneral();
        });
    }

    protected void createBooleanElements(Composite parent, final AutofixParameterCurrent parameter) {
        Label booleanLabel = new Label(parent, 0);
        booleanLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        booleanLabel.setText(parameter.getAutofixParameter().guiPrompt());
        final Button falseButton = new Button(parent, 16);
        falseButton.setText("False");
        falseButton.setSelection(parameter.getValue().equals("false"));
        falseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (falseButton.getSelection()) {
                    UserInputAutofix.this.parametersValues.put(parameter, "False");
                }
                UserInputAutofix.this.checkUserInputGeneral();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        final Button trueButton = new Button(parent, 16);
        trueButton.setText("True");
        trueButton.setSelection(parameter.getValue().equals("true"));
        trueButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (trueButton.getSelection()) {
                    UserInputAutofix.this.parametersValues.put(parameter, "True");
                }
                UserInputAutofix.this.checkUserInputGeneral();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected void createStringElements(Composite parent, final AutofixParameterCurrent parameter) {
        Label stringLabel = new Label(parent, 0);
        stringLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        stringLabel.setText(parameter.getAutofixParameter().guiPrompt());
        if (parameter.getAutofixParameter().allowedValues().length == 0) {
            Text stringText = new Text(parent, 2048);
            stringText.setText(parameter.getValue());
            stringText.setLayoutData((Object)new GridData(4, 4, true, false));
            stringText.addModifyListener(e -> {
                this.parametersValues.put(parameter, stringText.getText());
                this.checkUserInputGeneral();
            });
        } else {
            String[] stringArray = parameter.getAutofixParameter().allowedValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                final String possibleValue = stringArray[n2];
                final Button possibleValueButton = new Button(parent, 16);
                possibleValueButton.setText(possibleValue);
                possibleValueButton.setSelection(parameter.getValue().equals(possibleValue));
                possibleValueButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (possibleValueButton.getSelection()) {
                            UserInputAutofix.this.parametersValues.put(parameter, possibleValue);
                        }
                        UserInputAutofix.this.checkUserInputGeneral();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                ++n2;
            }
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static class AutofixParameterCurrent {
        private AutofixParameter parameter;
        private String value;

        public AutofixParameterCurrent(AutofixParameter parameter, String value) {
            this.parameter = parameter;
            this.value = value;
        }

        public AutofixParameter getAutofixParameter() {
            return this.parameter;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String object) {
            this.value = object;
        }
    }
}

