/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.UserInputAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;

public abstract class UserInputAutofixBeforeEdits
extends UserInputAutofix {
    private InputDialog dialog;
    private Class<?> currentClass = this.getClass();

    protected UserInputAutofixBeforeEdits(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    public UserInputWizardPage getWizardPage(VerissimoAutofix autofix) {
        return null;
    }

    @Override
    protected void startUICheckJob() {
        this.dialog.errorMessageText.setText("");
        if (this.errorMessage == null || this.errorMessage.isEmpty()) {
            return;
        }
        this.dialog.errorMessageText.setText(this.errorMessage);
    }

    public CompletableFuture<Boolean> displayInputDialog(VerissimoAutofix autofix) {
        CompletableFuture<Boolean> dialogResult = new CompletableFuture<Boolean>();
        Shell currentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        this.dialog = new InputDialog(currentShell, autofix);
        if (this.dialog.open() == 1) {
            dialogResult.complete(false);
        }
        dialogResult.complete(true);
        return dialogResult;
    }

    private class InputDialog
    extends Dialog {
        VerissimoAutofix autofix;
        Composite composite;
        Text errorMessageText;

        public InputDialog(Shell parent, VerissimoAutofix autofix) {
            super(parent);
            this.autofix = autofix;
        }

        protected Control createDialogArea(Composite parent) {
            this.errorMessageText = new Text(parent, 72);
            this.errorMessageText.setForeground(parent.getDisplay().getSystemColor(3));
            this.errorMessageText.setLayoutData((Object)new GridData(768));
            this.errorMessageText.setBackground(parent.getDisplay().getSystemColor(22));
            try {
                this.composite = UserInputAutofixBeforeEdits.this.getParametersAndGetComposite(this.autofix, UserInputAutofixBeforeEdits.this.currentClass, parent);
            }
            catch (SecurityException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return this.composite;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Autocorrect input");
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }
}

