/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTSplashMLT;
import ro.amiq.dvt.ai.AIHostContributorManager;
import ro.amiq.dvt.ai.IAIHostContributor;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.quick.proposals.QuickProposalPriorityByType;
import ro.amiq.dvt.ui.editor.quick.proposals.QuickProposalsWrapper;
import ro.amiq.dvt.ui.editor.quickfix.QuickFixAnnotationPriority;
import ro.amiq.dvt.ui.editor.quickfix.QuickFixAnnotationWrapper;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.linter.LintingProgressAndAliveMonitor;
import ro.amiq.vlogdt.linter.OVMComplianceBuilder;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.ExplainVerissimoHitWithAIAssistantProposal;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAIAutofixProcessor;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAIAutofixProposal;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAIAutofixWizard;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixManager;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixManagerCommon;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.linter.ui.LintingProblemsManager;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfManager;

public class VerissimoAIAutofixManager
extends VerissimoAutofixManager {
    private static VerissimoAIAutofixManager fInstance;
    private static final Object fSyncInstance;
    private static final long BUSY_INDICATOR_TIMEOUT = 1500L;
    private static final int QUICK_FIX_TOOLTIP_TIMEOUT = 200;
    private List<VerissimoAutofixManagerCommon.AIAutofixEdit> allAIAutofixEdits = new ArrayList<VerissimoAutofixManagerCommon.AIAutofixEdit>();
    private String currentTaskName = "";

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VerissimoAIAutofixManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new VerissimoAIAutofixManager();
            }
        }
        return fInstance;
    }

    public void addAIAutofixFileEdit(List<VerissimoAutofixManagerCommon.AIAutofixEdit> aiAutofixEdits) {
        this.allAIAutofixEdits.addAll(aiAutofixEdits);
    }

    public void clearAIAutofixEdits() {
        this.allAIAutofixEdits.clear();
    }

    protected void refreshProjectAfterAIAutocorrect(Set<IFile> refreshFiles, Set<IFile> affectedFiles, OVMProject ovmProject) {
        this.refreshFiles(refreshFiles, affectedFiles, ovmProject);
        this.updateProjectAndLintOnRefresh(ovmProject, true, true);
    }

    public boolean applyAIFixesAndRefresh() {
        HashSet<IFile> refreshFiles = new HashSet<IFile>();
        HashSet<IFile> affectedFiles = new HashSet<IFile>();
        VerissimoAIAutofixProcessor processor = new VerissimoAIAutofixProcessor(this.allAIAutofixEdits, refreshFiles, affectedFiles);
        ProcessorBasedRefactoring refactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
        VerissimoAIAutofixWizard wizard = new VerissimoAIAutofixWizard((Refactoring)refactoring);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                try {
                    int err = op.run(DVTUiUtils.getActiveWorkbenchShell(), "");
                    if (err == 1) {
                        throw new CancellationException();
                    }
                    this.refreshProjectAfterAIAutocorrect(refreshFiles, affectedFiles, OVMComplianceBuilder.getInstance().getOVMProject(DVTFileUtils.getInstance().getSelectedProject()));
                }
                catch (InterruptedException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            });
        }
        catch (SWTException sWTException) {
            return false;
        }
        return true;
    }

    public VerissimoAutofixManagerCommon.EditsResult getEditsResultFromAIAutofixEdits(List<VerissimoAutofixManagerCommon.AIAutofixEdit> aiEdits) {
        if (aiEdits == null || aiEdits.isEmpty()) {
            return null;
        }
        HashMap<IFile, List<EditParameters>> editsByFile = new HashMap<IFile, List<EditParameters>>();
        for (VerissimoAutofixManagerCommon.AIAutofixEdit aiEdit : aiEdits) {
            int endOffset;
            int startOffset;
            IDocument document;
            String editFile = aiEdit.getFilePath();
            IFile iFile = this.getFileFromPath(DVTFileUtils.getInstance().getSelectedProject(), editFile);
            if (iFile == null || (document = VerissimoAutofixUtils.getInstance().getDocumentFromFile(iFile)) == null) continue;
            try {
                startOffset = document.getLineOffset(aiEdit.getStart() - 1);
                endOffset = document.getLineOffset(aiEdit.getEnd() - 1) + document.getLineLength(aiEdit.getEnd() - 1) - document.getLineDelimiter(aiEdit.getEnd() - 1).length();
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                continue;
            }
            ReplaceEditParameters verissimoAutofixEdit = new ReplaceEditParameters(null, startOffset, endOffset - startOffset, aiEdit.getReplacement());
            editsByFile.putIfAbsent(iFile, new ArrayList());
            ((List)editsByFile.get(iFile)).add(verissimoAutofixEdit);
        }
        Set<IFile> refreshFiles = this.calculateFilesToRefresh(editsByFile);
        return new VerissimoAutofixManagerCommon.EditsResult(refreshFiles, editsByFile);
    }

    private IFile getFileFromPath(IProject project, String path) {
        Path filePath = new Path(path);
        Object absolutePath = filePath.isAbsolute() ? filePath : project.getLocation().append((IPath)filePath);
        return DVTFileUtils.getInstance().getWorkspaceFiles(project, absolutePath.toOSString())[0];
    }

    public List<VerissimoAutofixManagerCommon.AIAutofixEdit> autocorrectHitsUsingAIAssistant(List<?> verissimoHitsInfo, String filePath, String blueprintName, BooleanSupplier isCanceled) {
        if (verissimoHitsInfo.isEmpty()) {
            return null;
        }
        Object hitInfo = verissimoHitsInfo.get(0);
        if (!(hitInfo instanceof OVMComplianceCheckHit)) {
            return null;
        }
        IProject iProject = ((OVMComplianceCheckHit)hitInfo).getCheck().getIProject();
        if (iProject == null) {
            return null;
        }
        IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
        if (aiHostContributor == null || aiHostContributor.isFileProtected(filePath, iProject)) {
            return null;
        }
        Object verissimoResult = aiHostContributor.autocorrectVerissimoHit(verissimoHitsInfo, isCanceled, blueprintName);
        if (!(verissimoResult instanceof List)) {
            return null;
        }
        List verissimoResultList = (List)verissimoResult;
        return verissimoResultList.stream().filter(VerissimoAutofixManagerCommon.AIAutofixEdit.class::isInstance).map(VerissimoAutofixManagerCommon.AIAutofixEdit.class::cast).collect(Collectors.toList());
    }

    public boolean explainHitsUsingAIAssistant(Object verissimoHitInfo, String filePath) {
        if (!(verissimoHitInfo instanceof OVMComplianceCheckHit)) {
            return false;
        }
        IProject iProject = ((OVMComplianceCheckHit)verissimoHitInfo).getCheck().getIProject();
        if (iProject == null) {
            return false;
        }
        IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
        if (aiHostContributor == null || aiHostContributor.isFileProtected(filePath, iProject)) {
            return false;
        }
        if (!DVTSplashMLT.INSTANCE.cc(true, new String[]{"F73765F6C696E74"})) {
            return false;
        }
        try {
            aiHostContributor.explainVerissimoHit(verissimoHitInfo);
        }
        finally {
            DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
        }
        return true;
    }

    public void fixFailuresUsingAI(List<OVMComplianceCheckHit> hits, String blueprintName, boolean appliedOnCheck) {
        OVMComplianceCheck check;
        OVMProject ovmProject = RfManager.getInstance().getRfProject(DVTFileUtils.getInstance().getSelectedProject()).getOvmProject();
        if (ovmProject.isDirty((check = hits.get(0).getCheck()).getName())) {
            boolean returnValue = this.showDirtyDialog(check, ovmProject);
            if (!returnValue) {
                return;
            }
            ArrayList<OVMComplianceCheckHit> allHits = check.getAllAutoCorrectabledHits();
            if (!appliedOnCheck) {
                ArrayList<OVMComplianceCheckHit> newHits = new ArrayList<OVMComplianceCheckHit>();
                for (OVMComplianceCheckHit hit : allHits) {
                    if (!Arrays.stream(hits.toArray()).anyMatch(x -> hit.getSignature().equals(((OVMComplianceCheckHit)x).getSignature()))) continue;
                    newHits.add(hit);
                }
                hits = newHits;
                if (hits.isEmpty()) {
                    this.showNoHitsErrorDialog();
                    return;
                }
            } else {
                hits = allHits;
            }
        }
        if (hits == null || hits.isEmpty()) {
            return;
        }
        if (this.sourceCodeChanged(ovmProject.getProject())) {
            return;
        }
        this.computeAIAutofixJob(hits, blueprintName);
    }

    public void computeAIAutofixJob(List<OVMComplianceCheckHit> hits, final String blueprintName) {
        String jobTitle;
        this.currentTaskName = jobTitle = "Fix Verissimo Hits using AI Assistant";
        final AtomicBoolean areAllAutofixesDone = new AtomicBoolean(false);
        final AtomicBoolean wasMasterJobCanceled = new AtomicBoolean(false);
        long busyIndicatorTimeout = System.currentTimeMillis() + 1500L;
        final Map<ParserPath, List<OVMComplianceCheckHit>> hitByFile = this.splitVerissimoHitsByFile(hits);
        VerissimoAIAutofixManager.getInstance().clearAIAutofixEdits();
        Job computeAllAIAutofixes = new Job(jobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                if (!VerissimoAutofixManager.getInstance().checkOutLicense()) {
                    areAllAutofixesDone.set(true);
                    return Status.CANCEL_STATUS;
                }
                try {
                    for (Map.Entry hitAndFileEntry : hitByFile.entrySet()) {
                        VerissimoAIAutofixManager.this.currentTaskName = "Fixing: " + LintUtils.getFileShortName(((ParserPath)hitAndFileEntry.getKey()).path);
                        BooleanSupplier supplier = () -> wasMasterJobCanceled.get();
                        List<VerissimoAutofixManagerCommon.AIAutofixEdit> aiAutofixEdits = VerissimoAIAutofixManager.getInstance().autocorrectHitsUsingAIAssistant((List)hitAndFileEntry.getValue(), ((ParserPath)hitAndFileEntry.getKey()).getCanonicalPath(), blueprintName, supplier);
                        if (aiAutofixEdits != null) {
                            VerissimoAIAutofixManager.getInstance().addAIAutofixFileEdit(aiAutofixEdits);
                        }
                        if (!wasMasterJobCanceled.get()) continue;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                }
                finally {
                    VerissimoAutofixManager.getInstance().checkInLicense();
                    areAllAutofixesDone.set(true);
                }
                return Status.OK_STATUS;
            }

            protected void canceling() {
                wasMasterJobCanceled.set(true);
            }
        };
        computeAllAIAutofixes.schedule();
        this.showBusyIndAndProgressMonitorAfterTImeout(computeAllAIAutofixes, areAllAutofixesDone, busyIndicatorTimeout, hitByFile.size());
        VerissimoAIAutofixManager.getInstance().applyAIFixesAndRefresh();
    }

    private void showBusyIndAndProgressMonitorAfterTImeout(Job job, AtomicBoolean jobStatus, long busyIndicatorTimeout, int workAmount) {
        Display display = Display.getCurrent();
        DVTUiUtils.runWithBusyIndicator(() -> {
            while (!jobStatus.get() && System.currentTimeMillis() < busyIndicatorTimeout) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        if (jobStatus.get()) {
            return;
        }
        Shell shell = DVTUiUtils.getActiveWorkbenchShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        try {
            dialog.run(false, true, monitor -> {
                LintingProgressAndAliveMonitor lintingMonitor = new LintingProgressAndAliveMonitor(monitor);
                if (jobStatus.get()) {
                    return;
                }
                lintingMonitor.beginTask("", workAmount);
                while (!jobStatus.get()) {
                    if (lintingMonitor.isCanceled()) {
                        job.cancel();
                        break;
                    }
                    if (!lintingMonitor.getCurrentTaskName().equals(this.currentTaskName)) {
                        if (!lintingMonitor.getCurrentTaskName().isEmpty()) {
                            lintingMonitor.worked(1);
                        }
                        lintingMonitor.subTask(this.currentTaskName);
                    }
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                lintingMonitor.worked(1);
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private Map<ParserPath, List<OVMComplianceCheckHit>> splitVerissimoHitsByFile(List<OVMComplianceCheckHit> checkHits) {
        HashMap<ParserPath, List<OVMComplianceCheckHit>> hitsByFile = new HashMap<ParserPath, List<OVMComplianceCheckHit>>();
        for (OVMComplianceCheckHit hit : checkHits) {
            hitsByFile.putIfAbsent(hit.getParserPath(), new ArrayList());
            ((List)hitsByFile.get(hit.getParserPath())).add(hit);
        }
        return hitsByFile;
    }

    public List<ICompletionProposal> getAIProposalsForMarker(IMarker marker) {
        if (!marker.exists()) {
            return null;
        }
        try {
            if (marker.getType().equals("ro.amiq.vlogdt.LintingErrorMarker")) {
                ArrayList<ICompletionProposal> allVerissimoProposals = new ArrayList<ICompletionProposal>();
                if (this.isVerissimoAIActionAvailable(marker)) {
                    List<ICompletionProposal> aiExplainProposalsFromMarker;
                    List<ICompletionProposal> aiAutofixProposalsFromMarker = this.getAIAutofixProposalFromMarker(marker, true);
                    if (aiAutofixProposalsFromMarker != null) {
                        allVerissimoProposals.addAll(aiAutofixProposalsFromMarker);
                    }
                    if ((aiExplainProposalsFromMarker = this.getAIExplainProposalFromMarker(marker)) != null) {
                        allVerissimoProposals.addAll(aiExplainProposalsFromMarker);
                    }
                }
                return allVerissimoProposals;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        return null;
    }

    public List<QuickProposalsWrapper> getAIExplainProposalsFromMarkers(List<QuickFixAnnotationWrapper> lintingAnnotations) {
        ArrayList<QuickProposalsWrapper> explainProposals = new ArrayList<QuickProposalsWrapper>();
        if (lintingAnnotations == null || lintingAnnotations.isEmpty()) {
            return explainProposals;
        }
        for (QuickFixAnnotationWrapper lintingAnnotation : lintingAnnotations) {
            try {
                List<ICompletionProposal> proposals;
                if (lintingAnnotation.getQuickFixProposalPriority() == QuickFixAnnotationPriority.WAIVER_AT_CURSOR || lintingAnnotation.getQuickFixProposalPriority() == QuickFixAnnotationPriority.WAIVER_AT_LINE || (proposals = this.getAIExplainProposalFromMarker(lintingAnnotation.getAnnotation().getMarker())) == null) continue;
                for (ICompletionProposal proposal : proposals) {
                    QuickProposalsWrapper quickFixWrapper = new QuickProposalsWrapper(proposal, QuickProposalPriorityByType.VERISSIMO_HIT_EXPLAIN, lintingAnnotation.getMarkerOffset());
                    quickFixWrapper.setQuickFixAnnotationPriority(lintingAnnotation.getQuickFixProposalPriority());
                    explainProposals.add(quickFixWrapper);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return explainProposals;
    }

    public List<ICompletionProposal> getAIExplainProposalFromMarker(IMarker annotation) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
        if (aiHostContributor == null) {
            return null;
        }
        proposals.add(new ExplainVerissimoHitWithAIAssistantProposal(annotation));
        return proposals;
    }

    public List<QuickProposalsWrapper> getAIAutofixProposalsFromMarkers(List<QuickFixAnnotationWrapper> lintingAnnotations) {
        ArrayList<QuickProposalsWrapper> autoFixProposals = new ArrayList<QuickProposalsWrapper>();
        if (lintingAnnotations == null || lintingAnnotations.isEmpty()) {
            return autoFixProposals;
        }
        for (QuickFixAnnotationWrapper lintingAnnotation : lintingAnnotations) {
            try {
                List<ICompletionProposal> proposals;
                if (lintingAnnotation.getQuickFixProposalPriority() == QuickFixAnnotationPriority.WAIVER_AT_CURSOR || lintingAnnotation.getQuickFixProposalPriority() == QuickFixAnnotationPriority.WAIVER_AT_LINE || (proposals = this.getAIAutofixProposalFromMarker(lintingAnnotation.getAnnotation().getMarker(), true)) == null) continue;
                for (ICompletionProposal proposal : proposals) {
                    QuickProposalsWrapper quickFixWrapper = new QuickProposalsWrapper(proposal, QuickProposalPriorityByType.VERISSIMO_AI_AUTOFIX, lintingAnnotation.getMarkerOffset());
                    quickFixWrapper.setQuickFixAnnotationPriority(lintingAnnotation.getQuickFixProposalPriority());
                    autoFixProposals.add(quickFixWrapper);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return autoFixProposals;
    }

    /*
     * Unable to fully structure code
     */
    public List<ICompletionProposal> getAIAutofixProposalFromMarker(final IMarker marker, boolean startMonitorJob) {
        proposals = new ArrayList<ICompletionProposal>();
        aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
        if (aiHostContributor == null) {
            return null;
        }
        try {
            hit = (OVMComplianceCheckHit)marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.HitAttribute");
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        jobTitle = "Compute AI Autofix Proposals";
        done = new AtomicBoolean(false);
        computingQuickFixProposalJob = new Job(jobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    List blueprintNames = aiHostContributor.getVerissimoBlueprintsForHit(hit.getCheck().getName());
                    if (blueprintNames == null || blueprintNames.isEmpty()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    proposals.addAll(blueprintNames.stream().map(blueprint -> VerissimoAIAutofixManager.this.getLintingAIAutofixProposalFromMarker(marker, hit, (String)blueprint, blueprintNames.size() == 1)).collect(Collectors.toList()));
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    done.set(true);
                }
            }
        };
        computingQuickFixProposalJob.schedule();
        busyIndicatorTimeout = System.currentTimeMillis() + 1500L;
        if (!DVTUiUtils.isUiThread()) ** GOTO lbl23
        DVTUiUtils.showBusyIndAndProgressMonitorAfterTImeout((Job)computingQuickFixProposalJob, (AtomicBoolean)done, (String)jobTitle, (long)busyIndicatorTimeout);
        return proposals;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException v0) {}
lbl23:
            // 3 sources

            ** while (!done.get())
        }
lbl24:
        // 1 sources

        if (proposals.isEmpty()) {
            return null;
        }
        return proposals;
    }

    public ICompletionProposal getLintingAIAutofixProposalFromMarker(IMarker marker, OVMComplianceCheckHit hit, String blueprint, boolean singleBlueprint) {
        block3: {
            try {
                String markerType = marker.getType();
                if (LintingProblemsManager.LINTING_MARKERS.contains(markerType)) break block3;
                return null;
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return new VerissimoAIAutofixProposal(hit, marker, blueprint, singleBlueprint);
    }

    /*
     * Unable to fully structure code
     */
    public List<String> getAIAutofixBlueprintNames(final String rulesToApplyOn) {
        block4: {
            aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
            if (aiHostContributor == null) {
                return null;
            }
            done = new AtomicBoolean(false);
            blueprintNames = new ArrayList<String>();
            computingBlueprintNames = new Job("Getting available blueprints for AI autofix"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        blueprintNames.addAll(aiHostContributor.getVerissimoBlueprintsForHit(rulesToApplyOn));
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        if (blueprintNames == null || blueprintNames.isEmpty()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    finally {
                        done.set(true);
                    }
                }
            };
            computingBlueprintNames.schedule();
            busyIndicatorTimeout = System.currentTimeMillis() + 200L;
            if (!DVTUiUtils.isUiThread()) ** GOTO lbl16
            DVTUiUtils.showBusyIndAndProgressMonitorAfterTImeout((Job)computingBlueprintNames, (AtomicBoolean)done, (String)"Getting available blueprints for AI autofix", (long)busyIndicatorTimeout);
            break block4;
lbl-1000:
            // 1 sources

            {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException v0) {}
lbl16:
                // 3 sources

                ** while (!done.get())
            }
        }
        return blueprintNames;
    }

    public boolean isFileAIAvailable(String file) {
        IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
        if (aiHostContributor == null) {
            return false;
        }
        return !aiHostContributor.isFileProtected(file, DVTFileUtils.getInstance().getSelectedProject()) && aiHostContributor.isAIModelsAvailable();
    }

    public boolean isVerissimoAIActionAvailable(IMarker marker) {
        if (marker == null || !marker.exists()) {
            return false;
        }
        IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
        if (aiHostContributor == null || !aiHostContributor.isAIModelsAvailable()) {
            return false;
        }
        String filePath = this.getFilePathFromMarker(marker);
        if (filePath == null) {
            return false;
        }
        IResource markerResource = marker.getResource();
        if (markerResource == null) {
            return false;
        }
        IProject iProject = markerResource.getProject();
        if (iProject == null) {
            return false;
        }
        return !aiHostContributor.isFileProtected(filePath, iProject);
    }

    public String getFilePathFromMarker(IMarker marker) {
        if (marker == null || !marker.exists()) {
            return null;
        }
        return marker.getResource().getLocation() != null ? marker.getResource().getLocation().toOSString() : null;
    }
}

