/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import ro.amiq.dvt.ui.refactor.DVTRefactoringProcessor;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAIAutofixManager;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixManager;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixManagerCommon;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public class VerissimoAIAutofixProcessor
extends DVTRefactoringProcessor {
    private List<VerissimoAutofixManagerCommon.AIAutofixEdit> edits;
    private Set<IFile> refreshFiles;
    private Set<IFile> affectedFiles;

    public VerissimoAIAutofixProcessor(List<VerissimoAutofixManagerCommon.AIAutofixEdit> edits, Set<IFile> refreshFiles, Set<IFile> affectedFiles) {
        this.edits = edits;
        this.refreshFiles = refreshFiles;
        this.affectedFiles = affectedFiles;
    }

    public Object[] getElements() {
        return new Object[0];
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getProcessorName() {
        return "Fix failures using AI";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (this.edits.isEmpty()) {
            status.addFatalError("No refactoring to perform!");
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange rootChange = new CompositeChange(this.getProcessorName());
        VerissimoAutofixManagerCommon.EditsResult editsResultFromAIAutofixEdits = VerissimoAIAutofixManager.getInstance().getEditsResultFromAIAutofixEdits(this.edits);
        if (editsResultFromAIAutofixEdits == null) {
            return null;
        }
        this.refreshFiles.addAll(editsResultFromAIAutofixEdits.getRefreshFiles());
        this.affectedFiles.addAll(editsResultFromAIAutofixEdits.getEditsByFile().keySet());
        Map<IResource, VlogTextFileChange> changesPerFiles = VerissimoAutofixManager.getInstance().createChangesFromEditsOrganizedByFile(editsResultFromAIAutofixEdits);
        if (changesPerFiles != null) {
            for (Map.Entry<IResource, VlogTextFileChange> entry : changesPerFiles.entrySet()) {
                VlogTextFileChange fileChange = entry.getValue();
                if (fileChange.getEdit().getChildrenSize() <= 0) continue;
                rootChange.add((Change)fileChange);
            }
        }
        return rootChange;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }
}

