/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAIAutofixManager;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;

public class VerissimoAIAutofixProposal
extends WorkbenchMarkerResolution
implements ICompletionProposal {
    private OVMComplianceCheckHit hit;
    private IMarker marker;
    private String fBlueprintName;
    private boolean fSingleBlueprint;

    public VerissimoAIAutofixProposal(OVMComplianceCheckHit hit) {
        this.hit = hit;
    }

    public VerissimoAIAutofixProposal(OVMComplianceCheckHit hit, IMarker marker, String blueprintName, boolean singleBlueprint) {
        this.hit = hit;
        this.marker = marker;
        this.fBlueprintName = blueprintName;
        this.fSingleBlueprint = singleBlueprint;
    }

    public void apply(IDocument document) {
        this.run(new IMarker[]{this.marker}, null);
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.getDisplayString();
    }

    public String getDisplayString() {
        return "Fix " + this.hit.getCheck().getName() + " failure using AI Assistant" + VerissimoAutofixUtils.getInstance().getAIAutofixButtonSuffixIfNecessary(this.fBlueprintName, this.fSingleBlueprint);
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.IMG_LINTER);
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDescription() {
        return "";
    }

    public String getLabel() {
        return this.getDisplayString();
    }

    public void run(IMarker[] markers, IProgressMonitor monitor) {
        if (markers == null || markers.length == 0) {
            return;
        }
        ArrayList<OVMComplianceCheckHit> hits = new ArrayList<OVMComplianceCheckHit>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                OVMComplianceCheckHit hitFromMarker;
                block5: {
                    IMarker marker = iMarkerArray[n2];
                    try {
                        hitFromMarker = (OVMComplianceCheckHit)marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.HitAttribute");
                        if (hitFromMarker == null) {
                        }
                        break block5;
                    }
                    catch (CoreException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    break block6;
                }
                hits.add(hitFromMarker);
            }
            ++n2;
        }
        VerissimoAIAutofixManager.getInstance().fixFailuresUsingAI(hits, this.fBlueprintName, false);
    }

    public OVMComplianceCheckHit getVerissimoCheckHitFromMarker(IMarker marker) {
        OVMComplianceCheckHit hitFromMarker;
        if (marker == null) {
            return null;
        }
        try {
            hitFromMarker = (OVMComplianceCheckHit)marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.HitAttribute");
            if (hitFromMarker == null) {
                return null;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        return hitFromMarker;
    }

    public void run(IMarker marker) {
        this.run(new IMarker[]{marker}, null);
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        try {
            if (markers == null) {
                return new IMarker[0];
            }
            ArrayList<IMarker> similarMarkers = new ArrayList<IMarker>();
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (marker != this.marker && marker != null && "ro.amiq.vlogdt.LintingErrorMarker".equals(marker.getType())) {
                    Object markerName = marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.CheckNameAttribute");
                    Object firstSelectedMarkerName = this.marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.CheckNameAttribute");
                    if (markerName != null && firstSelectedMarkerName != null && firstSelectedMarkerName.equals(markerName)) {
                        similarMarkers.add(marker);
                    }
                }
                ++n2;
            }
            return similarMarkers.toArray(new IMarker[similarMarkers.size()]);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new IMarker[0];
        }
    }
}

