/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.DVTSplashMLT;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.UserInputAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixManager;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixResult;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;

public abstract class VerissimoAutofix {
    private OVMComplianceCheck check;
    private List<OVMComplianceCheckHit> hits;
    private VerissimoAutofixResult result;
    private Map<Integer, Object[]> testModeErrorFixes;
    private Map<IFile, Map<EditParameters, Set<OVMComplianceCheckHit>>> alreadyAddedEdits;
    private long timeSpentInGUI;

    protected VerissimoAutofix(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        this.hits = hits;
        this.check = check;
        this.result = new VerissimoAutofixResult(check);
        this.alreadyAddedEdits = new HashMap<IFile, Map<EditParameters, Set<OVMComplianceCheckHit>>>();
        this.timeSpentInGUI = 0L;
        if (this instanceof UserInputAutofix) {
            ((UserInputAutofix)this).configure(check);
        }
    }

    public void computeEdits(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        if (this.hits == null || this.hits.isEmpty()) {
            return;
        }
        Map<ParserPath, Map<Integer, List<OVMComplianceCheckHit>>> groupedHits = this.organizeHitsOnFilesAndLines(this.hits);
        Set<ParserPath> allParserPaths = groupedHits.keySet();
        DocumentManager docManager = new DocumentManager();
        try {
            docManager.activate();
            block8: for (ParserPath parserPath : allParserPaths) {
                IFile file;
                if (monitor.isCanceled()) {
                    break;
                }
                Map<Integer, List<OVMComplianceCheckHit>> hitsInFile = groupedHits.get(parserPath);
                Set<Integer> linesWithHits = hitsInFile.keySet();
                if (linesWithHits == null || linesWithHits.isEmpty() || (file = VerissimoAutofixUtils.getInstance().getFile(this.getIProject(), parserPath)) == null) continue;
                IDocument document = docManager.getDocument(parserPath, this.getIProject());
                for (Integer line : linesWithHits) {
                    if (monitor.isCanceled() || !DVTSplashMLT.INSTANCE.cc(new String[]{"F73765F6C696E74", "F73765F6C696E745F6163"})) continue block8;
                    List<OVMComplianceCheckHit> hitsOnLine = hitsInFile.get(line);
                    if (hitsOnLine == null || hitsOnLine.isEmpty()) continue;
                    this.getEditParametersForHits(hitsOnLine, file, document);
                    monitor.worked(hitsOnLine.size());
                }
            }
        }
        finally {
            docManager.deactivate();
        }
        if (monitor.isCanceled()) {
            return;
        }
        Set<IFile> affectedFiles = this.computePotentialAffectedFiles();
        try {
            this.timeSpentInGUI = System.currentTimeMillis();
            Boolean success = VerissimoAutofixManager.getInstance().validateFileModification(affectedFiles).get();
            if (!success.booleanValue()) {
                return;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        finally {
            this.timeSpentInGUI = System.currentTimeMillis() - this.timeSpentInGUI;
        }
        HashSet<IFile> stillReadOnlyFiles = new HashSet<IFile>();
        for (IFile file : affectedFiles) {
            if (file.getLocation().toFile().canWrite()) continue;
            stillReadOnlyFiles.add(file);
        }
        HashSet<IFile> readOnlyFilesEncountered = null;
        if (!stillReadOnlyFiles.isEmpty()) {
            this.removeEditsAndErrorsForFiles(stillReadOnlyFiles);
            readOnlyFilesEncountered = stillReadOnlyFiles;
        }
        this.result.setReadonlyFiles(readOnlyFilesEncountered);
    }

    protected void addEditForHit(OVMComplianceCheckHit hit, IFile file, EditParameters edit) {
        this.addEditForHit(hit, file, edit, false);
    }

    protected void addEditForHit(OVMComplianceCheckHit hit, IFile file, EditParameters edit, boolean ignoreDuplicateEdits) {
        if (edit == null) {
            return;
        }
        if (!edit.isValid(hit)) {
            return;
        }
        if (this.result == null) {
            this.result = new VerissimoAutofixResult(this.check);
        }
        if (!ignoreDuplicateEdits) {
            Set<OVMComplianceCheckHit> hitsWithSameEdit;
            Map<EditParameters, Set<OVMComplianceCheckHit>> alreadyAddedEditsForFile = this.alreadyAddedEdits.get(file);
            Set<OVMComplianceCheckHit> set = hitsWithSameEdit = alreadyAddedEditsForFile != null ? alreadyAddedEditsForFile.get(edit) : null;
            if (hitsWithSameEdit != null && !hitsWithSameEdit.contains(hit)) {
                return;
            }
        }
        edit.setLineAndLineOffset(file);
        this.result.getEdits().putIfAbsent(hit, new LinkedHashMap());
        this.result.getEdits().get(hit).putIfAbsent(file, new ArrayList());
        this.result.getEdits().get(hit).get(file).add(edit);
        this.alreadyAddedEdits.putIfAbsent(file, new HashMap());
        this.alreadyAddedEdits.get(file).putIfAbsent(edit, new HashSet());
        this.alreadyAddedEdits.get(file).get(edit).add(hit);
    }

    protected void addEditsForHit(OVMComplianceCheckHit hit, IFile file, List<EditParameters> edits) {
        this.addEditsForHit(hit, file, edits, false);
    }

    protected void addEditsForHit(OVMComplianceCheckHit hit, IFile file, List<EditParameters> edits, boolean ignoreDuplicateEdits) {
        if (edits == null || edits.isEmpty()) {
            return;
        }
        if (this.result == null) {
            this.result = new VerissimoAutofixResult(this.check);
        }
        for (EditParameters editParameters : edits) {
            this.addEditForHit(hit, file, editParameters, ignoreDuplicateEdits);
        }
    }

    protected void addError(VerissimoAutofixError error) {
        if (this.result == null) {
            this.result = new VerissimoAutofixResult(this.check);
        }
        if (error != null) {
            this.result.getErrors().add(error);
        }
    }

    public List<VerissimoAutofixError> getErrors() {
        return this.result != null ? this.result.getErrors() : null;
    }

    public VerissimoAutofixResult getResult() {
        return this.result;
    }

    public void setErrorsFixes(Map<Integer, Object[]> errorsFixes) {
        if (!TestHelper.isTestMode()) {
            return;
        }
        this.testModeErrorFixes = errorsFixes;
    }

    public Map<Integer, Object[]> getErrorsFixes() {
        if (!TestHelper.isTestMode()) {
            return null;
        }
        return this.testModeErrorFixes;
    }

    public Map<OVMComplianceCheckHit, Map<IFile, List<EditParameters>>> getEdits() {
        return this.result != null ? this.result.getEdits() : null;
    }

    public OVMComplianceCheck getCheck() {
        return this.check;
    }

    public IProject getIProject() {
        return this.check.getIProject();
    }

    public RfProject getRfProject() {
        return RfManager.getInstance().getRfProject(this.check.getIProject());
    }

    public int getNofHits() {
        return this.hits == null ? 0 : this.hits.size();
    }

    public List<OVMComplianceCheckHit> getHits() {
        return this.hits;
    }

    public long getTimeSpentInGUI() {
        return this.timeSpentInGUI;
    }

    private Map<ParserPath, Map<Integer, List<OVMComplianceCheckHit>>> organizeHitsOnFilesAndLines(List<OVMComplianceCheckHit> hits) {
        if (hits == null || hits.isEmpty()) {
            return null;
        }
        LinkedHashMap<ParserPath, Map<Integer, List<OVMComplianceCheckHit>>> hitsToFileAndLineMap = new LinkedHashMap<ParserPath, Map<Integer, List<OVMComplianceCheckHit>>>();
        for (OVMComplianceCheckHit hit : hits) {
            ParserPath parserPath = hit.getParserPath();
            hitsToFileAndLineMap.putIfAbsent(parserPath, new LinkedHashMap());
            ((Map)hitsToFileAndLineMap.get(parserPath)).putIfAbsent(hit.getLine(), new ArrayList());
            ((List)((Map)hitsToFileAndLineMap.get(parserPath)).get(hit.getLine())).add(hit);
        }
        return hitsToFileAndLineMap;
    }

    private void removeEditsAndErrorsForFiles(Set<IFile> files) {
        OVMComplianceCheckHit hit;
        if (files == null || files.isEmpty()) {
            return;
        }
        Map<OVMComplianceCheckHit, Map<IFile, List<EditParameters>>> allEditsOrganizedByHits = this.result.getEdits();
        if (allEditsOrganizedByHits != null) {
            HashSet<OVMComplianceCheckHit> toRemove = new HashSet<OVMComplianceCheckHit>();
            block0: for (Map.Entry<OVMComplianceCheckHit, Map<IFile, List<EditParameters>>> entry : allEditsOrganizedByHits.entrySet()) {
                hit = entry.getKey();
                Map<IFile, List<EditParameters>> editsByFiles = entry.getValue();
                if (editsByFiles == null || editsByFiles.keySet() == null) continue;
                for (IFile iFile : editsByFiles.keySet()) {
                    if (!files.contains(iFile)) continue;
                    toRemove.add(hit);
                    continue block0;
                }
            }
            for (OVMComplianceCheckHit hit2 : toRemove) {
                allEditsOrganizedByHits.remove(hit2);
            }
        }
        if (this.result.getErrors() != null) {
            HashSet<VerissimoAutofixError> errorToRemove = new HashSet<VerissimoAutofixError>();
            for (VerissimoAutofixError error : this.result.getErrors()) {
                hit = error.getHit();
                IFile file = VerissimoAutofixUtils.getInstance().getFile(this.getIProject(), hit.getParserPath());
                if (file == null || !files.contains(file)) continue;
                errorToRemove.add(error);
            }
            this.result.getErrors().removeAll(errorToRemove);
        }
    }

    private Set<IFile> computePotentialAffectedFiles() {
        if (this.result == null || this.result.getEdits() == null) {
            return null;
        }
        HashSet<IFile> affectedFiles = new HashSet<IFile>();
        Collection<Map<IFile, List<EditParameters>>> allEditsOrganizedByHits = this.result.getEdits().values();
        for (Map<IFile, List<EditParameters>> editsByFiles : allEditsOrganizedByHits) {
            Set<IFile> files;
            if (editsByFiles == null || (files = editsByFiles.keySet()) == null || files.isEmpty()) continue;
            affectedFiles.addAll(files);
        }
        for (VerissimoAutofixError error : this.result.getErrors()) {
            if (error.getHit() == null) continue;
            affectedFiles.add(VerissimoAutofixUtils.getInstance().getFile(this.getIProject(), error.getHit().getParserPath()));
        }
        return affectedFiles;
    }

    public boolean isValidCondition(char previousChar, char currentChar) {
        return false;
    }

    public void addEdit(OVMComplianceCheckHit hit, IFile file, int startOffset) {
    }

    protected abstract void getEditParametersForHits(List<OVMComplianceCheckHit> var1, IFile var2, IDocument var3);

    public void removeErrorsEdits() {
        List<VerissimoAutofixError> errors = this.result.getErrors();
        if (errors == null || errors.isEmpty()) {
            return;
        }
        for (VerissimoAutofixError error : errors) {
            this.result.removeEditsForHit(error.getHit());
        }
    }
}

