/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.views.InspectViewGoToInfo;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.InspectViewUpdateEventCommon;
import ro.amiq.dvt.ui.views.inspect.InspectViewComponent;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.RenameAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixResult;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public class VerissimoAutofixErrorPage
extends UserInputWizardPage {
    private static final int ADDITIONAL_HIT_INFO_MAX_LENGTH = 20;
    private VerissimoAutofix autofix;
    private int pageNumber;
    private boolean jumpToFinalPage;
    private Map<OVMComplianceCheckHit, Map<IFile, List<EditParameters>>> removedEdits;
    private Map<OVMComplianceCheckHit, EditParameters> computedComments;
    private Map<OVMComplianceCheckHit, List<EditParameters>> computedWaivers;
    private Map<VerissimoAutofixError, Boolean> selectedOptionsMap;
    private static Map<Integer, Image> imageDecorationsMap = new HashMap<Integer, Image>();

    static {
        imageDecorationsMap.put(4, FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        imageDecorationsMap.put(2, FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage());
        imageDecorationsMap.put(1, FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        imageDecorationsMap.put(0, null);
    }

    public VerissimoAutofixErrorPage(String name, VerissimoAutofix autofix, int pageNumber) {
        super(name);
        this.autofix = autofix;
        this.pageNumber = pageNumber;
        this.removedEdits = new HashMap<OVMComplianceCheckHit, Map<IFile, List<EditParameters>>>();
        this.computedComments = new HashMap<OVMComplianceCheckHit, EditParameters>();
        this.computedWaivers = new HashMap<OVMComplianceCheckHit, List<EditParameters>>();
        this.selectedOptionsMap = new HashMap<VerissimoAutofixError, Boolean>();
    }

    public void createControl(Composite parent) {
        final VerissimoAutofixResult autofixResult = this.autofix.getResult();
        final HashMap<TableItem, Composite> map = new HashMap<TableItem, Composite>();
        final Font boldFont = FontFactory.getInstance().getSWTFont(new FontData("", 10, 1));
        final Font normalFont = FontFactory.getInstance().getSWTFont(new FontData("", 10, 0));
        SashForm sashForm = new SashForm(parent, 256);
        Composite leftSide = new Composite((Composite)sashForm, 16);
        leftSide.setLayout((Layout)new GridLayout(1, false));
        leftSide.setLayoutData((Object)new GridData(4, 4, true, true));
        final Table errorsTable = new Table(leftSide, 68368);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 100;
        errorsTable.setLayoutData((Object)data);
        final Composite rightSide = new Composite((Composite)sashForm, 0);
        rightSide.setLayout((Layout)new GridLayout(1, false));
        rightSide.setLayoutData((Object)new GridData(4, 4, true, true));
        final StackLayout rightSideStackLayout = new StackLayout();
        rightSide.setLayout((Layout)rightSideStackLayout);
        List<VerissimoAutofixError> errors = this.autofix.getErrors();
        int start = this.pageNumber * 100;
        int end = (this.pageNumber + 1) * 100;
        if (end > autofixResult.getNofErrors() - 1) {
            end = autofixResult.getNofErrors();
        }
        int i = start;
        while (i < end) {
            final VerissimoAutofixError error = errors.get(i);
            final OVMComplianceCheckHit hit = error.getHit();
            final ParserPath parserPath = hit.getParserPath();
            String filePath = parserPath.path;
            final IFile file = VerissimoAutofixUtils.getInstance().getFile(this.autofix.getIProject(), parserPath);
            final IDocument document = VerissimoAutofixUtils.getInstance().getDocument(file);
            this.selectedOptionsMap.put(error, false);
            final TableItem item = new TableItem(errorsTable, 0);
            item.setFont(boldFont);
            item.setImage(imageDecorationsMap.get(4));
            if (error.getErrorType() == VerissimoAutofixErrorType.UNFIXABLE) {
                String errorText = "Failure at line " + hit.getLine() + " in file '" + LintUtils.getFileShortName(filePath) + "' can't be fixed";
                String additionalInfo = this.autofix.getCheck().getAdditionalInfoForDisplayString(hit);
                if (additionalInfo != null && !additionalInfo.isEmpty()) {
                    if (additionalInfo.length() > 20) {
                        additionalInfo = String.valueOf(additionalInfo.substring(0, 20)) + "...";
                    }
                    errorText = String.valueOf(errorText) + " - " + additionalInfo;
                }
                item.setText(errorText);
            } else if (error.getErrorType() == VerissimoAutofixErrorType.NAME_COLLISION) {
                IRfNamedElement element = error.getRefactorInfo().getElement();
                String elementTypeAndName = String.valueOf(LintUtils.getElementKind((RfNamedElement)element)) + " '" + error.getRefactorInfo().getOldName() + "'";
                String errorText = "Name collision at line " + hit.getLine() + " in file '" + LintUtils.getFileShortName(filePath) + "' - " + elementTypeAndName;
                item.setText(errorText);
            }
            Composite fixErrorComposite = new Composite(rightSide, 0);
            fixErrorComposite.setLayout((Layout)new GridLayout(2, false));
            fixErrorComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            Label description = new Label(fixErrorComposite, 0);
            GridData descriptionGD = new GridData(4, 128, true, false);
            descriptionGD.horizontalSpan = 2;
            description.setLayoutData((Object)descriptionGD);
            String descriptionText = "This failure can't be fixed automatically";
            if (error.getReason() != null && !error.getReason().isEmpty()) {
                descriptionText = String.valueOf(descriptionText) + " because " + error.getReason();
            }
            if (error.getAdditionalInformation() != null && !error.getAdditionalInformation().isEmpty()) {
                descriptionText = String.valueOf(descriptionText) + ".\n" + error.getAdditionalInformation();
            }
            descriptionText = String.valueOf(descriptionText) + ".\n";
            description.setText(descriptionText);
            InspectViewComponent inspectComponent = new InspectViewComponent(fixErrorComposite);
            GridData inspectGD = new GridData(4, 128, true, false);
            inspectGD.horizontalSpan = 2;
            inspectGD.heightHint = 200;
            inspectComponent.setLayoutData((Object)inspectGD);
            GoToInfo gotoInfo = GoToInfo.of((String)filePath, (int)-1, (int)-1, (int)hit.getLine(), (String)"", (LanguageKind)LanguageKind.VLOG);
            InspectViewGoToInfo info = new InspectViewGoToInfo(gotoInfo);
            InspectViewUpdateEvent event = new InspectViewUpdateEvent(Arrays.asList(info), this.autofix.getIProject(), LanguageKind.VLOG, InspectViewUpdateEventCommon.TYPE.AUTOFIX);
            event.setNofContextLine(5);
            Display.getDefault().asyncExec(() -> inspectComponent.update(event));
            Label options = new Label(fixErrorComposite, 0);
            GridData optionsGD = new GridData(4, 128, true, false);
            optionsGD.horizontalSpan = 2;
            options.setLayoutData((Object)optionsGD);
            options.setText("\nChoose between the following options:");
            if (error.getErrorType() == VerissimoAutofixErrorType.NAME_COLLISION && this.autofix instanceof RenameAutofix) {
                final RenameAutofix renameAutofix = (RenameAutofix)this.autofix;
                final Button renameButton = new Button(fixErrorComposite, 16);
                renameButton.setText("Rename '" + error.getRenameDelegate().getRefactorInfo().getOldName() + "'");
                final Text replaceText = new Text(fixErrorComposite, 2048);
                replaceText.setLayoutData((Object)new GridData(4, 128, true, false));
                replaceText.setEnabled(false);
                if (error.getRefactorInfo().getNewName() != null) {
                    replaceText.setText(error.getRefactorInfo().getNewName());
                } else {
                    replaceText.setText(error.getRefactorInfo().getOldName());
                }
                new Label(fixErrorComposite, 0);
                final CLabel errorLabel = new CLabel(fixErrorComposite, 0);
                errorLabel.setLayoutData((Object)new GridData(4, 128, true, false));
                IStatus status = renameAutofix.checkNewName(this.autofix, error.getRenameDelegate());
                errorLabel.setText(status.getMessage());
                errorLabel.setImage(imageDecorationsMap.get(status.getSeverity()));
                item.setFont(status.isOK() ? normalFont : boldFont);
                item.setImage(status.isOK() ? imageDecorationsMap.get(0) : imageDecorationsMap.get(4));
                renameButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (renameButton.getSelection()) {
                            VerissimoAutofixErrorPage.this.selectedOptionsMap.put(error, true);
                            replaceText.setEnabled(true);
                            IStatus status = renameAutofix.checkNewName(VerissimoAutofixErrorPage.this.autofix, error.getRenameDelegate());
                            errorLabel.setText(status.getMessage());
                            errorLabel.setImage(imageDecorationsMap.get(status.getSeverity()));
                            item.setFont(status.isOK() ? normalFont : boldFont);
                            item.setImage(status.isOK() ? imageDecorationsMap.get(0) : imageDecorationsMap.get(4));
                        } else {
                            VerissimoAutofixErrorPage.this.selectedOptionsMap.put(error, false);
                            replaceText.setEnabled(false);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                replaceText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        error.getRefactorInfo().setNewName(replaceText.getText());
                        IStatus status = renameAutofix.checkNewName(VerissimoAutofixErrorPage.this.autofix, error.getRenameDelegate());
                        errorLabel.setText(status.getMessage());
                        errorLabel.setImage(imageDecorationsMap.get(status.getSeverity()));
                        if (renameButton.getSelection()) {
                            item.setFont(status.isOK() ? normalFont : boldFont);
                            item.setImage(status.isOK() ? imageDecorationsMap.get(0) : imageDecorationsMap.get(4));
                        }
                    }
                });
            }
            final Button addCommentButton = new Button(fixErrorComposite, 16);
            addCommentButton.setText("Add comment in code");
            final Text commentText = new Text(fixErrorComposite, 2048);
            commentText.setLayoutData((Object)new GridData(4, 128, true, false));
            commentText.setText("// FIXME: This failure must be fixed manually");
            commentText.setEnabled(false);
            commentText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InsertEditParameters commentBlock = (InsertEditParameters)VerissimoAutofixErrorPage.this.computedComments.get(hit);
                    commentBlock.setInsertedString(commentText.getText());
                }
            });
            addCommentButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    IFile file = VerissimoAutofixUtils.getInstance().getFile(VerissimoAutofixErrorPage.this.autofix.getIProject(), parserPath);
                    Map<OVMComplianceCheckHit, Map<IFile, List<EditParameters>>> allEditsOrganizedByHits = autofixResult.getEdits();
                    if (addCommentButton.getSelection()) {
                        VerissimoAutofixErrorPage.this.selectedOptionsMap.put(error, true);
                        commentText.setEnabled(true);
                        item.setFont(normalFont);
                        item.setImage(imageDecorationsMap.get(0));
                        VerissimoAutofixErrorPage.this.removeAndSaveEditsForHit(hit);
                        allEditsOrganizedByHits.putIfAbsent(hit, new HashMap());
                        allEditsOrganizedByHits.get(hit).putIfAbsent(file, new ArrayList());
                        EditParameters commentEditParameters = VerissimoAutofixErrorPage.this.computedComments.get(hit);
                        if (commentEditParameters == null && (commentEditParameters = VerissimoAutofixUtils.getInstance().addCommentForAutocorrectError(VerissimoAutofixErrorPage.this.autofix, hit, document, commentText.getText())) != null) {
                            VerissimoAutofixErrorPage.this.computedComments.put(hit, commentEditParameters);
                        }
                        if (commentEditParameters != null) {
                            allEditsOrganizedByHits.get(hit).get(file).add(commentEditParameters);
                        }
                    } else {
                        VerissimoAutofixErrorPage.this.selectedOptionsMap.put(error, false);
                        commentText.setEnabled(false);
                        EditParameters commentEditParameters = VerissimoAutofixErrorPage.this.computedComments.get(hit);
                        allEditsOrganizedByHits.get(hit).get(file).remove(commentEditParameters);
                        VerissimoAutofixErrorPage.this.restoreEditsForHit(hit);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            final Button addWaiverButton = new Button(fixErrorComposite, 16);
            GridData addWaiverGD = new GridData(4, 128, true, false);
            addWaiverGD.horizontalSpan = 2;
            addWaiverButton.setLayoutData((Object)addWaiverGD);
            addWaiverButton.setText("Add waiver for failure");
            addWaiverButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (addWaiverButton.getSelection()) {
                        VerissimoAutofixErrorPage.this.selectedOptionsMap.put(error, true);
                        item.setFont(normalFont);
                        item.setImage(imageDecorationsMap.get(0));
                        VerissimoAutofixErrorPage.this.removeAndSaveEditsForHit(hit);
                        if (VerissimoAutofixErrorPage.this.computedWaivers.containsKey(hit)) {
                            VerissimoAutofixUtils.getInstance().addEditsForWaivers(VerissimoAutofixErrorPage.this.autofix, hit, file, VerissimoAutofixErrorPage.this.computedWaivers.get(hit));
                        } else {
                            try {
                                VerissimoAutofixUtils.getInstance().addInlineWaiverForAutocorrectError(VerissimoAutofixErrorPage.this.autofix, error, hit, file, document, VerissimoAutofixErrorPage.this.computedWaivers);
                            }
                            catch (Exception e1) {
                                DVTLogger.INSTANCE.logError((Throwable)e1);
                            }
                        }
                    } else {
                        VerissimoAutofixErrorPage.this.selectedOptionsMap.put(error, false);
                        List<EditParameters> waiversForHit = VerissimoAutofixErrorPage.this.computedWaivers.get(error.getHit());
                        for (EditParameters currentWaiver : waiversForHit) {
                            autofixResult.getEdits().get(error.getHit()).get(file).remove(currentWaiver);
                        }
                        VerissimoAutofixErrorPage.this.restoreEditsForHit(hit);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            final Button skipButton = new Button(fixErrorComposite, 16);
            GridData skipGD = new GridData(4, 128, true, false);
            skipGD.horizontalSpan = 2;
            skipButton.setLayoutData((Object)skipGD);
            skipButton.setText("Skip");
            skipButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (skipButton.getSelection()) {
                        VerissimoAutofixErrorPage.this.selectedOptionsMap.put(error, true);
                        item.setFont(normalFont);
                        item.setImage(imageDecorationsMap.get(0));
                        VerissimoAutofixErrorPage.this.removeAndSaveEditsForHit(hit);
                    } else {
                        VerissimoAutofixErrorPage.this.selectedOptionsMap.put(error, false);
                        VerissimoAutofixErrorPage.this.restoreEditsForHit(hit);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            map.put(item, fixErrorComposite);
            ++i;
        }
        if (autofixResult.getNofErrors() > 100) {
            Label pageNumberDescription = new Label(leftSide, 0);
            GridData pageNumberdescriptionGD = new GridData(4, 128, true, false);
            pageNumberdescriptionGD.horizontalSpan = 2;
            pageNumberDescription.setLayoutData((Object)pageNumberdescriptionGD);
            pageNumberDescription.setText("Error Page " + (this.pageNumber + 1) + "/" + ((autofixResult.getNofErrors() - 1) / 100 + 1));
        }
        if (!this.isLastErrorPage()) {
            final Button finalPageButton = new Button(leftSide, 32);
            GridData finalPageDG = new GridData(4, 128, true, false);
            finalPageDG.horizontalSpan = 2;
            finalPageButton.setLayoutData((Object)finalPageDG);
            finalPageButton.setText("Jump to last error page");
            finalPageButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    VerissimoAutofixErrorPage.this.jumpToFinalPage = finalPageButton.getSelection();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        errorsTable.setSelection(0);
        TableItem firstItem = errorsTable.getItem(0);
        rightSideStackLayout.topControl = (Control)map.get(firstItem);
        errorsTable.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableItem[] selection = errorsTable.getSelection();
                if (selection.length > 1) {
                    return;
                }
                rightSideStackLayout.topControl = (Control)map.get(selection[0]);
                rightSide.layout();
            }
        });
        leftSide.pack();
        this.setControl((Control)sashForm);
    }

    private void removeAndSaveEditsForHit(OVMComplianceCheckHit hit) {
        if (hit == null) {
            return;
        }
        Map<IFile, List<EditParameters>> editsForHit = this.autofix.getEdits().get(hit);
        if (editsForHit == null || editsForHit.isEmpty()) {
            return;
        }
        this.removedEdits.put(hit, editsForHit);
        this.autofix.getEdits().remove(hit);
    }

    private void restoreEditsForHit(OVMComplianceCheckHit hit) {
        if (hit == null || !this.removedEdits.containsKey(hit)) {
            return;
        }
        Map<IFile, List<EditParameters>> hitEdits = this.removedEdits.get(hit);
        this.autofix.getEdits().put(hit, hitEdits);
    }

    public IWizardPage getNextPage() {
        if (TestHelper.isTestMode()) {
            this.setErrorsFixesInTestMode();
            return super.getNextPage();
        }
        boolean errorsWithoutSelectedOptions = false;
        for (Map.Entry<VerissimoAutofixError, Boolean> entry : this.selectedOptionsMap.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            this.removeAndSaveEditsForHit(entry.getKey().getHit());
            errorsWithoutSelectedOptions = true;
        }
        if (errorsWithoutSelectedOptions && this.isLastErrorPage()) {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Fix " + this.autofix.getCheck().getName() + " Failures", null, "All failures without a manually selected resolution will be skipped.", 4, new String[]{"OK"}, 0);
            dialog.open();
        }
        if (this.jumpToFinalPage && !this.isLastErrorPage()) {
            IWizardPage[] pages = super.getWizard().getPages();
            return pages[pages.length - 3];
        }
        return super.getNextPage();
    }

    private void setErrorsFixesInTestMode() {
        if (!TestHelper.isTestMode()) {
            return;
        }
        Map<Integer, Object[]> errorFixes = this.autofix.getErrorsFixes();
        for (VerissimoAutofixError error : this.autofix.getErrors()) {
            String comment;
            this.selectedOptionsMap.put(error, true);
            int errorLine = error.getHit().getLine();
            String fix = null;
            if (errorFixes != null && errorFixes.containsKey(errorLine)) {
                fix = (String)errorFixes.get(errorLine)[0];
            }
            OVMComplianceCheckHit hit = error.getHit();
            IFile file = VerissimoAutofixUtils.getInstance().getFile(this.autofix.getIProject(), hit.getParserPath());
            IDocument document = VerissimoAutofixUtils.getInstance().getDocument(file);
            Map<OVMComplianceCheckHit, Map<IFile, List<EditParameters>>> allEditsOrganizedByHits = this.autofix.getEdits();
            if (fix == null || "skip".equals(fix)) {
                this.removeAndSaveEditsForHit(hit);
                continue;
            }
            if ("waiver".equals(fix)) {
                this.removeAndSaveEditsForHit(hit);
                try {
                    int insertionOffset = document.getLineOffset(hit.getLine() - 1) + document.getLineLength(hit.getLine() - 1);
                    if (hit.getLine() < document.getNumberOfLines()) {
                        --insertionOffset;
                    }
                    String indentation = DVTDocumentUtils.getIndent((int)insertionOffset, (IDocument)document);
                    ITypedRegion region = ((IDocumentExtension3)document).getPartition("__vlog_partitioning", insertionOffset, false);
                    String waiverSuffix = String.valueOf(this.autofix.getCheck().getName()) + "@" + LintUtils.getFileShortName(hit.getParserPath().path) + "-" + hit.getLine() + "\" DISABLE " + this.autofix.getCheck().getName();
                    String regionType = region.getType();
                    if ("__vlog_sl_comment".equals(regionType) || "__vlog_ml_comment".equals(regionType)) {
                        InsertEditParameters startWaiver = new InsertEditParameters(this.autofix, document.getLineOffset(hit.getLine() - 1), "// @DVT_LINTER_WAIVER_START \"" + waiverSuffix, indentation, "\n");
                        InsertEditParameters endWaiver = new InsertEditParameters(this.autofix, region.getOffset() + region.getLength(), "// @DVT_LINTER_WAIVER_END \"" + waiverSuffix, indentation, "\n");
                        VerissimoAutofixUtils.getInstance().addEditsForWaivers(this.autofix, hit, file, Arrays.asList(startWaiver, endWaiver));
                        continue;
                    }
                    InsertEditParameters waiver = new InsertEditParameters(this.autofix, insertionOffset, "// @DVT_LINTER_WAIVER \"" + waiverSuffix, " ", "");
                    VerissimoAutofixUtils.getInstance().addEditsForWaivers(this.autofix, hit, file, Arrays.asList(waiver));
                }
                catch (Exception e1) {
                    DVTLogger.INSTANCE.logError((Throwable)e1);
                }
                continue;
            }
            if (!"comment".equals(fix) || errorFixes == null || errorFixes.get(errorLine) == null || errorFixes.get(errorLine).length < 2 || (comment = (String)errorFixes.get(errorLine)[1]) == null || comment.isEmpty()) continue;
            this.removeAndSaveEditsForHit(hit);
            allEditsOrganizedByHits.putIfAbsent(hit, new HashMap());
            allEditsOrganizedByHits.get(hit).putIfAbsent(file, new ArrayList());
            InsertEditParameters commentEditParameters = null;
            try {
                int offset = document.getLineOffset(hit.getLine() - 1);
                String indent = DVTDocumentUtils.getIndent((int)offset, (IDocument)document);
                commentEditParameters = new InsertEditParameters(this.autofix, offset, comment, indent, "\n");
            }
            catch (BadLocationException e1) {
                DVTLogger.INSTANCE.logError((Throwable)e1);
            }
            if (commentEditParameters == null) continue;
            allEditsOrganizedByHits.get(hit).get(file).add(commentEditParameters);
        }
    }

    private boolean isLastErrorPage() {
        int totalNofPages = (this.autofix.getResult().getNofErrors() - 1) / 100;
        return this.pageNumber == totalNofPages;
    }
}

