/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.commands.ICommandService;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.DVTSplashMLT;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemComparator;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.DVTProblemMatcher;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.RenameRefactorAction;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixTestUtil;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.SingleFileLintingBuilder;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixManagerCommon;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixProcessor;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixResult;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixTestHelper;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixWizard;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.linter.ui.OVMComplianceReport;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public class VerissimoAutofixManager
extends VerissimoAutofixManagerCommon {
    private static VerissimoAutofixManager fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VerissimoAutofixManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new VerissimoAutofixManager();
            }
        }
        return fInstance;
    }

    @Override
    protected ProgressMonitorDialog getProgressMonitorDialog() {
        return new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
    }

    @Override
    protected boolean sourceCodeChanged(IProject project) {
        OVMComplianceReport report = VerissimoAutofixUtils.getInstance().getOVMComplianceReport(project);
        if (report == null || !report.checkIfSourceCodeChanged()) {
            return false;
        }
        VerissimoAutofixUtils.getInstance().showErrorDialog("Fix Failures", "Source code changed since Verissimo analyzed it.\nPlease save all files and reapply the checks before using auto-correct.", new String[]{"OK"});
        return true;
    }

    @Override
    protected void computeAutofixResult(ProgressMonitorDialog progressDialog, final VerissimoAutofix autofix) {
        try {
            progressDialog.run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(null){

                protected void execute(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask("Computing fixes", autofix.getNofHits());
                        autofix.computeEdits(monitor);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
    }

    @Override
    protected boolean autofixCancelled(ProgressMonitorDialog progressDialog) {
        IProgressMonitor monitor = progressDialog.getProgressMonitor();
        if (monitor != null && monitor.isCanceled()) {
            VerissimoAutofixUtils.getInstance().showInfoDialog("Fix Failures", "The operation of fixing failures was cancelled.", new String[]{"OK"});
            return true;
        }
        return false;
    }

    @Override
    protected void showNoOtherFixesDialog() {
        VerissimoAutofixUtils.getInstance().showInfoDialog("Fix Failures", "After excluding the read-only files, there are no fixes that can be applied.", new String[]{"OK"});
    }

    @Override
    protected CompletableFuture<Boolean> validateFileModification(Set<IFile> files) {
        Display.getDefault().syncExec(() -> {
            try {
                DVTFileModificationValidator.validateEdit(null, (IFile[])files.toArray(new IFile[files.size()]), (boolean)false);
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
        return CompletableFuture.completedFuture(true);
    }

    @Override
    protected int applyAutofixes(VerissimoAutofix autofix, int hiddenFixesCount, Set<IFile> affectedFiles) {
        RefactoringWizardOpenOperation op;
        block5: {
            this.oldFileContent.clear();
            if (affectedFiles != null) {
                for (IFile file : affectedFiles) {
                    IDocument doc = VerissimoAutofixUtils.getInstance().getDocument(file);
                    this.oldFileContent.put(file, doc.get());
                }
            }
            try {
                VerissimoAutofixProcessor processor = new VerissimoAutofixProcessor(autofix);
                ProcessorBasedRefactoring refactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
                VerissimoAutofixWizard wizard = new VerissimoAutofixWizard((Refactoring)refactoring, autofix, hiddenFixesCount);
                op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                if (!TestHelper.isTestMode()) break block5;
                Runnable r = () -> {
                    try {
                        op.run(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "");
                    }
                    catch (InterruptedException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                };
                VerissimoAutofixTestHelper.runAutofixThread((RefactoringWizard)wizard, r);
                return 0;
            }
            catch (InterruptedException irex) {
                DVTLogger.INSTANCE.logError((Throwable)irex);
                return 1;
            }
        }
        return op.run(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "");
    }

    private Map<IFile, IDocument> computeOutOfSyncAffectedDirtyDocuments(IProject currentProject, Set<IFile> affectedFiles) {
        if (currentProject == null || affectedFiles == null || affectedFiles.isEmpty()) {
            return null;
        }
        IWorkbench workbench = DVTPlugin.getDefault().getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows == null || windows.length == 0) {
            return null;
        }
        return RenameRefactorAction.computeOutOfSyncAffectedDirtyDocuments((IProject)currentProject, affectedFiles, (IWorkbenchWindow[])windows);
    }

    @Override
    protected boolean refreshProject(VerissimoAutofixResult result, OVMProject ovmProject, OVMComplianceCheck check) {
        Collection problemsAfterRefresh;
        DVTProblem errorResult;
        long startTime = System.currentTimeMillis();
        Set<IFile> affectedFiles = result.getAffectedFiles();
        Set<IFile> refreshFiles = result.getRefreshFiles();
        Collection problemsBeforeRefresh = DVTProblemManager.getInstance().getAllProblems(ovmProject.getProject(), DVTProblemMatcher.all().setSeverity(Severity.ERROR), DVTProblemComparator.PROBLEM_COMPARATOR);
        this.refreshFiles(refreshFiles, affectedFiles, ovmProject);
        if (!check.isAutoCorrectSkipSanityChecks() && (errorResult = this.checkAutofixResult(affectedFiles, problemsBeforeRefresh, problemsAfterRefresh = DVTProblemManager.getInstance().getAllProblems(ovmProject.getProject(), DVTProblemMatcher.all().setSeverity(Severity.ERROR), DVTProblemComparator.PROBLEM_COMPARATOR))) != null) {
            this.undoRefactoring(ovmProject);
            if (!TestHelper.isTestMode()) {
                VerissimoAutofixUtils.getInstance().showErrorDialog("Error", "The operation of fixing failures failed" + this.getErrorMessage(errorResult), new String[]{"OK"});
            }
            this.waitForBuildDone();
            return false;
        }
        check.setFixingTime(System.currentTimeMillis() - startTime + check.getFixingTime());
        this.updateProjectAndLintOnRefresh(ovmProject, false, false);
        this.oldFileContent.clear();
        return true;
    }

    public void refreshFiles(Set<IFile> refreshFiles, Set<IFile> affectedFiles, OVMProject ovmProject) {
        if (refreshFiles != null && !refreshFiles.isEmpty()) {
            for (IFile file : refreshFiles) {
                try {
                    file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
        if (affectedFiles == null) {
            return;
        }
        Map<IFile, IDocument> outOfSyncFilesMap = this.computeOutOfSyncAffectedDirtyDocuments(ovmProject.getProject(), affectedFiles);
        if (affectedFiles.size() != (outOfSyncFilesMap == null ? 0 : outOfSyncFilesMap.size())) {
            this.waitForBuildDone();
        }
        RenameRefactorAction.scheduleReparseForModifiedFiles(outOfSyncFilesMap, null, (boolean)true);
    }

    public void updateProjectAndLintOnRefresh(OVMProject ovmProject, boolean shouldRerunAllChecks, boolean isAfterAIAutocorrect) {
        if (ovmProject.lintProject()) {
            OVMComplianceReport report = VerissimoAutofixUtils.getInstance().getOVMComplianceReport(ovmProject.getProject());
            if (report == null) {
                return;
            }
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                try {
                    ovmProject.initialize(RfManager.getInstance().getRfProject(report.getProject()), false, false);
                    report.doReapply(false, shouldRerunAllChecks ? ovmProject.getChecks() : VerissimoAutofixUtils.getInstance().getAllAutofixableChecks(ovmProject), false, !isAfterAIAutocorrect);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            });
        } else {
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                try {
                    ovmProject.initialize(RfManager.getInstance().getRfProject(ovmProject.getProject()), false, false);
                    SingleFileLintingBuilder.getInstance().startSingleFileIncrementalAndLinting(ovmProject.getProject(), !isAfterAIAutocorrect);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            });
        }
    }

    protected void waitForBuildDone() {
        final AtomicBoolean buildDone = new AtomicBoolean(false);
        DVTMixedLangModelManager.getInstance().addBuildDoneListener(new IBuildDoneListener(){

            public void buildDone(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
                DVTMixedLangModelManager.getInstance().removeBuildDoneListener((IBuildDoneListener)this);
                buildDone.set(true);
            }
        });
        while (!buildDone.get()) {
            if (Display.getDefault().readAndDispatch()) continue;
            Display.getDefault().sleep();
        }
    }

    private void undoRefactoring(OVMProject ovmProject) {
        IWorkbenchWindow activeWorkbenchWindow = Utils.getActiveWorkbenchWindow();
        ICommandService commandService = (ICommandService)activeWorkbenchWindow.getService(ICommandService.class);
        if (commandService == null) {
            return;
        }
        Command undoCommand = commandService.getCommand("org.eclipse.ui.edit.undo");
        if (undoCommand == null) {
            return;
        }
        if (!undoCommand.isEnabled()) {
            DVTPlugin.getSelectionManager().selectAndReveal((IResource)ovmProject.getProject(), activeWorkbenchWindow);
        }
        try {
            undoCommand.executeWithChecks(new ExecutionEvent());
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    @Override
    protected void addTextEditChangeGroupInPreviewPanel(VlogTextFileChange textFileChange, IFile file) {
        try {
            if (textFileChange == null || textFileChange.getEdit() == null || !(textFileChange.getEdit() instanceof MultiTextEdit)) {
                return;
            }
            MultiTextEdit edit = (MultiTextEdit)textFileChange.getEdit();
            TextEdit[] children = edit.getChildren();
            if (children == null || children.length == 0) {
                return;
            }
            IDocument document = VerissimoAutofixUtils.getInstance().getDocument(file);
            if (document == null) {
                return;
            }
            TextEdit[] textEditArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit childEdit = textEditArray[n2];
                int line = document.getLineOfOffset(childEdit.getOffset()) + 1;
                CategorizedTextEditGroup group = new CategorizedTextEditGroup("Line " + line, childEdit, GroupCategorySet.NONE);
                TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)textFileChange, (TextEditGroup)group);
                textFileChange.addTextEditChangeGroup(textEditChangeGroup);
                ++n2;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void performAutofixesInTestMode(VerissimoAutofix autofix, OVMProject ovmProject, HashMap<Integer, Object[]> errorsFixes) {
        if (!TestHelper.isTestMode()) {
            return;
        }
        autofix.setErrorsFixes(errorsFixes);
        this.performAutofix(autofix, false, ovmProject);
    }

    @Override
    protected Map<IFile, IDocument> computeOutOfSyncFilesMap(Set<IFile> affectedFiles, RfProject currentRfProject) {
        return this.computeOutOfSyncFilesMapGUISpecific(affectedFiles, currentRfProject);
    }

    @Override
    protected boolean ensureFilesInSync(final Map<IFile, IDocument> unsavedFilesMap) {
        if (unsavedFilesMap == null || unsavedFilesMap.isEmpty()) {
            return true;
        }
        int[] messageDialogExitCode = this.getMessageDialogUserOption(unsavedFilesMap);
        if (messageDialogExitCode[0] != 0) {
            return false;
        }
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            progressDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        for (IFile file : unsavedFilesMap.keySet()) {
                            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return !progressDialog.getProgressMonitor().isCanceled();
    }

    private int[] getMessageDialogUserOption(Map<IFile, IDocument> unsavedFilesMap) {
        int[] messageDialogExitCode = new int[]{0};
        if (TestHelper.isTestMode()) {
            return messageDialogExitCode;
        }
        List<String> filesFullPathList = unsavedFilesMap.keySet().stream().map(iFile -> iFile.getLocation().toOSString()).collect(Collectors.toList());
        Collections.sort(filesFullPathList);
        final String[] filesFullPathArray = filesFullPathList.toArray(new String[filesFullPathList.size()]);
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Database out of sync", null, "The following files need to be refreshed before applying the auto-correct.\nDo you want to proceed?", 2, new String[]{"Yes", "No"}, 0){

                protected Control createCustomArea(Composite parent) {
                    org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, 2560);
                    list.setItems(filesFullPathArray);
                    GridData gridData = new GridData(4, 4, true, true);
                    gridData.heightHint = 150;
                    list.setLayoutData((Object)gridData);
                    return list;
                }
            };
            nArray[0] = dialog.open();
        });
        return messageDialogExitCode;
    }

    @Override
    protected boolean showDirtyDialog(OVMComplianceCheck check, OVMProject ovmProject) {
        int[] messageDialogExitCode = new int[]{0};
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Autocorrect unavailable", null, "Autocorrect is not available after importing the HTML report, you need to reapply the " + (check == null ? "checks" : "check " + check.getName()) + ".\n" + "Do you want to run " + (check == null ? "them" : "it ") + " now?", 2, new String[]{"Yes", "No"}, 0){};
            nArray[0] = dialog.open();
        });
        if (messageDialogExitCode[0] != 0) {
            return false;
        }
        OVMComplianceReport report = VerissimoAutofixUtils.getInstance().getOVMComplianceReport(ovmProject.getProject());
        if (report == null) {
            return false;
        }
        ovmProject.initialize(RfManager.getInstance().getRfProject(report.getProject()), false, false);
        OVMComplianceCheck target = check == null ? VerissimoAutofixUtils.getInstance().getAllAutofixableChecks(ovmProject) : check;
        report.doReapply(false, target);
        return true;
    }

    @Override
    protected void showNoHitsErrorDialog() {
        VerissimoAutofixUtils.getInstance().showErrorDialog("Error", "After reapplying the check Verissimo could not find any failures!", new String[]{"OK"});
    }

    @Override
    public boolean checkOutLicense() {
        return DVTSplashMLT.INSTANCE.cc(true, new String[]{"F73765F6C696E74", "F73765F6C696E745F6163"});
    }

    @Override
    public void checkInLicense() {
        DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E745F6163");
        DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
    }

    public Set<String> getAutocorrectedFiles() {
        return new LinkedHashSet<String>();
    }

    @Override
    protected void testPressOkButton() {
        DVTQuickFixTestUtil.testPressWizardOkButton((String)"Autocorrect input", (String)"OK", (int)2000);
    }
}

