/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.ISourceProblem;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.ProgressPrinter;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.UserInputAutofixBeforeEdits;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixFactory;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixResult;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.linter.ui.VerissimoDiffer;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogProblem;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public abstract class VerissimoAutofixManagerCommon {
    protected static final String MD5_STRING = "MD5";
    protected static final String FIX_FAILURES = "Fix Failures";
    protected static final String OPERATION_CANCELLED = "The operation of fixing failures was cancelled.";
    protected static final String NO_EDITS_AFTER_EXCLUDING_READ_ONLY_FILES = "After excluding the read-only files, there are no fixes that can be applied.";
    protected static final String SOURCE_CODE_CHANGED = "Source code changed since Verissimo analyzed it.\nPlease save all files and reapply the checks before using auto-correct.";
    protected static final String AUTOCORRECT_FAILED_COMPILATION = "The operation of fixing failures failed";
    protected static final String OK = "OK";
    private Map<IFile, String> canonicalPathsCache = new HashMap<IFile, String>();
    protected Map<IFile, String> oldFileContent = new HashMap<IFile, String>();
    protected Comparator<EditParameters> editsComparator = (edit1, edit2) -> edit2.getPriority() - edit1.getPriority();

    public void fixCheckFailures(OVMComplianceCheck check, boolean isBatch, OVMProject ovmProject) {
        if (check == null || check.hasConfigurationErrors()) {
            return;
        }
        this.fixFailures(check, check.getAllAutoCorrectabledHits(), isBatch, ovmProject, true);
    }

    public void fixFailures(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits, boolean isBatch, OVMProject ovmProject, boolean appliedOnCheck) {
        if (ovmProject.isDirty(check.getName())) {
            boolean returnValue = this.showDirtyDialog(check, ovmProject);
            if (!returnValue) {
                return;
            }
            ArrayList<OVMComplianceCheckHit> allHits = check.getAllAutoCorrectabledHits();
            if (!appliedOnCheck) {
                ArrayList<OVMComplianceCheckHit> newHits = new ArrayList<OVMComplianceCheckHit>();
                for (OVMComplianceCheckHit hit : allHits) {
                    if (!Arrays.stream(hits.toArray()).anyMatch(x -> hit.getSignature().equals(((OVMComplianceCheckHit)x).getSignature()))) continue;
                    newHits.add(hit);
                }
                hits = newHits;
                if (hits.isEmpty()) {
                    this.showNoHitsErrorDialog();
                    return;
                }
            } else {
                hits = allHits;
            }
        }
        if (hits == null || hits.isEmpty()) {
            return;
        }
        if (this.sourceCodeChanged(ovmProject.getProject())) {
            return;
        }
        if (!this.checkOutLicense()) {
            return;
        }
        try {
            VerissimoAutofix autofix = VerissimoAutofixFactory.INSTANCE.createAutofix(check, hits, false);
            this.performAutofix(autofix, isBatch, ovmProject);
        }
        finally {
            if (!isBatch) {
                this.checkInLicense();
            }
        }
    }

    protected void performAutofix(VerissimoAutofix autofix, boolean isBatch, OVMProject ovmProject) {
        boolean noOtherEdits;
        if (autofix == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        long timeSpentInGUI = 0L;
        long dialogStartTime = 0L;
        String message = "Fixing " + autofix.getCheck().getName();
        if (isBatch) {
            ProgressPrinter.INSTANCE.printProgress(autofix.getIProject(), message, false);
        }
        ProgressMonitorDialog progressDialog = this.getProgressMonitorDialog();
        if (autofix instanceof UserInputAutofixBeforeEdits) {
            dialogStartTime = System.currentTimeMillis();
            if (TestHelper.isTestMode()) {
                this.testPressOkButton();
            }
            CompletableFuture<Boolean> displayInputDialog = ((UserInputAutofixBeforeEdits)autofix).displayInputDialog(autofix);
            try {
                Boolean dialogSuccess = displayInputDialog.get();
                if (!dialogSuccess.booleanValue()) {
                    return;
                }
                timeSpentInGUI += System.currentTimeMillis() - dialogStartTime;
            }
            catch (InterruptedException | ExecutionException exception) {
                return;
            }
        }
        this.computeAutofixResult(progressDialog, autofix);
        if (this.autofixCancelled(progressDialog)) {
            return;
        }
        VerissimoAutofixResult result = autofix.getResult();
        timeSpentInGUI += autofix.getTimeSpentInGUI();
        Set<IFile> affectedFiles = result.getAffectedFiles();
        Map<IFile, IDocument> outOfSyncFilesMap = this.computeOutOfSyncFilesMap(affectedFiles, ovmProject.getRfProject());
        dialogStartTime = System.currentTimeMillis();
        if (!this.ensureFilesInSync(outOfSyncFilesMap)) {
            return;
        }
        timeSpentInGUI += System.currentTimeMillis() - dialogStartTime;
        boolean noAffectedFiles = affectedFiles == null || affectedFiles.isEmpty();
        boolean noReadonlyFiles = result.getReadonlyFiles() == null || result.getReadonlyFiles().isEmpty();
        boolean bl = noOtherEdits = noAffectedFiles && !noReadonlyFiles && result.getTotalNofEdits() == 0 && result.getNofErrors() == 0;
        if (noOtherEdits) {
            if (isBatch) {
                long fixingTime = System.currentTimeMillis() - startTime;
                ProgressPrinter.INSTANCE.printProgress(autofix.getIProject(), LintUtils.createRunTimeMessage(fixingTime, message.length(), true), false);
                ProgressPrinter.INSTANCE.printProgress(autofix.getIProject(), "After excluding the read-only files, there are no fixes that can be applied.\n", false);
                autofix.getCheck().setFixingTime(fixingTime);
                return;
            }
            this.showNoOtherFixesDialog();
            return;
        }
        this.applyFixesAndRefresh(autofix, isBatch, ovmProject, startTime, timeSpentInGUI, message, result);
    }

    protected void applyFixesAndRefresh(VerissimoAutofix autofix, boolean isBatch, OVMProject ovmProject, long startTime, long timeSpentInGUI, String message, VerissimoAutofixResult result) {
        int hiddenFixes = this.getHiddenFixesCount(autofix);
        long fixingTime = System.currentTimeMillis() - startTime - timeSpentInGUI;
        int returnCode = this.applyAutofixes(autofix, hiddenFixes, result.getAffectedFiles());
        if (returnCode != 0) {
            return;
        }
        if (!isBatch) {
            autofix.getCheck().setFixingTime(fixingTime += autofix.getCheck().getFixingTime());
        }
        this.setFixableHits(result.getEdits(), true);
        ovmProject.addAutofixResult(result);
        boolean refreshResult = this.refreshProject(result, ovmProject, autofix.getCheck());
        if (isBatch) {
            fixingTime = System.currentTimeMillis() - startTime;
            autofix.getCheck().setFixingTime(fixingTime);
            ProgressPrinter.INSTANCE.printProgress(autofix.getIProject(), LintUtils.createRunTimeMessage(fixingTime, message.length(), true), false);
            this.displayReadOnlyFilesEncountered(result.getReadonlyFiles());
        }
        if (!refreshResult) {
            this.setFixableHits(result.getEdits(), false);
            ovmProject.removeAutofixResult(result);
            return;
        }
    }

    protected void displayReadOnlyFilesEncountered(Set<IFile> readOnlyFiles) {
        if (readOnlyFiles == null || readOnlyFiles.isEmpty()) {
            return;
        }
        StringBuilder readonlyFilesMessage = new StringBuilder();
        readonlyFilesMessage.append("Fixes that should have changed the following read-only files were not applied:");
        for (IFile iFile : readOnlyFiles) {
            readonlyFilesMessage.append("\n").append(iFile.getLocation().toOSString());
        }
        readonlyFilesMessage.append("\n");
        ProgressPrinter.INSTANCE.printProgress(RfMixedLangManager.getInstance().getProject(), readonlyFilesMessage.toString(), false);
    }

    protected void setFixableHits(Map<OVMComplianceCheckHit, Map<IFile, List<EditParameters>>> edits, boolean setValue) {
        if (edits == null) {
            return;
        }
        Set<OVMComplianceCheckHit> hits = edits.keySet();
        if (hits == null) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            hit.setFixed(setValue);
        }
    }

    public Map<IResource, VlogTextFileChange> createChanges(VerissimoAutofixResult result) {
        Map<OVMComplianceCheckHit, Map<IFile, List<EditParameters>>> allEditsOrganizedByHits = result.getEdits();
        if (allEditsOrganizedByHits == null || allEditsOrganizedByHits.isEmpty()) {
            return null;
        }
        EditsResult editResult = this.organizeEditsByFile(allEditsOrganizedByHits);
        result.setRefreshFiles(editResult.getRefreshFiles());
        return this.createChangesFromEditsOrganizedByFile(editResult);
    }

    public Map<IResource, VlogTextFileChange> createChangesFromEditsOrganizedByFile(EditsResult editResult) {
        Map<IFile, List<EditParameters>> allEditsByFile = editResult.getEditsByFile();
        Set<IFile> files = allEditsByFile.keySet();
        if (files == null) {
            return null;
        }
        HashMap<IResource, VlogTextFileChange> fileChangesMap = new HashMap<IResource, VlogTextFileChange>();
        HashMap textEditsOrganizedByFiles = new HashMap();
        for (IFile file : files) {
            List<EditParameters> editsInFile = allEditsByFile.get(file);
            if (editsInFile == null || editsInFile.isEmpty()) continue;
            VlogTextFileChange textFileChange = (VlogTextFileChange)((Object)fileChangesMap.get(file));
            if (textFileChange == null) {
                textFileChange = new VlogTextFileChange(file.getName(), file);
                textFileChange.setEdit((TextEdit)new MultiTextEdit());
                fileChangesMap.put((IResource)file, textFileChange);
            }
            Collections.sort(editsInFile, this.editsComparator);
            for (EditParameters editParameters : editsInFile) {
                TextEdit textEdit = VerissimoAutofixEditsUtils.INSTANCE.getTextEdit(editParameters);
                if (textEdit == null) continue;
                TextEdit conflictingEdit = VerissimoAutofixEditsUtils.INSTANCE.getConflictingTextEdit(textEdit, (List)textEditsOrganizedByFiles.get(file));
                if (conflictingEdit == null) {
                    textFileChange.addEdit(textEdit, (IRegion)new Region(0, textEdit.getLength()));
                    textEditsOrganizedByFiles.putIfAbsent(file, new ArrayList());
                    ((List)textEditsOrganizedByFiles.get(file)).add(textEdit);
                    continue;
                }
                if (!VerissimoAutofixEditsUtils.INSTANCE.checkIfidenticalEdits(textEdit, conflictingEdit)) continue;
            }
            this.addTextEditChangeGroupInPreviewPanel(textFileChange, file);
        }
        return fileChangesMap;
    }

    private EditsResult organizeEditsByFile(Map<OVMComplianceCheckHit, Map<IFile, List<EditParameters>>> allEditsOrganizedByHits) {
        if (allEditsOrganizedByHits == null || allEditsOrganizedByHits.isEmpty()) {
            return null;
        }
        HashMap<IFile, List<EditParameters>> editsByFile = new HashMap<IFile, List<EditParameters>>();
        Set<OVMComplianceCheckHit> allHits = allEditsOrganizedByHits.keySet();
        for (OVMComplianceCheckHit hit : allHits) {
            Set<IFile> files;
            Map<IFile, List<EditParameters>> editsForHit = allEditsOrganizedByHits.get(hit);
            if (editsForHit == null || (files = editsForHit.keySet()) == null) continue;
            for (IFile file : files) {
                List<EditParameters> edits = editsForHit.get(file);
                if (edits == null || edits.isEmpty()) continue;
                editsByFile.putIfAbsent(file, new ArrayList());
                ((List)editsByFile.get(file)).addAll(edits);
            }
        }
        Set<IFile> refreshFiles = this.calculateFilesToRefresh(editsByFile);
        return new EditsResult(refreshFiles, editsByFile);
    }

    protected Set<IFile> calculateFilesToRefresh(Map<IFile, List<EditParameters>> editsByFile) {
        HashSet<String> canonicalPaths = new HashSet<String>();
        HashSet<IFile> refreshFiles = new HashSet<IFile>();
        Iterator<Map.Entry<IFile, List<EditParameters>>> iterator = editsByFile.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<IFile, List<EditParameters>> entry = iterator.next();
            IFile file = entry.getKey();
            if (file.getLocation() == null || file.getLocation().toFile() == null) continue;
            try {
                String canonicalPath = null;
                if (this.canonicalPathsCache != null) {
                    canonicalPath = this.canonicalPathsCache.get(file);
                }
                if (canonicalPath == null) {
                    canonicalPath = file.getLocation().toFile().getCanonicalPath();
                    if (this.canonicalPathsCache == null) {
                        this.canonicalPathsCache = new HashMap<IFile, String>();
                    }
                    this.canonicalPathsCache.put(file, canonicalPath);
                }
                if (canonicalPaths.contains(canonicalPath)) {
                    refreshFiles.add(file);
                    iterator.remove();
                    continue;
                }
                canonicalPaths.add(canonicalPath);
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return refreshFiles;
    }

    public int getHiddenFixesCount(VerissimoAutofix autofix) {
        List<OVMComplianceCheckHit> hits = autofix.getHits();
        if (hits == null) {
            return 0;
        }
        return hits.stream().reduce(0, (acc, hit) -> hit.isHidden() ? acc + 1 : acc, Integer::sum);
    }

    public void cleanCanonicalPathsCache() {
        if (this.canonicalPathsCache != null) {
            this.canonicalPathsCache.clear();
        }
    }

    protected Map<IFile, IDocument> computeOutOfSyncFilesMapGUISpecific(Set<IFile> affectedFiles, RfProject currentRfProject) {
        if (affectedFiles == null || currentRfProject == null) {
            return null;
        }
        HashMap<IFile, IDocument> result = new HashMap<IFile, IDocument>();
        for (IFile file : affectedFiles) {
            RfFileDef fileDef = currentRfProject.getFile((IResource)file);
            if (fileDef == null) continue;
            byte[] fileDefMd5 = fileDef.getParserPath().getMd5();
            MessageDigest md = null;
            try {
                IDocument document = VerissimoAutofixUtils.getInstance().getDocument(file);
                String string = document.get();
                md = MessageDigest.getInstance(MD5_STRING);
                md.update(string.getBytes());
                byte[] documentMd5 = md.digest();
                boolean isMd5Equals = Arrays.equals(documentMd5, fileDefMd5);
                if (isMd5Equals) continue;
                result.put(file, document);
            }
            catch (NoSuchAlgorithmException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return result;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected DVTProblem checkAutofixResult(Set<IFile> affectedFiles, Collection<DVTProblem> problemsBeforeRefresh, Collection<DVTProblem> problemsAfterRefresh) {
        if (affectedFiles == null || affectedFiles.isEmpty()) {
            return null;
        }
        mapProblemsBefore = problemsBeforeRefresh.stream().collect(Collectors.groupingBy((Function<DVTProblem, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPath(), (Lro/amiq/dvt/model/problems/DVTProblem;)Ljava/lang/String;)()));
        mapProblemsAfter = problemsAfterRefresh.stream().collect(Collectors.groupingBy((Function<DVTProblem, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPath(), (Lro/amiq/dvt/model/problems/DVTProblem;)Ljava/lang/String;)()));
        differ = new VerissimoDiffer(null, true);
        affectedFilesMap = new HashMap<String, IFile>();
        for (IFile file : affectedFiles) {
            affectedFilesMap.put(DVTFileUtils.getInstance().resource2parser((IResource)file).path, file);
        }
        for (Map.Entry entry : affectedFilesMap.entrySet()) {
            path = (String)entry.getKey();
            affectedFile = (IFile)entry.getValue();
            afterProblems = mapProblemsAfter.get(path);
            if (afterProblems == null || afterProblems.isEmpty()) continue;
            beforeProblems = mapProblemsBefore.get(path);
            if (beforeProblems == null || beforeProblems.isEmpty()) {
                return afterProblems.get(0);
            }
            afterIterator = afterProblems.iterator();
            doc = VerissimoAutofixUtils.getInstance().getDocument(affectedFile);
            beforeContent = Arrays.asList(this.oldFileContent.get(affectedFile).split(System.lineSeparator(), -1));
            filePatch = differ.computeFilePatch(path, beforeContent, afterContent = Arrays.asList(doc.get().split(System.lineSeparator(), -1)));
            if (filePatch != null) ** GOTO lbl28
            return afterProblems.get(0);
lbl-1000:
            // 1 sources

            {
                afterProblem = afterIterator.next();
                if (this.isTheSameProblem(afterProblem, problemRange = differ.computeLineMapping(path, afterProblem.getLine() - 1, false), beforeProblems)) continue;
                return afterProblem;
lbl28:
                // 2 sources

                ** while (afterIterator.hasNext())
            }
lbl29:
            // 1 sources

        }
        return null;
    }

    private boolean isTheSameProblem(DVTProblem afterProblem, VerissimoDiffer.Range problemRange, List<DVTProblem> beforeProblems) {
        ArrayList<DVTProblem> matchingBeforeProblems = new ArrayList<DVTProblem>();
        for (DVTProblem beforeProblem : beforeProblems) {
            if (!problemRange.contains(beforeProblem.getLine() - 1)) continue;
            matchingBeforeProblems.add(beforeProblem);
        }
        if (matchingBeforeProblems.isEmpty()) {
            return false;
        }
        ISourceProblem afterSourceProblem = afterProblem.getSourceProblem();
        if (!(afterSourceProblem instanceof VlogProblem)) {
            return false;
        }
        VlogProblem afterVlogProblem = (VlogProblem)afterSourceProblem;
        String afterProblemMessage = afterVlogProblem.getMessage(true);
        int afterProblemIndex = afterProblemMessage.indexOf(":");
        boolean foundProblem = false;
        for (DVTProblem beforeProblem : matchingBeforeProblems) {
            ISourceProblem beforeSourceProblem = beforeProblem.getSourceProblem();
            if (!(beforeSourceProblem instanceof VlogProblem)) continue;
            VlogProblem beforeVlogProblem = (VlogProblem)beforeSourceProblem;
            if (!afterVlogProblem.getClass().equals(beforeVlogProblem.getClass())) continue;
            String beforeProblemMessage = beforeVlogProblem.getMessage(true);
            int beforeProblemIndex = beforeProblemMessage.indexOf(":");
            if (afterProblemIndex < 0 || beforeProblemIndex < 0 || !afterProblemMessage.substring(0, afterProblemIndex).equals(beforeProblemMessage.substring(0, beforeProblemIndex))) continue;
            foundProblem = true;
            break;
        }
        return foundProblem;
    }

    protected String getErrorMessage(DVTProblem problem) {
        if (problem == null) {
            return "!";
        }
        String result = " because of the new '" + problem.getMessage() + "' compilation issue" + System.lineSeparator();
        result = String.valueOf(result) + "at line " + problem.getLine() + " in file " + problem.getPath() + "!";
        return result;
    }

    protected abstract boolean checkOutLicense();

    protected abstract void checkInLicense();

    protected abstract boolean sourceCodeChanged(IProject var1);

    protected abstract Map<IFile, IDocument> computeOutOfSyncFilesMap(Set<IFile> var1, RfProject var2);

    protected abstract boolean ensureFilesInSync(Map<IFile, IDocument> var1);

    protected abstract ProgressMonitorDialog getProgressMonitorDialog();

    protected abstract void computeAutofixResult(ProgressMonitorDialog var1, VerissimoAutofix var2);

    protected abstract boolean autofixCancelled(ProgressMonitorDialog var1);

    protected abstract void showNoOtherFixesDialog();

    protected abstract int applyAutofixes(VerissimoAutofix var1, int var2, Set<IFile> var3);

    protected abstract boolean refreshProject(VerissimoAutofixResult var1, OVMProject var2, OVMComplianceCheck var3);

    protected abstract CompletableFuture<Boolean> validateFileModification(Set<IFile> var1);

    protected abstract void addTextEditChangeGroupInPreviewPanel(VlogTextFileChange var1, IFile var2);

    protected abstract boolean showDirtyDialog(OVMComplianceCheck var1, OVMProject var2);

    protected abstract void showNoHitsErrorDialog();

    protected abstract void testPressOkButton();

    public static class AIAutofixEdit {
        int start;
        int end;
        String replacement;
        String filePath;

        public AIAutofixEdit(int start, int end, String replacement, String filePath) {
            this.start = start;
            this.end = end;
            this.replacement = replacement;
            this.filePath = filePath;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }

    public static class EditsResult {
        Set<IFile> refreshFiles = new HashSet<IFile>();
        Map<IFile, List<EditParameters>> editsByFile = new HashMap<IFile, List<EditParameters>>();

        public EditsResult(Set<IFile> refreshFiles, Map<IFile, List<EditParameters>> editsByFile) {
            this.refreshFiles = refreshFiles;
            this.editsByFile = editsByFile;
        }

        public Set<IFile> getRefreshFiles() {
            return this.refreshFiles;
        }

        public Map<IFile, List<EditParameters>> getEditsByFile() {
            return this.editsByFile;
        }
    }
}

