/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import ro.amiq.dvt.ui.refactor.DVTRefactoringProcessor;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixManager;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public class VerissimoAutofixProcessor
extends DVTRefactoringProcessor {
    private VerissimoAutofix autofix;

    public VerissimoAutofixProcessor(VerissimoAutofix autofix) {
        this.autofix = autofix;
    }

    public Object[] getElements() {
        return new Object[0];
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getProcessorName() {
        return "Fix " + this.autofix.getCheck().getName() + " failures";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        long startTime = System.currentTimeMillis();
        CompositeChange rootChange = new CompositeChange(this.getProcessorName());
        Map<IResource, VlogTextFileChange> changesPerFiles = VerissimoAutofixManager.getInstance().createChanges(this.autofix.getResult());
        if (changesPerFiles != null) {
            for (Map.Entry<IResource, VlogTextFileChange> entry : changesPerFiles.entrySet()) {
                VlogTextFileChange fileChange = entry.getValue();
                if (fileChange.getEdit().getChildrenSize() <= 0) continue;
                rootChange.add((Change)fileChange);
            }
        }
        this.autofix.getCheck().setFixingTime(System.currentTimeMillis() - startTime);
        return rootChange;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }
}

