/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;

public class VerissimoAutofixResult {
    private OVMComplianceCheck check;
    private Map<OVMComplianceCheckHit, Map<IFile, List<EditParameters>>> edits;
    private List<VerissimoAutofixError> errors;
    private Set<IFile> readonlyFiles;
    private Set<IFile> refreshFiles;

    public VerissimoAutofixResult(OVMComplianceCheck check) {
        this.check = check;
        this.edits = new LinkedHashMap<OVMComplianceCheckHit, Map<IFile, List<EditParameters>>>();
        this.errors = new ArrayList<VerissimoAutofixError>();
        this.readonlyFiles = new HashSet<IFile>();
        this.refreshFiles = new HashSet<IFile>();
    }

    public OVMComplianceCheck getCheck() {
        return this.check;
    }

    public Map<OVMComplianceCheckHit, Map<IFile, List<EditParameters>>> getEdits() {
        return this.edits;
    }

    public List<VerissimoAutofixError> getErrors() {
        return this.errors;
    }

    public Set<IFile> getReadonlyFiles() {
        return this.readonlyFiles;
    }

    public void setReadonlyFiles(Set<IFile> readonlyFiles) {
        this.readonlyFiles = readonlyFiles;
    }

    public int getNofErrors() {
        return this.errors != null ? this.errors.size() : 0;
    }

    public int getNofHits() {
        return this.edits != null && this.edits.keySet() != null ? this.edits.keySet().size() : 0;
    }

    public Set<IFile> getAffectedFiles() {
        if (this.edits == null || this.edits.isEmpty()) {
            return null;
        }
        HashSet<IFile> affectedFiles = new HashSet<IFile>();
        for (Map.Entry<OVMComplianceCheckHit, Map<IFile, List<EditParameters>>> entry : this.edits.entrySet()) {
            Map<IFile, List<EditParameters>> editsForHit = entry.getValue();
            if (editsForHit == null || editsForHit.isEmpty()) continue;
            affectedFiles.addAll(editsForHit.keySet());
        }
        return affectedFiles;
    }

    public int getTotalNofEdits() {
        if (this.edits == null) {
            return 0;
        }
        Set<OVMComplianceCheckHit> allHits = this.edits.keySet();
        if (allHits == null) {
            return 0;
        }
        int nofEdits = 0;
        for (OVMComplianceCheckHit hit : allHits) {
            Set<IFile> files;
            Map<IFile, List<EditParameters>> editsByFiles = this.edits.get(hit);
            if (editsByFiles == null || (files = editsByFiles.keySet()) == null) continue;
            for (IFile file : files) {
                List<EditParameters> editsInFile = editsByFiles.get(file);
                if (editsInFile == null) continue;
                nofEdits += editsInFile.size();
            }
        }
        return nofEdits;
    }

    public void removeEditsForHit(OVMComplianceCheckHit hit) {
        this.edits.remove(hit);
    }

    public void setRefreshFiles(Set<IFile> refreshFiles) {
        this.refreshFiles = refreshFiles;
    }

    public Set<IFile> getRefreshFiles() {
        return this.refreshFiles;
    }
}

