/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import ro.amiq.dvt.ui.refactor.utils.DVTRefactoringWizard;
import ro.amiq.vlogdt.linter.autofixes.UserInputAutofix;
import ro.amiq.vlogdt.linter.autofixes.UserInputAutofixBeforeEdits;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorPage;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixResult;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixWizardPage;

public class VerissimoAutofixWizard
extends DVTRefactoringWizard {
    public static final int MAX_NUMBER_OF_ERRORS_ON_PAGE = 100;
    private VerissimoAutofix autofix;
    private int hiddenFixesCount;

    public VerissimoAutofixWizard(Refactoring refactoring, VerissimoAutofix autofix, int hiddenFixesCount) {
        super(refactoring, 36);
        this.autofix = autofix;
        this.hiddenFixesCount = hiddenFixesCount;
        this.setWindowTitle("Fix " + autofix.getCheck().getName() + " Failures");
    }

    protected void addUserInputPages() {
        List<VerissimoAutofixError> errors;
        VerissimoAutofixResult autofixResult = this.autofix.getResult();
        Set<IFile> readOnlyFilesEncountered = autofixResult.getReadonlyFiles();
        if (readOnlyFilesEncountered != null && !readOnlyFilesEncountered.isEmpty()) {
            this.addPage(VerissimoAutofixWizardPage.getReadOnlyFilesPage(readOnlyFilesEncountered));
        }
        if (this.autofix instanceof UserInputAutofix && !(this.autofix instanceof UserInputAutofixBeforeEdits)) {
            this.addPage((IWizardPage)((UserInputAutofix)this.autofix).getWizardPage(this.autofix));
        }
        if ((errors = autofixResult.getErrors()) != null && !errors.isEmpty()) {
            this.addPage((IWizardPage)VerissimoAutofixWizardPage.getErrorDefaultWizardPage());
            int nOfErrors = autofixResult.getNofErrors();
            int i = 0;
            while (i <= (nOfErrors - 1) / 100) {
                this.addPage((IWizardPage)new VerissimoAutofixErrorPage("Error page " + i, this.autofix, i));
                ++i;
            }
        } else {
            this.addPage((IWizardPage)VerissimoAutofixWizardPage.getSuccessDefaultWizardPage(this.computeExtraInfo()));
        }
    }

    private String computeExtraInfo() {
        if (this.hiddenFixesCount > 0) {
            return "\n" + MessageFormat.format("Note: There are {0,number,#} similar issues not presented due to the maxHitsPerFile parameter that will be fixed.", this.hiddenFixesCount);
        }
        return "";
    }
}

