/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public abstract class AbstractInstructionInsertAutofix
extends VerissimoAutofix {
    protected AbstractInstructionInsertAutofix(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        DocumentManager docManager = this.getDocumentManager();
        for (OVMComplianceCheckHit hit : hits) {
            try {
                Collection<RfFunctionCall> functionCalls;
                VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
                if (autofixAdditionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                Object element = autofixAdditionalInfo.getElement();
                if (!(element instanceof RfFunction)) {
                    VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    this.addSpecialErrorMessage(error);
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                RfFunction function = (RfFunction)element;
                RfDefElement functionImplementation = function.getImplementation();
                if (functionImplementation == null) {
                    VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error.setReason("it has no implementation");
                    this.addError(error);
                    continue;
                }
                ParserPath implementationParserPath = functionImplementation.getParserPath();
                IDocument implementationDocument = docManager.getDocument(implementationParserPath, this.getIProject());
                IFile implementationFile = VerissimoAutofixUtils.getInstance().getFile(this.getIProject(), implementationParserPath);
                String afterIndentation = functionImplementation.getStartLine() == functionImplementation.getEndLine() ? " " : "\n";
                List<RfField> fields = function.getFields();
                if (fields != null && !fields.isEmpty()) {
                    String beforeIndentation;
                    int startOffset;
                    RfAssociatedType lastField = null;
                    boolean isFirst = true;
                    for (RfField field : fields) {
                        if (isFirst) {
                            lastField = field;
                            isFirst = false;
                            continue;
                        }
                        if (lastField == null || field.getStartOffset() <= lastField.getStartOffset()) continue;
                        lastField = field;
                    }
                    if (lastField == null || lastField.getDeclaration() == null) continue;
                    if (functionImplementation.getStartLine() != functionImplementation.getEndLine()) {
                        startOffset = implementationDocument.getLineOffset(lastField.getDeclaration().getEndLine());
                        String content = ((IDocumentExtension3)implementationDocument).getContentType("__vlog_partitioning", startOffset, false);
                        if (implementationDocument.getChar(startOffset - 1) != '\n' || content.equals("__vlog_ml_comment") || content.equals("__vlog_sl_comment")) {
                            startOffset = VerissimoAutofixEditsUtils.INSTANCE.getEndOffsetIfInlineComment(implementationDocument, startOffset, implementationDocument.getLineOfOffset(startOffset));
                        }
                        beforeIndentation = DVTDocumentUtils.getIndent((int)lastField.getDeclaration().getStartOffset(), (IDocument)implementationDocument);
                    } else {
                        startOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(implementationDocument, ";", lastField.getDeclaration().getStartOffset(), implementationDocument.getLength(), true);
                        beforeIndentation = " ";
                    }
                    String functionCall = this.cumputeInsertStatement(function);
                    if (functionCall == null) continue;
                    InsertEditParameters edit = new InsertEditParameters(this, startOffset, functionCall, beforeIndentation, afterIndentation);
                    this.addEditForHit(hit, implementationFile, edit);
                    continue;
                }
                int startOffset = functionImplementation.getStartOffset();
                startOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(implementationDocument, ";", startOffset, implementationDocument.getLength(), true);
                if (functionImplementation.getStartLine() != functionImplementation.getEndLine() && implementationDocument.getChar(startOffset - 1) != '\n') {
                    startOffset = VerissimoAutofixEditsUtils.INSTANCE.getEndOffsetIfInlineComment(implementationDocument, startOffset, implementationDocument.getLineOfOffset(startOffset));
                }
                ArrayList<RfNamedElement> allElements = new ArrayList<RfNamedElement>();
                Collection<RfNamedElement> members = function.getMembers();
                if (members != null) {
                    for (RfNamedElement currentMember : members) {
                        if (currentMember instanceof RfField && ((RfField)currentMember).isArgument()) continue;
                        allElements.add(currentMember);
                    }
                }
                if ((functionCalls = function.getLocalFunctionCalls()) != null && !functionCalls.isEmpty()) {
                    allElements.addAll(functionCalls);
                }
                if (allElements.isEmpty()) {
                    String beforeIndentation = functionImplementation.getStartLine() != functionImplementation.getEndLine() ? String.valueOf(DVTDocumentUtils.getIndent((int)functionImplementation.getStartOffset(), (IDocument)implementationDocument)) + "\t" : " ";
                    String functionCall = this.cumputeInsertStatement(function);
                    if (functionCall == null) continue;
                    InsertEditParameters edit = new InsertEditParameters(this, startOffset, functionCall, beforeIndentation, afterIndentation);
                    this.addEditForHit(hit, implementationFile, edit);
                    continue;
                }
                RfNamedElement firstMember = null;
                boolean first = true;
                for (RfNamedElement member : allElements) {
                    if (first) {
                        firstMember = member;
                        first = false;
                        continue;
                    }
                    if (firstMember == null || member.getStartOffset() <= firstMember.getStartOffset()) continue;
                    firstMember = member;
                }
                if (firstMember == null) continue;
                String beforeIndentation = functionImplementation.getStartLine() != functionImplementation.getEndLine() ? DVTDocumentUtils.getIndent((int)firstMember.getDeclaration().getStartOffset(), (IDocument)implementationDocument) : " ";
                String functionCall = this.cumputeInsertStatement(function);
                if (functionCall == null) continue;
                InsertEditParameters edit = new InsertEditParameters(this, startOffset, functionCall, beforeIndentation, afterIndentation);
                this.addEditForHit(hit, implementationFile, edit);
            }
            catch (BadLocationException | BadPartitioningException e) {
                DVTLogger.INSTANCE.logError(e);
            }
        }
        docManager.deactivate();
    }

    private DocumentManager getDocumentManager() {
        DocumentManager docManager = new DocumentManager();
        try {
            docManager.activate();
        }
        catch (IllegalStateException illegalStateException) {}
        return docManager;
    }

    protected void addSpecialErrorMessage(VerissimoAutofixError error) {
    }

    protected abstract String cumputeInsertStatement(RfFunction var1);
}

