/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;

public class Autofix_R_1197
extends VerissimoAutofix {
    public Autofix_R_1197(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            VerissimoAutofixAdditionalInfo hitAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (hitAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            if (!(hitAdditionalInfo.getElement() instanceof Integer) && !(hitAdditionalInfo.getElement() instanceof ArrayList)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            int lineOffset = -1;
            try {
                lineOffset = document.getLineOffset(hit.getLine() - 1);
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            if (lineOffset == -1) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            int nofSpaces = (Integer)hitAdditionalInfo.getElement();
            int firstCharOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfNextNonWhitespaceCharacter(document, lineOffset);
            ReplaceEditParameters edit = new ReplaceEditParameters(this, lineOffset, firstCharOffset - lineOffset, StringUtils.repeat((String)" ", (int)nofSpaces));
            this.addEditForHit(hit, file, edit);
        }
    }
}

