/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.parser.SVTBIssues;

public class Autofix_SVTB_10_7_3
extends VerissimoAutofix {
    public Autofix_SVTB_10_7_3(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        try {
            for (OVMComplianceCheckHit hit : hits) {
                VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
                if (autofixAdditionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                Object element = autofixAdditionalInfo.getElement();
                if (!(element instanceof SVTBIssues)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                SVTBIssues issue = (SVTBIssues)element;
                if (issue.getReparseInfo() != null) {
                    VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error.setReason("it is used inside a macro call");
                    this.addError(error);
                    continue;
                }
                int startOffset = this.getIssueOffset(issue, document);
                IRfScopeElement scope = RfBatchUtils.getRfScope(this.getRfProject(), hit.getParserPath(), startOffset);
                if (scope instanceof RfActionBlockDef) {
                    Object[] nextToken;
                    String token;
                    RfNamedElement elem = ((RfActionBlockDef)scope).getNamedElement();
                    if (!(elem instanceof RfActionBlock)) continue;
                    RfActionBlock actionBlock = (RfActionBlock)elem;
                    if (actionBlock.hasBeginEnd()) {
                        this.deleteDelay(issue, document, file, hit);
                        continue;
                    }
                    if (actionBlock.isIf() && "else".equals(token = (String)(nextToken = VerissimoAutofixEditsUtils.INSTANCE.getNextTextToken(document, actionBlock.getEndOffset(), true))[1])) {
                        this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                        continue;
                    }
                    if (actionBlock.isAlways()) {
                        this.deleteDelay(issue, document, file, hit);
                        continue;
                    }
                    startOffset = VerissimoAutofixEditsUtils.INSTANCE.getActionBlockLabelStartOffset(actionBlock, document);
                    int startContentOffset = VerissimoAutofixEditsUtils.INSTANCE.getContentStartOffsetInsideScope(actionBlock, document);
                    String contentBeforeDelay = document.get(startContentOffset, this.getIssueOffset(issue, document) - startContentOffset);
                    if (!contentBeforeDelay.trim().isEmpty()) {
                        this.deleteDelay(issue, document, file, hit);
                        continue;
                    }
                    int endOffset = ((RfActionBlockDef)scope).getEndOffset();
                    DeleteEditParameters edit2 = new DeleteEditParameters(this, startOffset, endOffset - startOffset);
                    this.addEditForHit(hit, file, edit2);
                    continue;
                }
                this.deleteDelay(issue, document, file, hit);
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private int getIssueOffset(SVTBIssues issue, IDocument document) {
        if (issue == null) {
            return -1;
        }
        try {
            int offset = issue.getOffset();
            char currentChar = document.getChar(offset);
            if (currentChar != '#') {
                int previousCharOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfPreviousNonWhitespaceCharacter(document, offset - 1, true);
                char prevChar = document.getChar(previousCharOffset);
                if (prevChar == '#') {
                    offset = previousCharOffset;
                }
                if ((prevChar = document.getChar(previousCharOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfPreviousNonWhitespaceCharacter(document, offset - 1, true))) == '#') {
                    offset = previousCharOffset;
                }
            } else {
                int previousCharOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfPreviousNonWhitespaceCharacter(document, offset - 1, true);
                char prevChar = document.getChar(previousCharOffset);
                if (prevChar == '#') {
                    offset = previousCharOffset;
                }
            }
            return offset;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return issue.getOffset();
        }
    }

    private void deleteDelay(SVTBIssues issue, IDocument document, IFile file, OVMComplianceCheckHit hit) {
        Object[] nextChar;
        int startOffset = issue.getOffset();
        String text = issue.getInfo();
        int length = text.length();
        int endOffset = startOffset + length;
        if (!text.startsWith("##")) {
            if (text.startsWith("#")) {
                previousCodeChar = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)document, (int)(startOffset - 1), (boolean)false, (String)"__vlog_partitioning");
                if (((Character)previousCodeChar[0]).charValue() == '#') {
                    startOffset = (Integer)previousCodeChar[1] - 1;
                }
            } else {
                previousCodeChar = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)document, (int)(startOffset - 1), (boolean)false, (String)"__vlog_partitioning");
                if (((Character)previousCodeChar[0]).charValue() == '#' && ((Character)(previousCodeChar = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)document, (int)((startOffset = (Integer)previousCodeChar[1] - 1) - 1), (boolean)false, (String)"__vlog_partitioning"))[0]).charValue() == '#') {
                    startOffset = (Integer)previousCodeChar[1] - 1;
                }
            }
        }
        if (((Character)(nextChar = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)document, (int)endOffset, (boolean)true, (String)"__vlog_partitioning"))[0]).charValue() == ';') {
            endOffset = (Integer)nextChar[1] + 1;
        }
        DeleteEditParameters edit = new DeleteEditParameters(this, startOffset, endOffset - startOffset);
        this.addEditForHit(hit, file, edit);
    }
}

