/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public class Autofix_SVTB_11_2_2_3
extends VerissimoAutofix {
    public Autofix_SVTB_11_2_2_3(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        try {
            if (hits == null || hits.isEmpty()) {
                return;
            }
            for (OVMComplianceCheckHit hit : hits) {
                int endOffset;
                VerissimoAutofixAdditionalInfo hitAdditionalInfo = hit.getAutofixAdditionalInfo();
                if (hitAdditionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                if (!(hitAdditionalInfo.getParentElement() instanceof RfActionBlock)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                RfActionBlock actionBlock = (RfActionBlock)hitAdditionalInfo.getParentElement();
                int startOffset = actionBlock.getStartOffset();
                if (startOffset == (endOffset = actionBlock.getEndOffset())) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                int leftParanthesesOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, "(", startOffset, actionBlock.getEndOffset(), true);
                endOffset = VerissimoAutofixEditsUtils.INSTANCE.getMatchingRightParenthesesOffset(document, leftParanthesesOffset, actionBlock.getEndOffset());
                if (endOffset == -1) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                String text = document.get(startOffset, endOffset - startOffset + 1);
                ReplaceEditParameters edit = new ReplaceEditParameters(this, startOffset, endOffset - startOffset + 1, text, this.getReplacementString(text, hitAdditionalInfo));
                this.addEditForHit(hit, file, edit);
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String getReplacementString(String textToReplace, VerissimoAutofixAdditionalInfo additionalInfo) {
        if (textToReplace == null || additionalInfo == null || !(additionalInfo.getElement() instanceof RfHidOperator)) {
            return null;
        }
        RfHidOperator hidOperator = (RfHidOperator)additionalInfo.getElement();
        RfHidOperator forCondition = (RfHidOperator)hidOperator.getLHValue();
        IHidObject left = forCondition.getLHValue();
        IHidObject right = (IHidObject)forCondition.getRHValues().get(0);
        String arrayName = "";
        String iteratorName = "";
        RfHidAccessArgs access = null;
        if (left instanceof RfHidAccessArgs) {
            access = (RfHidAccessArgs)left;
        } else if (right instanceof RfHidAccessArgs) {
            access = (RfHidAccessArgs)right;
        }
        if (access != null) {
            arrayName = this.getArrayName(access);
        }
        RfHidOperator operator = null;
        if (left instanceof RfHidOperator) {
            operator = (RfHidOperator)left;
        } else if (right instanceof RfHidOperator) {
            operator = (RfHidOperator)right;
        }
        if (operator != null) {
            IHidObject leftOperand = operator.getLHValue();
            IHidObject rightOperand = (IHidObject)operator.getRHValues().get(0);
            if (leftOperand instanceof RfHidAccessArgs) {
                arrayName = this.getArrayName((RfHidAccessArgs)leftOperand);
            } else if (rightOperand instanceof RfHidAccessArgs) {
                arrayName = this.getArrayName((RfHidAccessArgs)rightOperand);
            }
        }
        RfHid hid = null;
        if (left instanceof RfHid) {
            hid = (RfHid)left;
        } else if (right instanceof RfHid) {
            hid = (RfHid)right;
        }
        if (hid != null) {
            iteratorName = hid.getName();
        }
        return MessageFormat.format("foreach ({0}[{1}])", arrayName, iteratorName);
    }

    private String getArrayName(RfHidAccessArgs access) {
        HidAccess parentAccess = access.getParentHid().getParentAccess();
        String arrayName = parentAccess.toString();
        if (arrayName.endsWith(".")) {
            arrayName = arrayName.substring(0, arrayName.length() - 1);
        }
        return arrayName;
    }
}

