/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;

public class Autofix_SVTB_12_11
extends VerissimoAutofix {
    public Autofix_SVTB_12_11(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            try {
                VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
                if (additionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                Object argumentElem = additionalInfo.getElement();
                if (!(argumentElem instanceof RfFieldDef)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                Object argumentsOnLineElem = additionalInfo.getParentElement();
                if (!(argumentsOnLineElem instanceof ArrayList)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                RfFieldDef argument = (RfFieldDef)argumentElem;
                ArrayList argumentsOnLine = (ArrayList)argumentsOnLineElem;
                Integer startOffset = argument.getStartOffset();
                int lineOffset = document.getLineOffset(hit.getLine() - 1);
                String lineIndent = VerissimoAutofixEditsUtils.INSTANCE.getIndent(lineOffset, document);
                String lineDelimiter = document.getLineDelimiter(0);
                if (hits.size() == 1 && ((RfFieldDef)argumentsOnLine.get(0)).equals(argument) && argumentsOnLine.size() > 1) {
                    int nextLineOffset = document.getLineOffset(hit.getLine());
                    int nextCommaOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ",", startOffset, nextLineOffset, false);
                    if (nextCommaOffset == -1 || nextCommaOffset == nextLineOffset) continue;
                    int editEndOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfNextNonWhitespaceCharacter(document, ++nextCommaOffset);
                    ReplaceEditParameters edit = new ReplaceEditParameters(this, nextCommaOffset, editEndOffset - nextCommaOffset, String.valueOf(lineDelimiter) + lineIndent);
                    this.addEditForHit(hit, file, edit);
                    continue;
                }
                int editStartOffset = -1;
                int previousCommaOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, ",", lineOffset, startOffset, false, false, true);
                int previousOpenBracketOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, "(", lineOffset, startOffset, false, false, true);
                int previousClosedBracketOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, ")", lineOffset, startOffset, false, false, true);
                if (previousClosedBracketOffset > previousCommaOffset && previousClosedBracketOffset > previousOpenBracketOffset) {
                    int previousOpenBracketOffset2 = VerissimoAutofixEditsUtils.INSTANCE.getMatchingLeftParenthesesOffset(document, previousClosedBracketOffset - lineOffset, lineOffset);
                    previousCommaOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, ",", lineOffset, previousOpenBracketOffset2 - 1, false, false, true);
                    previousOpenBracketOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, "(", lineOffset, previousOpenBracketOffset2 - 1, false, false, true);
                }
                if ((editStartOffset = Math.max(previousCommaOffset, previousOpenBracketOffset)) == -1 || editStartOffset <= lineOffset) continue;
                int editEndOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfNextNonWhitespaceCharacter(document, ++editStartOffset);
                ReplaceEditParameters edit = new ReplaceEditParameters(this, editStartOffset, editEndOffset - editStartOffset, String.valueOf(lineDelimiter) + lineIndent);
                this.addEditForHit(hit, file, edit);
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                this.addError(error);
            }
        }
    }
}

