/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.parser.VlogFileInstance;

public class Autofix_SVTB_12_1_2
extends VerissimoAutofix {
    public Autofix_SVTB_12_1_2(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            String startKeyword;
            VlogFileInstance fileInstance;
            VerissimoAutofixAdditionalInfo hitAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (hitAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            if (!(hitAdditionalInfo.getElement() instanceof RfFunction)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            RfFunction function = (RfFunction)hitAdditionalInfo.getElement();
            VlogFileInstance topInstance = this.getRfProject().getPreprocessingTable().getTopFileInstance();
            List<VlogFileInstance> instances = topInstance.getFileInstances(function.getDeclaration().getParserPath());
            if (instances != null && !instances.isEmpty() && (fileInstance = topInstance.getFileInstances(function.getDeclaration().getParserPath()).get(0)).getLanguageSyntax().equals((Object)IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001)) {
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                error.setReason("the 'static' keyword is not supported in Verilog 2001");
                this.addError(error);
                continue;
            }
            if (function.isTask()) {
                startKeyword = "task";
            } else if (function.isFunction()) {
                startKeyword = "function";
            } else {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            RfDefElement functionDef = function.getDeclaration();
            if (functionDef.getReparseInfo() != null) {
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                error.setReason("function is declared inside macro");
                this.addError(error);
                continue;
            }
            int startOffset = function.getStartOffset();
            startOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, startKeyword, 0, startOffset, false) + startKeyword.length();
            InsertEditParameters edit = new InsertEditParameters(this, startOffset, this.getQualifier(), " ", "");
            this.addEditForHit(hit, file, edit);
        }
    }

    private String getQualifier() {
        return "static";
    }
}

