/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

public class Autofix_SVTB_12_4
extends VerissimoAutofix {
    public Autofix_SVTB_12_4(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            VerissimoAutofixAdditionalInfo hitAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (hitAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            if (!(hitAdditionalInfo.getElement() instanceof RfHid)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            RfHid element = (RfHid)((Object)hitAdditionalInfo.getElement());
            String functionName = element.getName();
            IReparseInfo reparseInfo = element.getReparseInfo();
            if (reparseInfo != null) {
                ParserPath macroFile = reparseInfo.getLastReparseMacroFile();
                String shortFileName = LintUtils.getFileShortName(macroFile.path);
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                if (hit.getCheck().getOVMProject().isOVMFile(shortFileName)) {
                    error.setReason("it is used as macro argument for'" + reparseInfo.getLastReparseMacroName() + "'");
                } else {
                    error.setReason("it is defined in macro '" + reparseInfo.getLastReparseMacroName() + "'");
                }
                this.addError(error);
                return;
            }
            int startOffset = element.getOccurrence().getOffset();
            InsertEditParameters edit = new InsertEditParameters(this, startOffset += functionName.length(), "()");
            this.addEditForHit(hit, file, edit);
        }
    }
}

