/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.UserInputAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.linter.base.annotations.AutofixParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;

public class Autofix_SVTB_15_4_1_1
extends UserInputAutofix {
    private static final String ENABLE_ALLOW_TEMP_VARIABLE_ERROR = "You can set 'allowTempVariableChecking=true' parameter in the ruleset to allow storing results in a temporary variable.\nThis will also allow auto-correct to fix this failure";
    private static final String VOID_OR_ASSERT_FORMATTING_ERROR = "Bad formatting of the void' or assert statement";
    private static final String UVM_ERROR = "`uvm_error(\\{uvmErrorId\\}, \\{uvmErrorMessage\\})";
    private static final String UNIMPLEMENTED_ERROR = "Failures are currently not fixable if:\n- checkCondition is set to true;\n- checkFailureMacros is not empty";
    private Map<RfNamedElement, Map<String, Integer>> variableIndexInScopeMap = new HashMap<RfNamedElement, Map<String, Integer>>();
    private static final Pattern NO_SPACE_RANDOMIZE_PATTERN = Pattern.compile("randomizewith");
    private boolean allowTempVariable;
    private boolean checkCondition;
    private String failureMacros;
    @AutofixParameter(defaultValue="\"RANDOMIZE_ERROR\"", description="Id used for `uvm_error(id, message)", name="uvmErrorId", guiPrompt="`uvm_error(id, message) 'id' value:", type=CheckParameterType.STRING)
    public String uvmErrorId;
    @AutofixParameter(defaultValue="\"Error occurred during randomize call!\"", description="Message used for `uvm_error(id, message)", name="uvmErrorMessage", guiPrompt="`uvm_error(id, message) 'message' value:", type=CheckParameterType.STRING)
    public String uvmErrorMessage;

    public Autofix_SVTB_15_4_1_1(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
        this.allowTempVariable = VerissimoAutofixUtils.getInstance().getParameterValueAsBoolean(check, "allowTempVariableChecking");
        this.checkCondition = VerissimoAutofixUtils.getInstance().getParameterValueAsBoolean(check, "checkCondition");
        this.failureMacros = VerissimoAutofixUtils.getInstance().getParameterValueAsString(check, "checkFailureMacros");
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            VerissimoAutofixAdditionalInfo hitAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (hitAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            if (!(hitAdditionalInfo.getElement() instanceof RfHid)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            if (this.checkCondition || this.failureMacros != null && !this.failureMacros.isEmpty()) {
                this.addUnfixableError(hit, UNIMPLEMENTED_ERROR);
                continue;
            }
            RfHid randomizeHid = (RfHid)((Object)hitAdditionalInfo.getElement());
            Hid parentHid = randomizeHid.getParentHid();
            HidAccess randomizeAccess = randomizeHid.getFirstAccess();
            RfProject rfProject = RfManager.getInstance().getRfProject(this.getIProject());
            RfWNamedElementAndScope elementAndScopeAtOffset = RfUtils.getRfElement(rfProject, file, document, randomizeHid.getOccurrence().getOffset(), null);
            IRfScopeElement randomizeCallEnclosingScope = elementAndScopeAtOffset.getScope();
            if (!(randomizeCallEnclosingScope instanceof RfDefElement)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            RfNamedElement scopeElement = ((RfDefElement)randomizeCallEnclosingScope).getNamedElement();
            ArrayList<RfHid> functionHid = new ArrayList<RfHid>(1);
            ArrayList<RfHidOperator> assignmentHid = new ArrayList<RfHidOperator>(1);
            this.getAssignmentsAndFunctionCallsForRandomize(scopeElement, functionHid, assignmentHid, randomizeHid, hit.getLine());
            if (!assignmentHid.isEmpty()) {
                if (!this.allowTempVariable) {
                    this.addUnfixableError(hit, ENABLE_ALLOW_TEMP_VARIABLE_ERROR);
                    continue;
                }
                List<EditParameters> checkVariableEdit = this.checkVariable(scopeElement, (RfHidOperator)assignmentHid.get(0), (RfHidAccessArgs)randomizeAccess, randomizeHid, document);
                if (checkVariableEdit != null && !checkVariableEdit.isEmpty()) {
                    this.addEditsForHit(hit, file, checkVariableEdit);
                    continue;
                }
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            if (!functionHid.isEmpty()) {
                if (!this.allowTempVariable) {
                    this.addUnfixableError(hit, ENABLE_ALLOW_TEMP_VARIABLE_ERROR);
                    continue;
                }
                List<EditParameters> extractFunctionParameterToVariableEdit = this.extractRandomizeCallToVariable(scopeElement, (RfHid)((Object)functionHid.get(0)), (RfHidAccessArgs)randomizeAccess, randomizeHid, document, file);
                if (extractFunctionParameterToVariableEdit != null && !extractFunctionParameterToVariableEdit.isEmpty()) {
                    this.addEditsForHit(hit, file, extractFunctionParameterToVariableEdit);
                    continue;
                }
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            List<EditParameters> edits = this.surroundWithIfCheck(scopeElement, (RfHid)parentHid, randomizeHid, (RfHidAccessArgs)randomizeAccess, document, this.allowTempVariable, hit);
            if (edits != null && !edits.isEmpty()) {
                this.addEditsForHit(hit, file, edits);
                continue;
            }
            if (edits == null || !edits.isEmpty()) continue;
            this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
        }
    }

    private void getAssignmentsAndFunctionCallsForRandomize(RfNamedElement scopeElement, final List<RfHid> functionHid, final List<RfHidOperator> assignmentHid, final RfHid randomizeHid, final int hitLine) {
        final HidAccess hidAccess = randomizeHid.getFirstAccess();
        scopeElement.visitHidObject(null, new IHidVisitor<IHidObject>(){

            public boolean visit(IHidObject hidObject) {
                if (hidObject instanceof RfHid) {
                    ListContainer accesses = ((RfHid)hidObject).getAccesses();
                    if (accesses == null) {
                        return true;
                    }
                    for (HidAccess currentAccess : accesses) {
                        List<? extends IHidObject> argumentValues;
                        if (!(currentAccess instanceof RfHidAccessArgs) || (argumentValues = ((RfHidAccessArgs)currentAccess).getArgumentValues()) == null || argumentValues.isEmpty()) continue;
                        for (IHidObject iHidObject : argumentValues) {
                            IHidObject rightOperand;
                            if (!(iHidObject instanceof RfHidOperator) || (!(rightOperand = (IHidObject)((RfHidOperator)iHidObject).getRHValues().get(0)).equals(hidAccess) || ((HidAccess)rightOperand).getOccurrence().getLine() != hitLine) && (!rightOperand.equals((Object)randomizeHid) || ((RfHid)rightOperand).getOccurrence().getLine() != hitLine)) continue;
                            functionHid.add((RfHid)hidObject);
                            return true;
                        }
                    }
                    return true;
                }
                if (hidObject instanceof RfHidOperator) {
                    if (!((RfHidOperator)hidObject).isAssignment()) {
                        return true;
                    }
                    IHidObject right = (IHidObject)((RfHidOperator)hidObject).getRHValues().get(0);
                    if (right.equals(hidAccess) && ((RfHidOperator)hidObject).getOccurrence().getLine() == hitLine || right.equals((Object)randomizeHid) && ((RfHid)right).getOccurrence().getLine() == hitLine) {
                        assignmentHid.add((RfHidOperator)hidObject);
                        return true;
                    }
                    return true;
                }
                return true;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
    }

    private RfFunctionCall getFirstFunctionCall(RfNamedElement scopeElement, String randomizeCallString) {
        RfFunctionCall functionCallWithArg;
        Collection<RfFunctionCall> localFunctionCalls = scopeElement.getLocalFunctionCalls();
        if (localFunctionCalls == null || localFunctionCalls.isEmpty()) {
            return null;
        }
        RfFunctionCall previousFunctionCall = functionCallWithArg = this.getFunctionCallWithArg(localFunctionCalls, randomizeCallString);
        while (functionCallWithArg != null) {
            StringBuilder call = new StringBuilder();
            call.append(functionCallWithArg.toString()).append("(");
            List<String> arguments = functionCallWithArg.getArguments();
            if (arguments != null) {
                boolean isFirst = true;
                for (String arg : arguments) {
                    if (isFirst) {
                        call.append(arg);
                        isFirst = false;
                        continue;
                    }
                    call.append(",");
                    call.append(arg);
                }
            }
            call.append(")");
            previousFunctionCall = functionCallWithArg;
            functionCallWithArg = this.getFunctionCallWithArg(localFunctionCalls, call.toString());
        }
        return previousFunctionCall;
    }

    private RfFunctionCall getFunctionCallWithArg(Collection<RfFunctionCall> allFunctionCalls, String argument) {
        if (allFunctionCalls == null || allFunctionCalls.isEmpty() || argument == null) {
            return null;
        }
        if (!(argument = DVTStringUtil.replaceAll((Pattern)DVTStringUtil.MULTIPLE_WS, (CharSequence)argument, (String)"")).contains("randomize(")) {
            argument = DVTStringUtil.replaceAll((Pattern)NO_SPACE_RANDOMIZE_PATTERN, (CharSequence)argument, (String)"randomize with");
        }
        for (RfFunctionCall functionCall : allFunctionCalls) {
            List<String> functionArguments = functionCall.getArguments();
            if (functionArguments == null || functionArguments.isEmpty()) continue;
            for (String functionArg : functionArguments) {
                if (!functionArg.equals(argument)) continue;
                return functionCall;
            }
        }
        return null;
    }

    private List<EditParameters> checkVariable(RfNamedElement scopeElement, RfHidOperator assignmentHid, RfHidAccessArgs randomizeAccess, RfHid randomizeHid, IDocument document) {
        if (assignmentHid == null) {
            return null;
        }
        String variableName = this.getVariableName(assignmentHid);
        if (variableName == null) {
            return null;
        }
        ArrayList<EditParameters> edits = new ArrayList<EditParameters>();
        List<EditParameters> beginEndEdits = VerissimoAutofixEditsUtils.INSTANCE.insertBeginEndForActionBlock(scopeElement, document, this);
        if (beginEndEdits != null) {
            edits.addAll(beginEndEdits);
        }
        int randomizeCallEndOffset = this.getRandomizeCallEndOffset((IHidObject)randomizeAccess, randomizeHid, document);
        int startOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ";", randomizeCallEndOffset, document.getLength(), false);
        String beforeIndentation = VerissimoAutofixEditsUtils.INSTANCE.getIndent(assignmentHid.getOpenBoundary(), document);
        InsertEditParameters variableCheckEdit = new InsertEditParameters(this, startOffset, this.getRandomizeCheck(variableName, beforeIndentation, ""), "\n" + beforeIndentation, "");
        edits.add(variableCheckEdit);
        return edits;
    }

    private List<EditParameters> extractRandomizeCallToVariable(RfNamedElement scopeElement, RfHid functionCallHid, RfHidAccess randomizeHidAccess, RfHid randomizeHid, IDocument document, IFile file) {
        ListContainer accesses;
        String indentation;
        int startOffset;
        ArrayList<EditParameters> allEdits;
        String variableName;
        block9: {
            block8: {
                variableName = VerissimoAutofixEditsUtils.INSTANCE.getNewVariableNameInScope("randomize_result", scopeElement, this.variableIndexInScopeMap);
                if (variableName != null) break block8;
                return null;
            }
            allEdits = new ArrayList<EditParameters>();
            List<EditParameters> beginEndEdits = VerissimoAutofixEditsUtils.INSTANCE.insertBeginEndForActionBlock(scopeElement, document, this);
            if (beginEndEdits != null && !beginEndEdits.isEmpty()) {
                allEdits.addAll(beginEndEdits);
            }
            startOffset = VerissimoAutofixEditsUtils.INSTANCE.getContentStartOffsetInsideScope(scopeElement, document);
            indentation = String.valueOf(DVTDocumentUtils.getIndent((int)startOffset, (IDocument)document)) + "\t";
            InsertEditParameters variableDeclarationEdit = new InsertEditParameters(this, startOffset, this.getVariableDeclaration(variableName), "\n" + indentation, "");
            variableDeclarationEdit.setEditPriority(EditParameters.PRIORITY.VARIABLE_DECLARATION);
            allEdits.add(variableDeclarationEdit);
            accesses = functionCallHid.getAccesses();
            if (accesses != null) break block9;
            return null;
        }
        try {
            boolean found = false;
            block4: for (HidAccess currentAccess : accesses) {
                List<? extends IHidObject> argumentValues;
                if (found) break;
                if (!(currentAccess instanceof RfHidAccessArgs) || (argumentValues = ((RfHidAccessArgs)currentAccess).getArgumentValues()) == null || argumentValues.isEmpty()) continue;
                for (IHidObject iHidObject : argumentValues) {
                    IHidObject rightOperand;
                    if (!(iHidObject instanceof RfHidOperator) || !(rightOperand = (IHidObject)((RfHidOperator)iHidObject).getRHValues().get(0)).equals((Object)randomizeHidAccess) && !rightOperand.equals((Object)randomizeHid)) continue;
                    int randomizeCallStartOffset = this.getRandomizeCallStartOffset(rightOperand);
                    int randomizeCallEndOffset = this.getRandomizeCallEndOffset(rightOperand, randomizeHid, document);
                    String randomizeCall = document.get(randomizeCallStartOffset, randomizeCallEndOffset - randomizeCallStartOffset);
                    startOffset = ((RfHidOperator)iHidObject).getOpenBoundary();
                    int endOffset = ((RfHidOperator)iHidObject).getCloseBoundary();
                    ReplaceEditParameters replaceFunctionCallWithVariableEdit = new ReplaceEditParameters(this, startOffset, endOffset - startOffset, variableName);
                    allEdits.add(replaceFunctionCallWithVariableEdit);
                    startOffset = functionCallHid.getOccurrence().getOffset();
                    RfFunctionCall firstFunctionCall = this.getFirstFunctionCall(scopeElement, randomizeCall);
                    if (firstFunctionCall != null) {
                        startOffset = firstFunctionCall.getStartOffset();
                    }
                    startOffset = VerissimoAutofixEditsUtils.INSTANCE.getEndOffsetOfPreviousStatement(this.getRfProject(), file, document, startOffset, true);
                    InsertEditParameters assignToVariableEdit = new InsertEditParameters(this, startOffset, String.valueOf(variableName) + " = " + randomizeCall + ";", "\n" + indentation, "\n" + indentation);
                    InsertEditParameters checkVariableEdit = new InsertEditParameters(this, startOffset, this.getRandomizeCheck(variableName, indentation, ""));
                    allEdits.add(assignToVariableEdit);
                    allEdits.add(checkVariableEdit);
                    found = true;
                    continue block4;
                }
            }
            return allEdits;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private List<EditParameters> surroundWithIfCheck(RfNamedElement scope, RfHid parentHid, RfHid randomizeHid, RfHidAccessArgs randomizeHidAccess, IDocument document, boolean allowTempVariable, OVMComplianceCheckHit hit) {
        ScopeVisitor visitor;
        Object[] previousCodeToken;
        int startOffset;
        int randomizeHidStartOffset;
        ArrayList<EditParameters> allEdits;
        block14: {
            boolean shouldDeclareVariable;
            block13: {
                try {
                    allEdits = new ArrayList<EditParameters>();
                    if (scope == null || randomizeHid == null) {
                        return allEdits;
                    }
                    if (parentHid != null) {
                        randomizeHidStartOffset = parentHid.getOccurrence().getOffset();
                        HidAccess parentAccess = parentHid.getParentAccess();
                        while (parentAccess != null) {
                            randomizeHidStartOffset = parentAccess.getOccurrence().getOffset();
                            HidAccess hidAccess = parentAccess = parentAccess.getParentHid() != null ? parentAccess.getParentHid().getParentAccess() : null;
                        }
                    } else {
                        randomizeHidStartOffset = randomizeHid.getOccurrence().getOffset();
                    }
                    startOffset = randomizeHidStartOffset;
                    previousCodeToken = VerissimoAutofixEditsUtils.INSTANCE.getPreviousTextToken(document, startOffset, true);
                    if (this.checkIfPrecededByVoidOrAssert(scope, previousCodeToken, randomizeHidStartOffset, allEdits, document)) {
                        return allEdits;
                    }
                    visitor = new ScopeVisitor(randomizeHidAccess);
                    scope.visitHidObject(null, visitor);
                    if (!visitor.badFormattingVoidOrAssert) break block13;
                    this.addUnfixableError(hit, VOID_OR_ASSERT_FORMATTING_ERROR);
                    return null;
                }
                catch (BadLocationException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            boolean bl = shouldDeclareVariable = visitor.shouldDeclareVariable || "return".equals(previousCodeToken[1]);
            if (!shouldDeclareVariable) {
                List<EditParameters> beginEndEdits;
                if (scope instanceof RfActionBlock && (((RfActionBlock)scope).isCaseItem() || ((RfActionBlock)scope).isDoWhile()) && (beginEndEdits = VerissimoAutofixEditsUtils.INSTANCE.insertBeginEndForActionBlock(scope, document, this)) != null && !beginEndEdits.isEmpty()) {
                    allEdits.addAll(beginEndEdits);
                }
                int randomizeCallEndOffset = this.getRandomizeCallEndOffset((IHidObject)randomizeHidAccess, randomizeHid, document);
                int endOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ";", randomizeCallEndOffset, document.getLength(), false);
                String randomizeCall = document.get(startOffset, randomizeCallEndOffset - startOffset);
                String replacementString = this.getRandomizeCheck(randomizeCall, VerissimoAutofixEditsUtils.INSTANCE.getIndent(startOffset, document), "");
                allEdits.add(new ReplaceEditParameters(this, startOffset, endOffset - startOffset, replacementString));
                return allEdits;
            }
            if (allowTempVariable) break block14;
            this.addUnfixableError(hit, ENABLE_ALLOW_TEMP_VARIABLE_ERROR);
            return null;
        }
        if ("return".equals(previousCodeToken[1]) && !visitor.shouldDeclareVariable) {
            boolean requiresBeginEnd;
            List<EditParameters> beginEndEdits = VerissimoAutofixEditsUtils.INSTANCE.insertBeginEndForActionBlock(scope, document, this);
            boolean bl = requiresBeginEnd = beginEndEdits != null && !beginEndEdits.isEmpty();
            if (requiresBeginEnd) {
                allEdits.addAll(beginEndEdits);
            }
            int scopeStartOffset = VerissimoAutofixEditsUtils.INSTANCE.getContentStartOffsetInsideScope(scope, document);
            String variableName = VerissimoAutofixEditsUtils.INSTANCE.getNewVariableNameInScope("randomize_result", scope, this.variableIndexInScopeMap);
            String indent = String.valueOf(VerissimoAutofixEditsUtils.INSTANCE.getIndent(scopeStartOffset, document)) + "\t";
            String beforeIndentation = "\n" + indent;
            String afterIndentation = "";
            InsertEditParameters variableDeclarationEdit = new InsertEditParameters(this, scopeStartOffset, this.getVariableDeclaration(variableName), beforeIndentation, afterIndentation);
            variableDeclarationEdit.setEditPriority(EditParameters.PRIORITY.VARIABLE_DECLARATION);
            allEdits.add(variableDeclarationEdit);
            startOffset = (Integer)previousCodeToken[0];
            ReplaceEditParameters assignToVariableEdit = new ReplaceEditParameters(this, startOffset, "return".length(), String.valueOf(variableName) + " =");
            allEdits.add(assignToVariableEdit);
            startOffset = this.getRandomizeCallEndOffset((IHidObject)randomizeHidAccess, randomizeHid, document);
            startOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ";", startOffset, document.getLength(), false);
            String indentation = VerissimoAutofixEditsUtils.INSTANCE.getIndent(randomizeHidStartOffset, document);
            InsertEditParameters checkVariableEdit = new InsertEditParameters(this, startOffset, this.getRandomizeCheck(variableName, indentation, "\n"), "\n" + indentation, "");
            InsertEditParameters returnEdit = new InsertEditParameters(this, startOffset, "return " + variableName + ";", indentation, "");
            allEdits.add(checkVariableEdit);
            allEdits.add(returnEdit);
            return allEdits;
        }
        return allEdits;
    }

    private boolean checkIfPrecededByVoidOrAssert(RfNamedElement scope, Object[] previousCodeToken, int randomizeHidStartOffset, List<EditParameters> allEdits, IDocument document) {
        try {
            String call;
            String callKeyword = scope instanceof RfAssertExpect ? "assert" : "void";
            boolean isVoidOrAssert = "assert(".equals(previousCodeToken[1]) || "void'(".equals(previousCodeToken[1]);
            int startOffset = (Integer)previousCodeToken[0];
            int endOffset = startOffset + ((String)previousCodeToken[1]).length();
            String string = call = scope instanceof RfAssertExpect ? "assert(" : "void'(";
            if (!isVoidOrAssert) {
                if ("'(".equals(previousCodeToken[1])) {
                    Object[] previousPreviousCodeToken = VerissimoAutofixEditsUtils.INSTANCE.getPreviousTextToken(document, (Integer)previousCodeToken[0], true);
                    if (callKeyword.equals(previousPreviousCodeToken[1])) {
                        startOffset = (Integer)previousPreviousCodeToken[0];
                        isVoidOrAssert = true;
                        call = document.get(startOffset, endOffset - startOffset);
                    }
                } else if ("(".equals(previousCodeToken[1])) {
                    Object[] previousPreviousCodeToken = VerissimoAutofixEditsUtils.INSTANCE.getPreviousTextToken(document, (Integer)previousCodeToken[0], true);
                    if (callKeyword.equals(previousPreviousCodeToken[1]) || (String.valueOf(callKeyword) + "'").equals(previousPreviousCodeToken[1])) {
                        startOffset = (Integer)previousPreviousCodeToken[0];
                        isVoidOrAssert = true;
                        call = document.get(startOffset, endOffset - startOffset);
                    } else if ("'".equals(previousPreviousCodeToken[1]) && "void".equals((previousPreviousCodeToken = VerissimoAutofixEditsUtils.INSTANCE.getPreviousTextToken(document, (Integer)previousPreviousCodeToken[0], true))[1])) {
                        startOffset = (Integer)previousPreviousCodeToken[0];
                        isVoidOrAssert = true;
                        call = document.get(startOffset, endOffset - startOffset);
                    }
                }
            }
            if (isVoidOrAssert) {
                this.convertCallToIf(call, startOffset, randomizeHidStartOffset, allEdits, document);
                return true;
            }
            return false;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private void convertCallToIf(String call, int startOffset, int randomizeHidStartOffset, List<EditParameters> allEdits, IDocument document) {
        ReplaceEditParameters replaceCallWithIfEdit = new ReplaceEditParameters(this, startOffset, call.length(), "if (!");
        allEdits.add(replaceCallWithIfEdit);
        int rightParanthesis = VerissimoAutofixEditsUtils.INSTANCE.getMatchingRightParenthesesOffset(document, startOffset + call.length(), document.getLength());
        int endOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ";", rightParanthesis, document.getLength(), false);
        String indentation = VerissimoAutofixEditsUtils.INSTANCE.getIndent(randomizeHidStartOffset, document);
        ReplaceEditParameters addErrorEdit = new ReplaceEditParameters(this, rightParanthesis, endOffset - rightParanthesis, ")\n" + indentation + "\t" + UVM_ERROR);
        allEdits.add(addErrorEdit);
    }

    private String getVariableName(RfHidOperator assignmentHid) {
        IHidObject leftValue = assignmentHid.getLHValue();
        if (leftValue instanceof RfHidImplicit) {
            return ((RfHidImplicit)leftValue).getName();
        }
        if (leftValue instanceof RfHid) {
            return ((RfHid)assignmentHid.getLHValue()).getName();
        }
        return null;
    }

    private int getRandomizeCallStartOffset(IHidObject hidObject) {
        Hid parentHid = null;
        if (hidObject instanceof RfHid) {
            parentHid = ((RfHid)hidObject).getParentHid();
        } else if (hidObject instanceof RfHidAccess) {
            parentHid = ((RfHidAccess)hidObject).getParentHid();
        }
        if (parentHid == null) {
            return -1;
        }
        int startOffset = parentHid.getOccurrence().getOffset();
        HidAccess parentAccess = parentHid.getParentAccess();
        while (parentAccess != null) {
            startOffset = parentAccess.getOccurrence().getOffset();
            HidAccess hidAccess = parentAccess = parentAccess.getParentHid() != null ? parentAccess.getParentHid().getParentAccess() : null;
        }
        return startOffset;
    }

    private int getRandomizeCallEndOffset(IHidObject randomizeHidAccess, RfHid randomizeHid, IDocument document) {
        if (!(randomizeHidAccess instanceof RfHidAccessArgs)) {
            return VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, randomizeHid.getName(), randomizeHid.getOccurrence().getOffset(), document.getLength(), false);
        }
        RfHidAccessArgs randomizeHidAccessArgs = (RfHidAccessArgs)randomizeHidAccess;
        HidOperator withClause = randomizeHidAccessArgs.getWithClause();
        if (withClause != null) {
            return withClause.getCloseBoundary();
        }
        return VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ")", randomizeHidAccessArgs.getOccurrence().getOffset(), document.getLength(), false);
    }

    private String getVariableDeclaration(String variableName) {
        return "int " + variableName + ";";
    }

    private String getRandomizeCheck(String randomizeCallOrVariable, String beforeIndentation, String afterIndentation) {
        StringBuilder textToInsert = new StringBuilder();
        textToInsert.append("if (!").append(randomizeCallOrVariable).append(")\n").append(beforeIndentation).append("\t").append(UVM_ERROR).append(afterIndentation);
        return textToInsert.toString();
    }

    private void addUnfixableError(OVMComplianceCheckHit hit, String additionInfo) {
        VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
        error.setAdditionalInformation(additionInfo);
        this.addError(error);
    }

    @Override
    public String computeReplacementString(ReplaceEditParameters replaceEdit) {
        String replaceText = replaceEdit.getReplacementDefault();
        if (replaceText.contains(UVM_ERROR)) {
            replaceText = replaceText.replace("\\{uvmErrorId\\}", this.uvmErrorId);
            replaceText = replaceText.replace("\\{uvmErrorMessage\\}", this.uvmErrorMessage);
        }
        return replaceText;
    }

    @Override
    public String computeReplacementString(InsertEditParameters insertEdit) {
        String insertText = insertEdit.getTextDefault();
        if (insertText.contains(UVM_ERROR)) {
            insertText = insertText.replace("\\{uvmErrorId\\}", this.uvmErrorId);
            insertText = insertText.replace("\\{uvmErrorMessage\\}", this.uvmErrorMessage);
        }
        return insertText;
    }

    class ScopeVisitor
    implements IHidVisitor<IHidObject> {
        boolean shouldDeclareVariable;
        boolean badFormattingVoidOrAssert;
        RfHidAccessArgs randomizeCall;
        RfNamedElement scope;

        public ScopeVisitor(RfHidAccessArgs randomizeCall) {
            this.randomizeCall = randomizeCall;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public boolean visit(IHidObject hidObject) {
            if (hidObject instanceof RfHidOperator) {
                RfHidOperator operator = (RfHidOperator)hidObject;
                if (this.randomizeCall == operator.getLHValue()) {
                    if (this.scope instanceof RfAssertExpect || operator.isVoidCast()) {
                        this.badFormattingVoidOrAssert = true;
                    } else {
                        this.shouldDeclareVariable = true;
                    }
                    return true;
                }
                ListContainer rightValues = operator.getRHValues();
                if (rightValues == null) {
                    return true;
                }
                IHidObject rightValue = (IHidObject)operator.getRHValues().get(0);
                if (this.randomizeCall == rightValue) {
                    IHidObject left = operator.getLHValue();
                    if (left instanceof RfHid && ((RfHid)left).getName().equals("(-2)")) {
                        return true;
                    }
                    if (left instanceof RfHidImplicit && operator.isReturnStatement()) {
                        return true;
                    }
                    this.shouldDeclareVariable = true;
                    return true;
                }
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

