/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroZone;

public class Autofix_SVTB_15_5_1
extends VerissimoAutofix {
    protected static final String LOCAL = "local";
    protected static final String PROTECTED = "protected";

    public Autofix_SVTB_15_5_1(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (autofixAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            Object element = autofixAdditionalInfo.getElement();
            if (!(element instanceof RfNamedElement)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            RfNamedElement field = (RfNamedElement)element;
            RfDefElement fieldDeclaration = field.getDeclaration();
            String oldPrivacy = this.getOldPrivacy(field);
            int startOffset = -1;
            int endOffset = -1;
            if (fieldDeclaration.getReparseInfo() == null) {
                int declarationOffset = fieldDeclaration.getStartOffset();
                startOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, oldPrivacy, 0, declarationOffset - 1, false, false);
                endOffset = startOffset + oldPrivacy.length();
            } else {
                String macroName = fieldDeclaration.getReparseInfo().getLastReparseMacroName();
                VlogMacroZone macroZone = field.getMacroZone();
                if (macroZone == null) continue;
                VlogMacroInfo functionDeclMacro = macroZone.getMacroInfo(macroName);
                endOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, oldPrivacy, functionDeclMacro.getRealOffset(), document.getLength(), false);
                startOffset = endOffset - oldPrivacy.length();
            }
            if (startOffset == -1 || endOffset == -1) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            DeleteEditParameters edit = new DeleteEditParameters(this, startOffset, endOffset - startOffset);
            this.addEditForHit(hit, file, edit);
        }
    }

    protected String getOldPrivacy(RfNamedElement field) {
        if (field.isProtected()) {
            return PROTECTED;
        }
        if (field.isPrivate()) {
            return LOCAL;
        }
        return "";
    }
}

