/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.linter.svtb.Check_SVTB_15_7_1;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.parser.ReparseInfo;

public class Autofix_SVTB_15_7_1
extends VerissimoAutofix {
    private Set<OVMComplianceCheckHit> unfixableHits;
    private Set<RfFunctionCall> fixedFunctionCalls = new HashSet<RfFunctionCall>();
    private Set<RfNamedElement> visitedFunctions;
    private Map<RfNamedElement, String> processVariables;
    private Map<RfNamedElement, String> randVariables;
    private Map<RfNamedElement, Map<String, Integer>> variableIndexInScopeMap;
    private final boolean skipXVMMethods;
    private static final String NEW = "new";
    private static final String GET_RANDSTATE = "get_randstate";
    private static final String SET_RANDSTATE = "set_randstate";
    private static final String PROCESS_NAME = "proc";
    private static final String RANDSTATE_NAME = "proc_rand";

    public Autofix_SVTB_15_7_1(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
        this.unfixableHits = new HashSet<OVMComplianceCheckHit>();
        this.variableIndexInScopeMap = new HashMap<RfNamedElement, Map<String, Integer>>();
        this.visitedFunctions = new HashSet<RfNamedElement>();
        this.processVariables = new HashMap<RfNamedElement, String>();
        this.randVariables = new HashMap<RfNamedElement, String>();
        this.skipXVMMethods = VerissimoAutofixUtils.getInstance().getParameterValueAsBoolean(check, "skipXVMMethods");
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        for (OVMComplianceCheckHit hit : hits) {
            VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
            if (!(additionalInfo.getElement() instanceof RfFunction)) {
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                this.addError(error);
                continue;
            }
            RfFunction parentFunction = (RfFunction)additionalInfo.getElement();
            if (this.visitedFunctions.contains(parentFunction)) continue;
            this.visitedFunctions.add(parentFunction);
            List<RfFunctionCall> allCalls = parentFunction.getFunctionCallsWithPrefix("", 2);
            if (allCalls == null || allCalls.isEmpty()) continue;
            ArrayList<RfFunctionCall> filteredCalls = new ArrayList<RfFunctionCall>(allCalls.size());
            for (RfFunctionCall call : allCalls) {
                String name;
                RfFunction func = call.getFunction();
                if (func == null || !SET_RANDSTATE.equals(name = func.getName()) && !GET_RANDSTATE.equals(name) && !NEW.equals(name)) continue;
                filteredCalls.add(call);
            }
            filteredCalls.sort(new Comparator<RfFunctionCall>(){

                @Override
                public int compare(RfFunctionCall call1, RfFunctionCall call2) {
                    return call1.getStartOffset() - call2.getStartOffset();
                }
            });
            List<IRfFieldElement> parentFunctionArguments = parentFunction.getArguments();
            int index = 0;
            while (index < filteredCalls.size()) {
                RfFunctionCall call = (RfFunctionCall)filteredCalls.get(index);
                RfFunction func = call.getFunction();
                if (func != null && NEW.equals(func.getName()) && Check_SVTB_15_7_1.checkFunctionCall(this.getCheck().getOVMProject(), this.skipXVMMethods, call)) {
                    RfFunctionCall nextCall;
                    RfFunctionCall previousCall = index > 0 ? (RfFunctionCall)filteredCalls.get(index - 1) : null;
                    RfFunctionCall rfFunctionCall = nextCall = index < filteredCalls.size() - 1 ? (RfFunctionCall)filteredCalls.get(index + 1) : null;
                    if (previousCall == null || nextCall == null || !GET_RANDSTATE.equals(previousCall.getFunction().getName()) || !SET_RANDSTATE.equals(nextCall.getFunction().getName())) {
                        this.fixNewFunctionCall(hit, call, parentFunction, parentFunctionArguments);
                    }
                }
                ++index;
            }
        }
    }

    private void fixNewFunctionCall(OVMComplianceCheckHit hit, RfFunctionCall functionCall, RfFunction parentFunction, List<? extends IRfNamedElement> parentFunctionArguments) {
        if (this.fixedFunctionCalls.contains(functionCall)) {
            return;
        }
        ReparseInfo reparseInfo = functionCall.getDeclaration().getReparseInfo();
        if (reparseInfo != null) {
            if (this.unfixableHits.contains(hit)) {
                return;
            }
            VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
            error.setReason("function '" + functionCall.getName() + "' is called inside macro '" + reparseInfo.getLastReparseMacroName() + "'");
            this.addError(error);
            this.unfixableHits.add(hit);
            return;
        }
        RfNamedElement enclosingScope = functionCall.getEnclosingScope();
        ParserPath parserPath = functionCall.getDeclaration().getParserPath();
        IFile newCallFile = VerissimoAutofixUtils.getInstance().getFile(this.getIProject(), parserPath);
        IDocument newCallDocument = VerissimoAutofixUtils.getInstance().getDocument(this.getIProject(), parserPath);
        String lineIndent = VerissimoAutofixEditsUtils.INSTANCE.getIndentOfLine(functionCall.getLine() - 1, newCallDocument);
        int lastVariableDeclarationEndOffset = VerissimoAutofixEditsUtils.INSTANCE.getEndOffsetOfLastVariableDeclarationInScope(enclosingScope, newCallDocument);
        if (functionCall.getLeftHid() instanceof RfHidImplicit) {
            String getRandstateVariableName;
            String processVariableName;
            DeclarationAssignVisitor visitor = new DeclarationAssignVisitor(functionCall);
            enclosingScope.visitHidObject(null, (IHidVisitor<?>)visitor);
            if (visitor.checkIfDependingVariables()) {
                if (this.unfixableHits.contains(hit)) {
                    return;
                }
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                error.setReason("there are variables (" + visitor.getDependingVariables() + ") which depend on the initialization of '" + functionCall.getLeftHid().toString() + "'");
                this.addError(error);
                this.unfixableHits.add(hit);
                return;
            }
            if (parentFunction.equals(enclosingScope) && this.checkIfCollidesWithFunctionArguments(functionCall.getLeftHid().toString(), parentFunctionArguments)) {
                if (this.unfixableHits.contains(hit)) {
                    return;
                }
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                error.setReason("there is a name collision between variable '" + functionCall.getLeftHid().toString() + "' and the function argument '" + functionCall.getLeftHid().toString() + "'");
                this.addError(error);
                this.unfixableHits.add(hit);
                return;
            }
            int startOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(newCallDocument, "=", functionCall.getStartOffset(), functionCall.getEndOffset(), false);
            int nextCommaOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(newCallDocument, ",", functionCall.getEndOffset(), newCallDocument.getLength(), false);
            int nextSemicolonOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(newCallDocument, ";", functionCall.getEndOffset(), newCallDocument.getLength(), false);
            int endOffset = Math.min(nextCommaOffset, nextSemicolonOffset);
            DeleteEditParameters edit1 = new DeleteEditParameters(this, startOffset - 1, endOffset - startOffset);
            this.addEditForHit(hit, newCallFile, edit1);
            String newAssignment = "";
            try {
                newAssignment = newCallDocument.get(startOffset - 1, endOffset - startOffset);
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            if (this.shouldDeclareVariable(enclosingScope)) {
                processVariableName = VerissimoAutofixEditsUtils.INSTANCE.getNewVariableNameInScope(PROCESS_NAME, enclosingScope, this.variableIndexInScopeMap);
                this.processVariables.put(enclosingScope, processVariableName);
                getRandstateVariableName = VerissimoAutofixEditsUtils.INSTANCE.getNewVariableNameInScope(RANDSTATE_NAME, enclosingScope, this.variableIndexInScopeMap);
                this.randVariables.put(enclosingScope, getRandstateVariableName);
                String declareVariableText = String.valueOf(this.getProcessDeclaration(processVariableName)) + "\n" + lineIndent + this.getStringDeclaration(getRandstateVariableName);
                InsertEditParameters edit2 = new InsertEditParameters(this, lastVariableDeclarationEndOffset, declareVariableText, "\n" + lineIndent, null);
                edit2.setEditPriority(EditParameters.PRIORITY.VARIABLE_DECLARATION);
                this.addEditForHit(hit, newCallFile, edit2);
            } else {
                processVariableName = this.processVariables.get(enclosingScope);
                getRandstateVariableName = this.randVariables.get(enclosingScope);
            }
            InsertEditParameters edit3 = new InsertEditParameters(this, lastVariableDeclarationEndOffset, this.assignGetRandstate(processVariableName, getRandstateVariableName), "\n" + lineIndent, null);
            this.addEditForHit(hit, newCallFile, edit3);
            InsertEditParameters edit4 = new InsertEditParameters(this, lastVariableDeclarationEndOffset, String.valueOf(functionCall.getLeftHid().toString()) + " " + newAssignment + ";", "\n" + lineIndent, null);
            this.addEditForHit(hit, newCallFile, edit4);
            InsertEditParameters edit5 = new InsertEditParameters(this, lastVariableDeclarationEndOffset, this.setRandstate(processVariableName, getRandstateVariableName), "\n" + lineIndent, null);
            this.addEditForHit(hit, newCallFile, edit5);
        } else {
            String getRandstateVariableName;
            String processVariableName;
            List<EditParameters> beginEndEdits = VerissimoAutofixEditsUtils.INSTANCE.insertBeginEndForActionBlock(enclosingScope, newCallDocument, this);
            if (beginEndEdits != null) {
                this.addEditsForHit(hit, newCallFile, beginEndEdits);
            }
            if (this.shouldDeclareVariable(enclosingScope)) {
                processVariableName = VerissimoAutofixEditsUtils.INSTANCE.getNewVariableNameInScope(PROCESS_NAME, enclosingScope, this.variableIndexInScopeMap);
                this.processVariables.put(enclosingScope, processVariableName);
                getRandstateVariableName = VerissimoAutofixEditsUtils.INSTANCE.getNewVariableNameInScope(RANDSTATE_NAME, enclosingScope, this.variableIndexInScopeMap);
                this.randVariables.put(enclosingScope, getRandstateVariableName);
                String declareVariableText = String.valueOf(this.getProcessDeclaration(processVariableName)) + "\n" + lineIndent + this.getStringDeclaration(getRandstateVariableName);
                InsertEditParameters edit1 = new InsertEditParameters(this, lastVariableDeclarationEndOffset, declareVariableText, "\n" + lineIndent, null);
                edit1.setEditPriority(EditParameters.PRIORITY.VARIABLE_DECLARATION);
                this.addEditForHit(hit, newCallFile, edit1);
            } else {
                processVariableName = this.processVariables.get(enclosingScope);
                getRandstateVariableName = this.randVariables.get(enclosingScope);
            }
            int startOffset = VerissimoAutofixEditsUtils.INSTANCE.getEndOffsetOfPreviousStatement(this.getRfProject(), newCallFile, newCallDocument, functionCall.getStartOffset(), true);
            InsertEditParameters edit2 = new InsertEditParameters(this, startOffset, this.assignGetRandstate(processVariableName, getRandstateVariableName), "\n" + lineIndent, null);
            this.addEditForHit(hit, newCallFile, edit2);
            startOffset = VerissimoAutofixEditsUtils.INSTANCE.getStartOffsetOfNextStatement(newCallDocument, functionCall.getEndOffset());
            InsertEditParameters edit3 = new InsertEditParameters(this, startOffset, this.setRandstate(processVariableName, getRandstateVariableName), "\n" + lineIndent, null);
            this.addEditForHit(hit, newCallFile, edit3);
        }
        this.fixedFunctionCalls.add(functionCall);
    }

    private String getProcessDeclaration(String variableName) {
        return "process " + variableName + " = process::self();";
    }

    private String getStringDeclaration(String variableName) {
        return "string " + variableName + ";";
    }

    private String assignGetRandstate(String processVariableName, String getRandstateVariableName) {
        return "if (" + processVariableName + " != null) " + getRandstateVariableName + " = " + processVariableName + ".get_randstate();";
    }

    private String setRandstate(String processVariableName, String getRandstateVariableName) {
        return "if (" + processVariableName + " != null) " + processVariableName + ".set_randstate(" + getRandstateVariableName + ");";
    }

    private boolean shouldDeclareVariable(RfNamedElement scope) {
        return !this.processVariables.containsKey(scope) || !this.randVariables.containsKey(scope);
    }

    private boolean checkIfCollidesWithFunctionArguments(String variableName, List<? extends IRfNamedElement> functionArguments) {
        if (functionArguments == null || functionArguments.isEmpty() || variableName == null) {
            return false;
        }
        for (IRfNamedElement iRfNamedElement : functionArguments) {
            if (!variableName.equals(iRfNamedElement.getName())) continue;
            return true;
        }
        return false;
    }

    private static class DeclarationAssignVisitor
    extends HidOperatorVisitor {
        private Set<String> dependingVariables = new HashSet<String>();
        private RfNamedElement variable;

        public DeclarationAssignVisitor(RfFunctionCall newFunctionCall) {
            super(new HidOperatorQualifier[]{HidOperatorQualifier.IS_DECLARATION_ASSIGN});
            this.variable = newFunctionCall.getLeftValue();
        }

        public boolean visit(HidOperator operator) {
            if (!operator.hasQualifier(HidOperatorQualifier.IS_DECLARATION_ASSIGN.value())) {
                return true;
            }
            Set rightHids = operator.getRHHids(HidFlatteningOption.IMPLICITS_EXCLUDED);
            if (rightHids == null) {
                return true;
            }
            for (IHid hid : rightHids) {
                if (!(hid instanceof RfHid) || !this.variable.equals(hid.getElement())) continue;
                this.dependingVariables.add(HidUtils.toString((IHidObject)operator.getLHValue(), (boolean)false, (boolean)false));
                return true;
            }
            return true;
        }

        public boolean checkIfDependingVariables() {
            return !this.dependingVariables.isEmpty();
        }

        public String getDependingVariables() {
            return String.join((CharSequence)", ", this.dependingVariables);
        }
    }
}

