/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.UserInputAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.base.annotations.AutofixParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;

public class Autofix_SVTB_1_1_1
extends UserInputAutofix {
    @AutofixParameter(defaultValue="4", description="Number of spaces to be used for each tab.", name="tabSize", guiPrompt="Number of spaces to be used for each tab:", type=CheckParameterType.INTEGER)
    public int tabSize;
    @AutofixParameter(defaultValue="false", description="When true, tabs will be expanded to the displayed tab width. When false, tabs will be replaced with the fixed <tabSize> number of spaces.", name="expandToDisplayedTabWidth", guiPrompt="When true, tabs will be expanded to the displayed tab width.\nWhen false, tabs will be replaced with the fixed <tabSize> number of spaces.", type=CheckParameterType.BOOLEAN)
    public boolean expandToDisplayedTabWidth;

    public Autofix_SVTB_1_1_1(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        try {
            if (hits == null || hits.isEmpty()) {
                return;
            }
            for (OVMComplianceCheckHit hit : hits) {
                int hitLine = hit.getLine() - 1;
                int startOffset = document.getLineOffset(hitLine);
                int length = document.getLineLength(hitLine) - 1;
                if (hitLine == document.getNumberOfLines() - 1) {
                    ++length;
                }
                if (startOffset < 0 || length <= 0) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                ReplaceEditParameters edit = new ReplaceEditParameters(this, startOffset, length, document.get(startOffset, length), null);
                this.addEditForHit(hit, file, edit);
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public String computeReplacementString(ReplaceEditParameters replaceEdit) {
        String initialLine = replaceEdit.getInitial();
        if (this.expandToDisplayedTabWidth) {
            StringBuilder resultString = new StringBuilder("");
            int offset = 0;
            int i = 0;
            while (i < initialLine.length()) {
                if (initialLine.charAt(i) == '\t') {
                    int remaining = this.tabSize - offset % this.tabSize;
                    resultString.append(StringUtils.repeat((String)" ", (int)remaining));
                    offset += remaining;
                } else {
                    resultString.append(initialLine.charAt(i));
                    ++offset;
                }
                ++i;
            }
            return resultString.toString();
        }
        String replacement = StringUtils.repeat((String)" ", (int)this.tabSize);
        return DVTStringUtil.replaceAll((Pattern)DVTStringUtil.TAB, (CharSequence)replaceEdit.getInitial(), (String)replacement);
    }

    @Override
    protected String checkUserInput() {
        if (this.tabSize <= 0) {
            return "Tab size must be greater than 0.";
        }
        return null;
    }
}

