/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.linter.svtb.Check_SVTB_1_1_10;

public class Autofix_SVTB_1_1_10
extends VerissimoAutofix {
    private boolean allowMultipleSpaces;
    private boolean allowIndentationOfMultilineOperators;
    private static final Pattern MULTIPLE_SPACES = Pattern.compile("( )+");
    private Map<ParserPath, Set<Integer>> fixedOffsets;

    public Autofix_SVTB_1_1_10(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
        this.allowMultipleSpaces = VerissimoAutofixUtils.getInstance().getParameterValueAsBoolean(check, "allowMultipleSpaces");
        this.allowIndentationOfMultilineOperators = VerissimoAutofixUtils.getInstance().getParameterValueAsBoolean(check, "allowIndentationOfMultilineOperators");
        this.fixedOffsets = new HashMap<ParserPath, Set<Integer>>();
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        this.fixedOffsets.clear();
        try {
            if (hits == null || hits.isEmpty()) {
                return;
            }
            for (OVMComplianceCheckHit hit : hits) {
                VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
                if (autofixAdditionalInfo == null) {
                    VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error.setReason("there is incomplete context (IC01)");
                    this.addError(error);
                    continue;
                }
                Object element = autofixAdditionalInfo.getElement();
                if (!(element instanceof Check_SVTB_1_1_10.WrongOperatorInfo)) {
                    VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error.setReason("there is incomplete context (IC02)");
                    this.addError(error);
                    continue;
                }
                Check_SVTB_1_1_10.WrongOperatorInfo wrongOperator = (Check_SVTB_1_1_10.WrongOperatorInfo)element;
                String operatorText = wrongOperator.getOperatorText();
                int operatorOffset = wrongOperator.getFileOffset();
                int startOffsetOperator = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfPreviousNonWhitespaceCharacter(document, operatorOffset - 1);
                int endOffsetOperator = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfNextNonWhitespaceCharacter(document, operatorOffset + operatorText.length());
                if (startOffsetOperator == -1 || endOffsetOperator == -1) {
                    VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error.setReason("there is invalid operator acquire (IOA03)");
                    this.addError(error);
                    continue;
                }
                String operatorTextWithWhitespaces = document.get(startOffsetOperator + 1, endOffsetOperator - startOffsetOperator - 1);
                String replacement = this.convert(operatorText, operatorTextWithWhitespaces);
                if (replacement == null) {
                    VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error.setReason("there is invalid operator edit (IOE04)");
                    this.addError(error);
                    continue;
                }
                ReplaceEditParameters edit = new ReplaceEditParameters(this, startOffsetOperator + 1, endOffsetOperator - startOffsetOperator - 1, replacement);
                this.addEditForHit(hit, file, edit);
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String convert(String operatorText, String operatorTextWithWhitespaces) {
        if (operatorText == null || operatorText.isEmpty()) {
            return null;
        }
        if (operatorTextWithWhitespaces == null || operatorTextWithWhitespaces.isEmpty()) {
            return null;
        }
        int operatorIndex = operatorTextWithWhitespaces.indexOf(operatorText);
        if (operatorIndex == -1) {
            return null;
        }
        String beforeOperator = operatorTextWithWhitespaces.substring(0, operatorIndex);
        String afterOperator = operatorTextWithWhitespaces.substring(operatorIndex + operatorText.length());
        if (this.allowIndentationOfMultilineOperators && !this.allowMultipleSpaces) {
            if (!beforeOperator.contains("\n")) {
                beforeOperator = " ";
            }
            if (!afterOperator.contains("\n")) {
                afterOperator = " ";
            }
            beforeOperator = DVTStringUtil.replaceAll((Pattern)MULTIPLE_SPACES, (CharSequence)beforeOperator, (String)" ");
            afterOperator = DVTStringUtil.replaceAll((Pattern)MULTIPLE_SPACES, (CharSequence)afterOperator, (String)" ");
            return String.valueOf(beforeOperator) + operatorText + afterOperator;
        }
        if (!this.allowIndentationOfMultilineOperators && this.allowMultipleSpaces) {
            return " " + operatorText + " ";
        }
        if (this.allowIndentationOfMultilineOperators && this.allowMultipleSpaces) {
            beforeOperator = beforeOperator.isEmpty() ? " " : beforeOperator;
            afterOperator = afterOperator.isEmpty() ? " " : afterOperator;
            return String.valueOf(beforeOperator) + operatorText + afterOperator;
        }
        return " " + operatorText + " ";
    }
}

