/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;

public class Autofix_SVTB_1_1_11
extends VerissimoAutofix {
    public Autofix_SVTB_1_1_11(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        try {
            if (hits == null || hits.isEmpty()) {
                return;
            }
            for (OVMComplianceCheckHit hit : hits) {
                int endOffset;
                VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
                if (autofixAdditionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                Object element = autofixAdditionalInfo.getElement();
                if (!(element instanceof Integer)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                int offsetOnLine = (Integer)element;
                int hitLine = hit.getLine() - 1;
                int lineLength = document.getLineLength(hitLine);
                int lineStartOffset = document.getLineOffset(hitLine);
                int startOffset = lineStartOffset + offsetOnLine - 1;
                boolean addedEdits = VerissimoAutofixEditsUtils.INSTANCE.parseCodeAndAddEdits(this, hit, file, document, startOffset, endOffset = lineStartOffset + lineLength);
                if (addedEdits) continue;
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public boolean isValidCondition(char previousChar, char currentChar) {
        return previousChar == ',' && currentChar != ' ' && currentChar != '\n' && currentChar != '\r';
    }

    @Override
    public void addEdit(OVMComplianceCheckHit hit, IFile file, int startOffset) {
        this.addEditForHit(hit, file, new InsertEditParameters(this, startOffset, " "));
    }
}

