/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.linter.svtb.Check_SVTB_1_1_12;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfInstanceDef;
import ro.amiq.vlogdt.model.reflection.RfPortDef;

public class Autofix_SVTB_1_1_12
extends VerissimoAutofix {
    public Autofix_SVTB_1_1_12(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            EditParameters edit;
            int[] firstDimensionBounds;
            IndexType firstDimension;
            boolean hasUnpackedDimension;
            VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
            if (additionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            Object defElement = additionalInfo.getElement();
            if (!(defElement instanceof RfDefElement)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            DataType dataType = ((RfDefElement)defElement).getDataType(((RfDefElement)defElement).getNamedElement());
            if (defElement instanceof RfFunctionDef) {
                dataType = ((RfFunctionDef)defElement).getTypeInfo(((RfDefElement)defElement).getNamedElement());
            }
            if (dataType == null) continue;
            boolean hasPackedDimension = dataType.getPackedDimension() != null && !dataType.getPackedDimension().isEmpty();
            boolean bl = hasUnpackedDimension = dataType.getUnpackedDimension() != null && !dataType.getUnpackedDimension().isEmpty();
            if (!hasPackedDimension && !hasUnpackedDimension) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            if (hasPackedDimension && hit.getDetails().contains(" packed ")) {
                IndexType lastDimension;
                int[] lastDimensionBounds;
                List<IndexType> packedDimensions = dataType.getPackedDimension();
                firstDimension = packedDimensions.get(0);
                firstDimensionBounds = firstDimension.getBoundaries();
                if (firstDimensionBounds == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                String spaceBeforeFirstDimension = "true";
                if (hit.getCheck().getProperties().containsKey("allowSpaceBetweenPackedDimensionAndType")) {
                    spaceBeforeFirstDimension = hit.getCheck().getProperty("allowSpaceBetweenPackedDimensionAndType");
                }
                if (spaceBeforeFirstDimension.equals("true")) {
                    int firstWhiteSpaceCharacterOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfPreviousWhitespace(document, firstDimensionBounds[0]);
                    if (firstWhiteSpaceCharacterOffset >= 0 && firstWhiteSpaceCharacterOffset != firstDimensionBounds[0] - 1) {
                        edit = new InsertEditParameters(this, firstDimensionBounds[0], " ", "", "");
                        this.addEditForHit(hit, file, edit);
                    }
                } else {
                    int lastTypeCharacterOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfPreviousNonWhitespaceCharacter(document, firstDimensionBounds[0] - 1) + 1;
                    if (lastTypeCharacterOffset >= 0 && lastTypeCharacterOffset != firstDimensionBounds[0]) {
                        DeleteEditParameters edit2 = new DeleteEditParameters(this, lastTypeCharacterOffset, firstDimensionBounds[0] - lastTypeCharacterOffset);
                        this.addEditForHit(hit, file, edit2);
                    }
                }
                if ((lastDimensionBounds = (lastDimension = packedDimensions.get(packedDimensions.size() - 1)).getBoundaries()) == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                int firstWhiteSpaceCharacterAfterBoundariesOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfNextWhitespace(document, lastDimensionBounds[1]);
                if (firstWhiteSpaceCharacterAfterBoundariesOffset >= 0 && firstWhiteSpaceCharacterAfterBoundariesOffset != lastDimensionBounds[1]) {
                    InsertEditParameters edit3 = new InsertEditParameters(this, lastDimensionBounds[1], " ", "", "");
                    this.addEditForHit(hit, file, edit3);
                }
                this.removeWhiteSpacesBetweenPackedDimensions(file, hit, packedDimensions);
            }
            if (!hasUnpackedDimension || !hit.getDetails().contains(" unpacked ")) continue;
            List<IndexType> unpackedDimensions = dataType.getUnpackedDimension();
            firstDimension = unpackedDimensions.get(0);
            firstDimensionBounds = firstDimension.getBoundaries();
            if (firstDimensionBounds == null) {
                int startOffset;
                int currentOffset = startOffset = ((RfDefElement)defElement).getStartOffset();
                int unpackedOffset = currentOffset + ((RfDefElement)defElement).getName().length();
                int nextCommaOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ",", startOffset - 1, document.getLength(), false);
                int nextSemicolonOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ";", startOffset - 1, document.getLength(), false) - 1;
                int endOffset = ((RfDefElement)defElement).getEndOffset() == startOffset ? Math.min(nextCommaOffset, nextSemicolonOffset) : ((RfDefElement)defElement).getEndOffset();
                int dimensionMinBound = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, "[", unpackedOffset - 1, endOffset + 1, false) - 1;
                if (unpackedOffset < document.getLength() && dimensionMinBound < document.getLength() && dimensionMinBound != endOffset) {
                    DeleteEditParameters edit4 = new DeleteEditParameters(this, unpackedOffset, dimensionMinBound - unpackedOffset);
                    this.addEditForHit(hit, file, edit4);
                }
            } else {
                int dimensionMinBound = firstDimensionBounds[0] - 1;
                int firstNonWhitespaceCharacterOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfPreviousNonWhitespaceCharacter(document, dimensionMinBound);
                if (firstNonWhitespaceCharacterOffset >= 0 && firstNonWhitespaceCharacterOffset != dimensionMinBound) {
                    edit = new DeleteEditParameters(this, firstNonWhitespaceCharacterOffset + 1, dimensionMinBound - firstNonWhitespaceCharacterOffset);
                    this.addEditForHit(hit, file, edit);
                }
            }
            this.removeWhiteSpacesBetweenUnpackedDimensions(document, file, hit, unpackedDimensions, (RfDefElement)defElement);
        }
    }

    private void removeWhiteSpacesBetweenUnpackedDimensions(IDocument document, IFile file, OVMComplianceCheckHit hit, List<IndexType> dimensions, RfDefElement defElement) {
        boolean checkUsingDimensionsOffsets = false;
        for (IndexType dimension : dimensions) {
            if (dimension.getBoundaries() != null) continue;
            checkUsingDimensionsOffsets = true;
            break;
        }
        if (!checkUsingDimensionsOffsets) {
            this.removeWhiteSpacesBetweenPackedDimensions(file, hit, dimensions);
            return;
        }
        try {
            int endOffset;
            int unpackedOffset;
            int startOffset = defElement.getStartOffset();
            if (defElement instanceof RfPortDef) {
                unpackedOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, "[", startOffset - 1, document.getLength(), false) - 1;
                int nextCommaOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ",", startOffset - 1, document.getLength(), false) - 1;
                int nextSemicolonOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ";", startOffset - 1, document.getLength(), false) - 1;
                int prevClosingParan = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, ")", startOffset, nextSemicolonOffset, false) - 1;
                endOffset = Math.min(nextCommaOffset, prevClosingParan);
            } else if (defElement instanceof RfInstanceDef) {
                String fileContent = new String(Files.readAllBytes(Paths.get(hit.getParserPath().path, new String[0])));
                int currentOffset = Check_SVTB_1_1_12.goToInstanceNameOffset(startOffset, fileContent, defElement.getEndOffset());
                unpackedOffset = currentOffset + defElement.getName().length();
                int nextSemicolonOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ";", unpackedOffset - 1, document.getLength(), true) + 1;
                int lastClosingParan = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, ")", unpackedOffset, nextSemicolonOffset, true) + 1;
                endOffset = VerissimoAutofixEditsUtils.INSTANCE.getMatchingLeftParenthesesOffset(document, lastClosingParan - unpackedOffset, unpackedOffset);
            } else {
                unpackedOffset = startOffset + defElement.getName().length();
                int nextSemicolonOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ";", startOffset - 1, document.getLength(), false) - 1;
                endOffset = defElement.getEndOffset() == startOffset ? nextSemicolonOffset : defElement.getEndOffset() + 1;
            }
            if (endOffset > document.getLength()) {
                return;
            }
            int dimensionMinBound = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, "[", unpackedOffset, endOffset + 1, true) - 1;
            while (dimensionMinBound < endOffset) {
                int matchingParenthesesOffset = this.getMatchingRightBracketOffset(document, dimensionMinBound, endOffset + 1) + 1;
                if (matchingParenthesesOffset < endOffset && (dimensionMinBound = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, "[", matchingParenthesesOffset, endOffset + 1, false) - 1) < endOffset) {
                    boolean isCommaBetween;
                    boolean bl = isCommaBetween = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ",", matchingParenthesesOffset, endOffset + 1, false) < dimensionMinBound;
                    if (!isCommaBetween) {
                        if (dimensionMinBound < matchingParenthesesOffset + 1) continue;
                        DeleteEditParameters edit = new DeleteEditParameters(this, matchingParenthesesOffset, dimensionMinBound - matchingParenthesesOffset);
                        this.addEditForHit(hit, file, edit);
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
            this.addError(error);
        }
    }

    private void removeWhiteSpacesBetweenPackedDimensions(IFile file, OVMComplianceCheckHit hit, List<IndexType> dimensions) {
        int index = 0;
        while (index < dimensions.size() - 1) {
            IndexType dimension = dimensions.get(index);
            IndexType nextDimension = dimensions.get(index + 1);
            int[] dimensionBoundaries = dimension.getBoundaries();
            int[] nextDimensionBoundaries = nextDimension.getBoundaries();
            if (dimensionBoundaries == null || nextDimensionBoundaries == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
            } else {
                int editStartOffset = dimensionBoundaries[1];
                int editEndOffset = nextDimensionBoundaries[0];
                if (editStartOffset >= 0 && editEndOffset >= 0) {
                    DeleteEditParameters edit = new DeleteEditParameters(this, editStartOffset, editEndOffset - editStartOffset);
                    this.addEditForHit(hit, file, edit);
                }
            }
            ++index;
        }
    }

    private int getMatchingRightBracketOffset(IDocument document, int leftParanthesesOffset, int maxOffset) {
        int counter = 1;
        int currentOffset = 0;
        try {
            String text = document.get(leftParanthesesOffset + 1, maxOffset - leftParanthesesOffset - 1);
            while (counter > 0 && currentOffset < text.length()) {
                char c;
                String content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", leftParanthesesOffset + currentOffset + 1, false);
                if (!"__dftl_partition_content_type".equals(content)) {
                    ++currentOffset;
                    continue;
                }
                if ((c = text.charAt(currentOffset++)) == '[') {
                    ++counter;
                    continue;
                }
                if (c != ']') continue;
                --counter;
            }
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
        }
        if (counter == 0) {
            return leftParanthesesOffset + currentOffset;
        }
        return -1;
    }
}

