/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;

public class Autofix_SVTB_1_1_14
extends VerissimoAutofix {
    private int maxNofLines;

    public Autofix_SVTB_1_1_14(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
        this.maxNofLines = VerissimoAutofixUtils.getInstance().getParameterValueAsInt(check, "maxNofLines");
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        try {
            if (hits == null || hits.isEmpty()) {
                return;
            }
            for (OVMComplianceCheckHit hit : hits) {
                String lineContent;
                int lastBlankLine = hit.getLine() - 1;
                int endOffset = document.getLineOffset(lastBlankLine) + document.getLineLength(lastBlankLine);
                int firstBlankLine = lastBlankLine;
                while (firstBlankLine - 1 >= 0 && (lineContent = document.get(document.getLineOffset(firstBlankLine - 1), document.getLineLength(firstBlankLine - 1))).trim().isEmpty()) {
                    --firstBlankLine;
                }
                int startOffset = document.getLineOffset(firstBlankLine + this.maxNofLines);
                DeleteEditParameters edit = new DeleteEditParameters(this, startOffset, endOffset - startOffset);
                this.addEditForHit(hit, file, edit);
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

