/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;

public class Autofix_SVTB_1_1_16
extends VerissimoAutofix {
    private int nofSpaces;
    private String baseIndent;

    public Autofix_SVTB_1_1_16(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
        this.nofSpaces = VerissimoAutofixUtils.getInstance().getParameterValueAsInt(check, "nofSpaces");
        this.baseIndent = StringUtils.repeat((String)" ", (int)this.nofSpaces);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        try {
            int hitIdx = 0;
            while (hitIdx < hits.size()) {
                OVMComplianceCheckHit hit = hits.get(hitIdx);
                VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
                if (autofixAdditionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                } else {
                    Object element = autofixAdditionalInfo.getElement();
                    if (!(element instanceof Integer)) {
                        VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                        if (element instanceof String && "pEndingParanthesesOnDifferentLine is True".equals(element)) {
                            error.setReason("autofix is not available when endingParanthesesOnDifferentLine parameter is set to true");
                        }
                        this.addError(error);
                    } else {
                        Integer hitOffset = (int)((Integer)element);
                        Object instantiationLine = autofixAdditionalInfo.getParentElement();
                        if (!(instantiationLine instanceof Integer)) {
                            this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                        } else {
                            int startOffset = document.getLineOffset(hit.getLine() - 1);
                            String hitLineIndent = VerissimoAutofixEditsUtils.INSTANCE.getIndentOfLine(hit.getLine() - 1, document);
                            String parenLineIndent = VerissimoAutofixEditsUtils.INSTANCE.getIndentOfLine((Integer)instantiationLine - 1, document);
                            String newIndent = String.valueOf(parenLineIndent) + this.baseIndent;
                            hitOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, ".", 0, hitOffset, false);
                            int commentEndingOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, "*/", startOffset, hitOffset, false, false, false);
                            if (hit.getLine() == ((Integer)instantiationLine).intValue() || commentEndingOffset > startOffset || hitIdx > 0 || hitLineIndent.equals(newIndent)) {
                                edit = new InsertEditParameters(this, hitOffset, "\n" + newIndent);
                                this.addEditForHit(hit, file, edit);
                            } else {
                                edit = new ReplaceEditParameters(this, startOffset, hitLineIndent.length(), newIndent);
                                this.addEditForHit(hit, file, edit);
                            }
                        }
                    }
                }
                ++hitIdx;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

