/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.utils.LiteralToken;

public class Autofix_SVTB_1_1_19
extends VerissimoAutofix {
    private static final char CLOSE_PARENTHESIS_CHAR = ')';
    private static final char OPEN_PARENTHESIS_CHAR = '(';

    public Autofix_SVTB_1_1_19(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            int endOffset;
            int startOffset;
            VerissimoAutofixAdditionalInfo hitAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (hitAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            if (!(hitAdditionalInfo.getElement() instanceof LiteralToken)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            LiteralToken token = (LiteralToken)hitAdditionalInfo.getElement();
            char firstChar = token.getStringToken().charAt(0);
            char lastChar = token.getStringToken().charAt(token.getLength() - 1);
            if (')' == firstChar) {
                startOffset = token.getOffsetFile() - token.getNoSpacesBefore();
                endOffset = token.getOffsetFile();
                this.addEditForHit(hit, file, new DeleteEditParameters(this, startOffset, endOffset - startOffset));
            }
            if ('(' != lastChar) continue;
            startOffset = token.getOffsetFile() + token.getLength();
            endOffset = startOffset + token.getNoSpacesAfter();
            this.addEditForHit(hit, file, new DeleteEditParameters(this, startOffset, endOffset - startOffset));
        }
    }
}

