/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;

public class Autofix_SVTB_1_1_20
extends VerissimoAutofix {
    public Autofix_SVTB_1_1_20(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        try {
            if (hits == null || hits.isEmpty()) {
                return;
            }
            for (OVMComplianceCheckHit hit : hits) {
                VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
                if (autofixAdditionalInfo == null) {
                    VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error.setReason("there is incomplete context (IC01)");
                    this.addError(error);
                    continue;
                }
                Object element = autofixAdditionalInfo.getElement();
                if (!(element instanceof Integer)) {
                    VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error.setReason("there is incomplete context (IC02)");
                    this.addError(error);
                    continue;
                }
                int startOffset = (Integer)element;
                int hitLine = hit.getLine() - 1;
                int lineLength = document.getLineLength(hitLine);
                int lineStartOffset = document.getLineOffset(hitLine);
                int endOffset = lineStartOffset + lineLength;
                boolean addedEdits = VerissimoAutofixEditsUtils.INSTANCE.parseCodeAndAddEdits(this, hit, file, document, startOffset, endOffset);
                if (addedEdits) continue;
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public boolean isValidCondition(char previousChar, char currentChar) {
        return previousChar != ' ' && currentChar == '#' || previousChar != ' ' && currentChar == '{';
    }

    @Override
    public void addEdit(OVMComplianceCheckHit hit, IFile file, int startOffset) {
        this.addEditForHit(hit, file, new InsertEditParameters(this, startOffset, " "));
    }
}

